/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public class GroupItemNotFoundException
extends ItemNotFoundException {
    private static final long serialVersionUID = -863009398540333419L;
    private final Map<Repository, Throwable> memberReasons;

    public GroupItemNotFoundException(ItemNotFoundException.ItemNotFoundInRepositoryReason reason, Map<Repository, Throwable> memberReasons) {
        super(reason);
        this.memberReasons = Collections.unmodifiableMap(new HashMap<Repository, Throwable>(memberReasons));
    }

    public GroupItemNotFoundException(ResourceStoreRequest request, GroupRepository repository, Map<Repository, Throwable> memberReasons) {
        this(GroupItemNotFoundException.reasonFor(request, repository, "Path %s not found in group repository %s.", request.getRequestPath(), RepositoryStringUtils.getHumanizedNameString(repository)), memberReasons);
    }

    @Override
    public ItemNotFoundException.ItemNotFoundInRepositoryReason getReason() {
        return (ItemNotFoundException.ItemNotFoundInRepositoryReason)super.getReason();
    }

    public Map<Repository, Throwable> getMemberReasons() {
        return this.memberReasons;
    }
}

