/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import org.sonatype.nexus.proxy.attributes.Attributes;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.walker.AbstractFileWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;

public class ExpireCacheWalker
extends AbstractFileWalkerProcessor {
    private final Repository repository;
    private int alteredItemCount;
    private boolean isMavenProxy;

    public ExpireCacheWalker(Repository repository) {
        this.repository = repository;
        this.alteredItemCount = 0;
        this.isMavenProxy = repository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class);
    }

    public Repository getRepository() {
        return this.repository;
    }

    @Override
    protected void processFileItem(WalkerContext context, StorageFileItem item) throws Exception {
        if (!item.isExpired()) {
            Attributes attributes;
            item.setExpired(true);
            if (this.isMavenProxy && ((attributes = item.getRepositoryItemAttributes()).containsKey("remote.sha1") || attributes.containsKey("remote.md5"))) {
                attributes.put("remote.hash.expired", "true");
            }
            this.getRepository().getAttributesHandler().storeAttributes(item);
            ++this.alteredItemCount;
        }
    }

    public boolean isCacheAltered() {
        return this.alteredItemCount > 0;
    }

    public int getAlteredItemCount() {
        return this.alteredItemCount;
    }
}

