/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import java.util.ArrayList;
import java.util.List;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.walker.AbstractFileWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerFilter;
import org.sonatype.nexus.proxy.wastebasket.DeleteOperation;

public class EvictUnusedItemsWalkerProcessor
extends AbstractFileWalkerProcessor {
    public static final String REQUIRED_FACET_KEY = "repository.facet";
    public static final Class<? extends Repository> DEFAULT_REQUIRED_FACET = ProxyRepository.class;
    private final long timestamp;
    private final ArrayList<String> files;

    public EvictUnusedItemsWalkerProcessor(long timestamp) {
        this.timestamp = timestamp;
        this.files = new ArrayList();
    }

    protected Class<? extends Repository> getRequiredFacet(WalkerContext context) {
        if (context.getContext().containsKey(REQUIRED_FACET_KEY)) {
            return (Class)context.getContext().get(REQUIRED_FACET_KEY);
        }
        return DEFAULT_REQUIRED_FACET;
    }

    protected Repository getRepository(WalkerContext ctx) {
        return ctx.getRepository();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<String> getFiles() {
        return this.files;
    }

    @Override
    public void beforeWalk(WalkerContext context) throws Exception {
        Class<? extends Repository> requiredFacet = this.getRequiredFacet(context);
        if (!this.getRepository(context).getRepositoryKind().isFacetAvailable(requiredFacet)) {
            context.stop(null);
        }
    }

    @Override
    public void processFileItem(WalkerContext ctx, StorageFileItem item) throws StorageException {
        try {
            if (item.getLastRequested() < this.getTimestamp()) {
                this.doDelete(ctx, item);
                this.getFiles().add(item.getPath());
            }
        }
        catch (IllegalOperationException e) {
            ctx.stop(e);
        }
        catch (UnsupportedStorageOperationException e) {
            ctx.stop(e);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    protected void doDelete(WalkerContext ctx, StorageFileItem item) throws StorageException, UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException {
        ResourceStoreRequest rsr = new ResourceStoreRequest(item);
        rsr.getRequestContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)DeleteOperation.DELETE_PERMANENTLY);
        this.getRepository(ctx).deleteItem(false, rsr);
    }

    @Override
    public void onCollectionExit(WalkerContext ctx, StorageCollectionItem coll) throws Exception {
        try {
            if (this.getRepository(ctx).list(false, coll).size() == 0) {
                ResourceStoreRequest rsr = new ResourceStoreRequest(coll);
                rsr.getRequestContext().put(DeleteOperation.DELETE_OPERATION_CTX_KEY, (Object)DeleteOperation.DELETE_PERMANENTLY);
                this.getRepository(ctx).deleteItem(false, rsr);
            }
        }
        catch (RepositoryNotAvailableException e) {
            ctx.stop(e);
        }
        catch (UnsupportedStorageOperationException e) {
            ctx.stop(e);
        }
        catch (ItemNotFoundException e) {
        }
        catch (StorageException e) {
            ctx.stop(e);
        }
    }

    public static class EvictUnusedItemsWalkerFilter
    implements WalkerFilter {
        @Override
        public boolean shouldProcess(WalkerContext context, StorageItem item) {
            return !item.getPath().startsWith("/.") && !item.getPath().startsWith(".");
        }

        @Override
        public boolean shouldProcessRecursively(WalkerContext context, StorageCollectionItem coll) {
            return this.shouldProcess(context, coll);
        }
    }
}

