/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDeleteItem;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class DeletionNotifierWalker
extends AbstractWalkerProcessor {
    private final EventBus eventBus;
    private final ResourceStoreRequest request;

    public DeletionNotifierWalker(EventBus eventBus, ResourceStoreRequest request) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.request = (ResourceStoreRequest)Preconditions.checkNotNull((Object)request);
    }

    @Override
    public final void processItem(WalkerContext context, StorageItem item) throws Exception {
        if (!(item instanceof StorageCollectionItem)) {
            item.getItemContext().setParentContext(this.request.getRequestContext());
            this.eventBus.post((Object)new RepositoryItemEventDeleteItem(context.getRepository(), item));
        }
    }
}

