/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sonatype.nexus.proxy.repository.RepositoryKind;

public class DefaultRepositoryKind
implements RepositoryKind {
    private final Class<?> mainFacet;
    private final Set<Class<?>> facets;

    public DefaultRepositoryKind(Class<?> mainFacet, Collection<Class<?>> facets) {
        this.mainFacet = mainFacet;
        this.facets = new HashSet();
        this.facets.add(mainFacet);
        if (facets != null) {
            this.facets.addAll(facets);
        }
    }

    @Override
    public Class<?> getMainFacet() {
        return this.mainFacet;
    }

    @Override
    public boolean isFacetAvailable(Class<?> f) {
        for (Class<?> facet : this.facets) {
            if (!f.isAssignableFrom(facet)) continue;
            return true;
        }
        return false;
    }
}

