/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Set;
import org.sonatype.nexus.proxy.repository.RemoteHttpProxySettings;
import org.sonatype.nexus.proxy.repository.RemoteProxySettings;

public class DefaultRemoteProxySettings
implements RemoteProxySettings {
    private RemoteHttpProxySettings httpProxySettings;
    private RemoteHttpProxySettings httpsProxySettings;
    private Set<String> nonProxyHosts = Sets.newHashSet();

    @Override
    public RemoteHttpProxySettings getHttpProxySettings() {
        return this.httpProxySettings;
    }

    @Override
    public void setHttpProxySettings(RemoteHttpProxySettings httpProxySettings) {
        this.httpProxySettings = httpProxySettings;
    }

    @Override
    public RemoteHttpProxySettings getHttpsProxySettings() {
        return this.httpsProxySettings;
    }

    @Override
    public void setHttpsProxySettings(RemoteHttpProxySettings httpsProxySettings) {
        this.httpsProxySettings = httpsProxySettings;
    }

    @Override
    public Set<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @Override
    public void setNonProxyHosts(Set<String> nonProxyHosts) {
        this.nonProxyHosts.clear();
        if (nonProxyHosts != null && !nonProxyHosts.isEmpty()) {
            this.nonProxyHosts.addAll(nonProxyHosts);
        }
    }

    @Override
    public RemoteHttpProxySettings getRemoteHttpProxySettingsFor(URL url) {
        return DefaultRemoteProxySettings.getRemoteHttpProxySettingsFor(url, this);
    }

    public static RemoteHttpProxySettings getRemoteHttpProxySettingsFor(URL url, RemoteProxySettings settings) {
        RemoteHttpProxySettings httpProxySettings;
        RemoteHttpProxySettings httpsProxySettings;
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)settings);
        if ("https".equals(url.getProtocol()) && (httpsProxySettings = settings.getHttpsProxySettings()) != null && httpsProxySettings.isEnabled()) {
            return httpsProxySettings;
        }
        if (("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) && (httpProxySettings = settings.getHttpProxySettings()) != null && httpProxySettings.isEnabled()) {
            return httpProxySettings;
        }
        return null;
    }
}

