/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import org.sonatype.nexus.proxy.repository.RemoteConnectionSettings;

public class DefaultRemoteConnectionSettings
implements RemoteConnectionSettings {
    private int connectionTimeout = 1000;
    private int retrievalRetryCount = 3;
    private String queryString;
    private String userAgentCustomizationString;

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public int getRetrievalRetryCount() {
        return this.retrievalRetryCount;
    }

    @Override
    public void setRetrievalRetryCount(int retrievalRetryCount) {
        this.retrievalRetryCount = retrievalRetryCount;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public String getUserAgentCustomizationString() {
        return this.userAgentCustomizationString;
    }

    @Override
    public void setUserAgentCustomizationString(String userAgentCustomizationString) {
        this.userAgentCustomizationString = userAgentCustomizationString;
    }

    public static RemoteConnectionSettings asReadOnly(RemoteConnectionSettings remoteConnectionSettings) {
        return new ReadOnlyRemoteConnectionSettings(remoteConnectionSettings);
    }

    public static class ReadOnlyRemoteConnectionSettings
    extends DefaultRemoteConnectionSettings {
        public ReadOnlyRemoteConnectionSettings(RemoteConnectionSettings remoteConnectionSettings) {
            super.setConnectionTimeout(remoteConnectionSettings.getConnectionTimeout());
            super.setQueryString(remoteConnectionSettings.getQueryString());
            super.setRetrievalRetryCount(remoteConnectionSettings.getRetrievalRetryCount());
            super.setUserAgentCustomizationString(remoteConnectionSettings.getUserAgentCustomizationString());
        }

        @Override
        public void setConnectionTimeout(int connectionTimeout) {
            throw new IllegalStateException("Parent instance is not modifiable!");
        }

        @Override
        public void setRetrievalRetryCount(int retrievalRetryCount) {
            throw new IllegalStateException("Parent instance is not modifiable!");
        }

        @Override
        public void setQueryString(String queryString) {
            throw new IllegalStateException("Parent instance is not modifiable!");
        }

        @Override
        public void setUserAgentCustomizationString(String userAgentCustomizationString) {
            throw new IllegalStateException("Parent instance is not modifiable!");
        }
    }
}

