/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import org.codehaus.plexus.util.StringUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.AbstractRemovableConfigurable;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.mirror.DefaultPublishedMirrors;
import org.sonatype.nexus.proxy.mirror.PublishedMirrors;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.RepositoryWritePolicy;

public class ConfigurableRepository
extends AbstractRemovableConfigurable<CRepository> {
    private PublishedMirrors pMirrors;

    public ConfigurableRepository() {
    }

    public ConfigurableRepository(ApplicationConfiguration applicationConfiguration) {
        this.setApplicationConfiguration(applicationConfiguration);
    }

    public CRepositoryCoreConfiguration getCurrentCoreConfiguration() {
        return (CRepositoryCoreConfiguration)super.getCurrentCoreConfiguration();
    }

    protected CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory() {
        return null;
    }

    protected CRepositoryCoreConfiguration wrapConfiguration(Object configuration) throws ConfigurationException {
        if (configuration instanceof CRepository) {
            return new CRepositoryCoreConfiguration(this.getApplicationConfiguration(), (CRepository)configuration, this.getExternalConfigurationHolderFactory());
        }
        if (configuration instanceof CRepositoryCoreConfiguration) {
            return (CRepositoryCoreConfiguration)configuration;
        }
        throw new ConfigurationException("The passed configuration object is of class \"" + configuration.getClass().getName() + "\" and not the required \"" + CRepository.class.getName() + "\"!");
    }

    public String getProviderRole() {
        return ((CRepository)this.getCurrentConfiguration(false)).getProviderRole();
    }

    public String getProviderHint() {
        return ((CRepository)this.getCurrentConfiguration(false)).getProviderHint();
    }

    public String getId() {
        return ((CRepository)this.getCurrentConfiguration(false)).getId();
    }

    public void setId(String id) {
        ((CRepository)this.getCurrentConfiguration(true)).setId(id);
    }

    public String getName() {
        return ((CRepository)this.getCurrentConfiguration(false)).getName();
    }

    public void setName(String name) {
        ((CRepository)this.getCurrentConfiguration(true)).setName(name);
    }

    public String getPathPrefix() {
        String pathPrefix = ((CRepository)this.getCurrentConfiguration(false)).getPathPrefix();
        if (!StringUtils.isBlank((String)pathPrefix)) {
            return pathPrefix;
        }
        return this.getId();
    }

    public void setPathPrefix(String prefix) {
        ((CRepository)this.getCurrentConfiguration(true)).setPathPrefix(prefix);
    }

    public boolean isIndexable() {
        return ((CRepository)this.getCurrentConfiguration(false)).isIndexable();
    }

    public void setIndexable(boolean indexable) {
        ((CRepository)this.getCurrentConfiguration(true)).setIndexable(indexable);
    }

    public boolean isSearchable() {
        return ((CRepository)this.getCurrentConfiguration(false)).isSearchable();
    }

    public void setSearchable(boolean searchable) {
        ((CRepository)this.getCurrentConfiguration(true)).setSearchable(searchable);
    }

    public String getLocalUrl() {
        if (((CRepository)this.getCurrentConfiguration(false)).getLocalStorage() == null || StringUtils.isEmpty((String)((CRepository)this.getCurrentConfiguration(false)).getLocalStorage().getUrl())) {
            return ((CRepository)this.getCurrentConfiguration((boolean)false)).defaultLocalStorageUrl;
        }
        return ((CRepository)this.getCurrentConfiguration(false)).getLocalStorage().getUrl();
    }

    public void setLocalUrl(String localUrl) throws LocalStorageException {
        String newLocalUrl = null;
        if (!StringUtils.isEmpty((String)localUrl)) {
            newLocalUrl = localUrl.trim();
        }
        if (newLocalUrl != null && newLocalUrl.endsWith("/")) {
            newLocalUrl = newLocalUrl.substring(0, newLocalUrl.length() - 1);
        }
        ((CRepository)this.getCurrentConfiguration(true)).getLocalStorage().setUrl(newLocalUrl);
    }

    public LocalStatus getLocalStatus() {
        if (((CRepository)this.getCurrentConfiguration(false)).getLocalStatus() == null) {
            return null;
        }
        return LocalStatus.valueOf(((CRepository)this.getCurrentConfiguration(false)).getLocalStatus());
    }

    public void setLocalStatus(LocalStatus localStatus) {
        ((CRepository)this.getCurrentConfiguration(true)).setLocalStatus(localStatus.toString());
    }

    public RepositoryWritePolicy getWritePolicy() {
        return RepositoryWritePolicy.valueOf(((CRepository)this.getCurrentConfiguration(false)).getWritePolicy());
    }

    public void setWritePolicy(RepositoryWritePolicy writePolicy) {
        ((CRepository)this.getCurrentConfiguration(true)).setWritePolicy(writePolicy.name());
    }

    public boolean isBrowseable() {
        return ((CRepository)this.getCurrentConfiguration(false)).isBrowseable();
    }

    public void setBrowseable(boolean browseable) {
        ((CRepository)this.getCurrentConfiguration(true)).setBrowseable(browseable);
    }

    public boolean isUserManaged() {
        return ((CRepository)this.getCurrentConfiguration(false)).isUserManaged();
    }

    public void setUserManaged(boolean userManaged) {
        ((CRepository)this.getCurrentConfiguration(true)).setUserManaged(userManaged);
    }

    public boolean isExposed() {
        return ((CRepository)this.getCurrentConfiguration(false)).isExposed();
    }

    public void setExposed(boolean exposed) {
        ((CRepository)this.getCurrentConfiguration(true)).setExposed(exposed);
    }

    public int getNotFoundCacheTimeToLive() {
        return ((CRepository)this.getCurrentConfiguration(false)).getNotFoundCacheTTL();
    }

    public void setNotFoundCacheTimeToLive(int notFoundCacheTimeToLive) {
        ((CRepository)this.getCurrentConfiguration(true)).setNotFoundCacheTTL(notFoundCacheTimeToLive);
    }

    public boolean isNotFoundCacheActive() {
        return ((CRepository)this.getCurrentConfiguration(false)).isNotFoundCacheActive();
    }

    public void setNotFoundCacheActive(boolean notFoundCacheActive) {
        ((CRepository)this.getCurrentConfiguration(true)).setNotFoundCacheActive(notFoundCacheActive);
    }

    public PublishedMirrors getPublishedMirrors() {
        if (this.pMirrors == null) {
            this.pMirrors = new DefaultPublishedMirrors(this.getCurrentCoreConfiguration());
        }
        return this.pMirrors;
    }

    public String toString() {
        CRepository crepository;
        String repoId = "not-configured-yet";
        CRepositoryCoreConfiguration currentCoreConfiguration = this.getCurrentCoreConfiguration();
        if (currentCoreConfiguration != null && (crepository = (CRepository)currentCoreConfiguration.getConfiguration(false)) != null && crepository.getId() != null && crepository.getId().trim().length() > 0) {
            repoId = crepository.getId();
        }
        return String.format("%s(id=%s)", ((Object)((Object)this)).getClass().getSimpleName(), repoId);
    }
}

