/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import java.util.Collection;
import java.util.List;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.AbstractRepository;
import org.sonatype.nexus.proxy.repository.AbstractWebSiteRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.WebSiteRepository;

public abstract class AbstractWebSiteRepository
extends AbstractRepository
implements WebSiteRepository {
    @Override
    protected AbstractWebSiteRepositoryConfiguration getExternalConfiguration(boolean forModification) {
        return (AbstractWebSiteRepositoryConfiguration)super.getExternalConfiguration(forModification);
    }

    @Override
    public List<String> getWelcomeFiles() {
        return this.getExternalConfiguration(false).getWelcomeFiles();
    }

    @Override
    public void setWelcomeFiles(List<String> vals) {
        this.getExternalConfiguration(true).setWelcomeFiles(vals);
    }

    @Override
    protected StorageItem doRetrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        boolean useWelcomeFiles;
        StorageItem result = super.doRetrieveItem(request);
        List<String> wf = this.getWelcomeFiles();
        boolean bl = useWelcomeFiles = !request.getRequestContext().containsKey("useWelcomeFiles") || Boolean.TRUE.equals(request.getRequestContext().get("useWelcomeFiles"));
        if (useWelcomeFiles && result instanceof StorageCollectionItem && wf.size() > 0) {
            Collection<StorageItem> collItems = this.list(false, (StorageCollectionItem)result);
            for (StorageItem item : collItems) {
                if (!(item instanceof StorageFileItem) || !wf.contains(item.getName())) continue;
                return item;
            }
        }
        return result;
    }
}

