/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.validator.ApplicationValidationResponse;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepositoryConfigurator;
import org.sonatype.nexus.proxy.repository.AbstractShadowRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.IncompatibleMasterRepositoryException;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryWritePolicy;
import org.sonatype.nexus.proxy.repository.ShadowRepository;

public abstract class AbstractShadowRepositoryConfigurator
extends AbstractProxyRepositoryConfigurator {
    @Override
    public void doApplyConfiguration(Repository repository, ApplicationConfiguration configuration, CRepositoryCoreConfiguration coreConfig) throws ConfigurationException {
        repository.setWritePolicy(RepositoryWritePolicy.READ_ONLY);
        super.doApplyConfiguration(repository, configuration, coreConfig);
        ShadowRepository shadowRepository = repository.adaptToFacet(ShadowRepository.class);
        AbstractShadowRepositoryConfiguration extConf = (AbstractShadowRepositoryConfiguration)coreConfig.getExternalConfiguration().getConfiguration(false);
        try {
            shadowRepository.setMasterRepository(this.getRepositoryRegistry().getRepository(extConf.getMasterRepositoryId()));
        }
        catch (IncompatibleMasterRepositoryException e) {
            ValidationMessage message = new ValidationMessage("shadowOf", e.getMessage(), "The source nexus repository is of an invalid Format.");
            ApplicationValidationResponse response = new ApplicationValidationResponse();
            response.addValidationError(message);
            throw new InvalidConfigurationException((ValidationResponse)response);
        }
        catch (NoSuchRepositoryException e) {
            ValidationMessage message = new ValidationMessage("shadowOf", e.getMessage(), "The source nexus repository is not existing.");
            ApplicationValidationResponse response = new ApplicationValidationResponse();
            response.addValidationError(message);
            throw new InvalidConfigurationException((ValidationResponse)response);
        }
    }
}

