/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.events.RepositoryItemEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemEventCache;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDelete;
import org.sonatype.nexus.proxy.events.RepositoryItemEventStore;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.StorageLinkItem;
import org.sonatype.nexus.proxy.repository.AbstractRepository;
import org.sonatype.nexus.proxy.repository.AbstractShadowRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.IncompatibleMasterRepositoryException;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.proxy.walker.AbstractFileWalkerProcessor;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;

public abstract class AbstractShadowRepository
extends AbstractRepository
implements ShadowRepository {
    private volatile Repository masterRepository;

    @Override
    protected AbstractShadowRepositoryConfiguration getExternalConfiguration(boolean forModification) {
        return (AbstractShadowRepositoryConfiguration)super.getExternalConfiguration(forModification);
    }

    @Override
    public boolean isSynchronizeAtStartup() {
        return this.getExternalConfiguration(false).isSynchronizeAtStartup();
    }

    @Override
    public void setSynchronizeAtStartup(boolean val) {
        this.getExternalConfiguration(true).setSynchronizeAtStartup(val);
    }

    @Override
    public Repository getMasterRepository() {
        return this.masterRepository;
    }

    @Override
    public void setMasterRepository(Repository masterRepository) throws IncompatibleMasterRepositoryException {
        if (!this.getMasterRepositoryContentClass().getId().equals(masterRepository.getRepositoryContentClass().getId())) {
            throw new IncompatibleMasterRepositoryException(this, masterRepository.getId());
        }
        this.getExternalConfiguration(true).setMasterRepositoryId(masterRepository.getId());
        this.masterRepository = masterRepository;
    }

    @Override
    public LocalStatus getLocalStatus() {
        return super.getLocalStatus().shouldServiceRequest() && this.getMasterRepository().getLocalStatus().shouldServiceRequest() ? LocalStatus.IN_SERVICE : LocalStatus.OUT_OF_SERVICE;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRepositoryItemEvent(RepositoryItemEvent ievt) {
        if (!this.getLocalStatus().shouldServiceRequest()) {
            return;
        }
        if (this.getMasterRepository() == ievt.getRepository()) {
            try {
                if (ievt instanceof RepositoryItemEventStore || ievt instanceof RepositoryItemEventCache) {
                    this.createLink(ievt.getItem());
                } else if (ievt instanceof RepositoryItemEventDelete) {
                    this.deleteLink(ievt.getItem());
                }
            }
            catch (UnsupportedStorageOperationException e) {
                this.log.debug("Shadow {} refuses to maintain links, ignoring event {}", new Object[]{this, ievt, e});
            }
            catch (IllegalOperationException e) {
                this.log.debug("Shadow {} refuses to maintain links, ignoring event {}", new Object[]{this, ievt, e});
            }
            catch (ItemNotFoundException e) {
                this.log.debug("Corresponding item in {} for master path not found, ignoring event {}", (Object)this, (Object)ievt);
            }
            catch (Exception e) {
                this.log.warn("Could not sync shadow {} for event {}", new Object[]{this, ievt, e});
            }
        }
    }

    protected abstract void deleteLink(StorageItem var1) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException;

    protected abstract StorageLinkItem createLink(StorageItem var1) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException;

    protected void synchronizeLink(StorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        this.createLink(item);
    }

    @Override
    public void synchronizeWithMaster() {
        block3: {
            if (!this.getLocalStatus().shouldServiceRequest()) {
                return;
            }
            this.log.info("Syncing shadow " + this.getId() + " with master repository " + this.getMasterRepository().getId());
            ResourceStoreRequest root = new ResourceStoreRequest("/", true);
            this.expireNotFoundCaches(root);
            AbstractFileWalkerProcessor sw = new AbstractFileWalkerProcessor(){

                @Override
                protected void processFileItem(WalkerContext context, StorageFileItem item) throws Exception {
                    AbstractShadowRepository.this.synchronizeLink(item);
                }
            };
            DefaultWalkerContext ctx = new DefaultWalkerContext(this.getMasterRepository(), root);
            ctx.getProcessors().add(sw);
            try {
                this.getWalker().walk(ctx);
            }
            catch (WalkerException e) {
                if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block3;
                throw e;
            }
        }
    }

    protected StorageItem doRetrieveItemFromMaster(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        try {
            return this.getMasterRepository().retrieveItem(request);
        }
        catch (AccessDeniedException e) {
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Path %s not found in repository %s", RepositoryStringUtils.getHumanizedNameString(this)), (Throwable)e);
        }
    }
}

