/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Map;
import javax.inject.Inject;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CLocalStorage;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.validator.ApplicationValidationResponse;
import org.sonatype.nexus.plugins.RepositoryCustomizer;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.local.LocalRepositoryStorage;
import org.sonatype.nexus.proxy.storage.local.LocalStorageContext;

public abstract class AbstractRepositoryConfigurator
implements Configurator<Repository, CRepositoryCoreConfiguration> {
    private RepositoryRegistry repositoryRegistry;
    private Map<String, LocalRepositoryStorage> localRepositoryStorages;
    private Map<String, RepositoryCustomizer> pluginRepositoryConfigurators;

    @Inject
    public void populateAbstractRepositoryConfigurator(RepositoryRegistry repositoryRegistry, Map<String, LocalRepositoryStorage> localRepositoryStorages, Map<String, RepositoryCustomizer> pluginRepositoryConfigurators) {
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.localRepositoryStorages = (Map)Preconditions.checkNotNull(localRepositoryStorages);
        this.pluginRepositoryConfigurators = (Map)Preconditions.checkNotNull(pluginRepositoryConfigurators);
    }

    @Override
    public final void applyConfiguration(Repository target, ApplicationConfiguration configuration, CRepositoryCoreConfiguration config) throws ConfigurationException {
        this.doApplyConfiguration(target, configuration, config);
        if (this.pluginRepositoryConfigurators != null) {
            for (RepositoryCustomizer configurator : this.pluginRepositoryConfigurators.values()) {
                if (!configurator.isHandledRepository(target)) continue;
                configurator.configureRepository(target);
            }
        }
    }

    @Override
    public final void prepareForSave(Repository target, ApplicationConfiguration configuration, CRepositoryCoreConfiguration config) {
        this.doPrepareForSave(target, configuration, config);
    }

    protected void doApplyConfiguration(Repository repository, ApplicationConfiguration configuration, CRepositoryCoreConfiguration coreConfiguration) throws ConfigurationException {
        boolean usingDefaultLocalUrl;
        String localUrl;
        CRepository repo = (CRepository)coreConfiguration.getConfiguration(true);
        File defaultStorageFile = new File(new File(configuration.getWorkingDirectory(), "storage"), repo.getId());
        try {
            repo.defaultLocalStorageUrl = defaultStorageFile.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new InvalidConfigurationException("Malformed URL for LocalRepositoryStorage!", (Throwable)e);
        }
        if (repo.getLocalStorage() != null && !Strings.isNullOrEmpty((String)repo.getLocalStorage().getUrl())) {
            localUrl = repo.getLocalStorage().getUrl();
            usingDefaultLocalUrl = false;
        } else {
            localUrl = repo.defaultLocalStorageUrl;
            usingDefaultLocalUrl = true;
        }
        if (repo.getLocalStorage() == null) {
            repo.setLocalStorage(new CLocalStorage());
            repo.getLocalStorage().setProvider("file");
        }
        LocalRepositoryStorage ls = this.getLocalRepositoryStorage(repo.getId(), repo.getLocalStorage().getProvider());
        try {
            ls.validateStorageUrl(localUrl);
            if (!usingDefaultLocalUrl) {
                repo.getLocalStorage().setUrl(localUrl);
            }
            repository.setLocalStorage(ls);
            LocalStorageContext ctx = repository.getLocalStorageContext();
            if (ctx != null) {
                ctx.incrementGeneration();
            }
        }
        catch (LocalStorageException e) {
            ApplicationValidationResponse response = new ApplicationValidationResponse();
            ValidationMessage error = new ValidationMessage("overrideLocalStorageUrl", "Repository has an invalid local storage URL '" + localUrl, "Invalid file location");
            response.addValidationError(error);
            throw new InvalidConfigurationException((ValidationResponse)response);
        }
        if (repository.getNotFoundCache() != null) {
            repository.getNotFoundCache().purge();
        }
    }

    protected void doPrepareForSave(Repository repository, ApplicationConfiguration configuration, CRepositoryCoreConfiguration coreConfiguration) {
    }

    protected RepositoryRegistry getRepositoryRegistry() {
        return this.repositoryRegistry;
    }

    protected LocalRepositoryStorage getLocalRepositoryStorage(String repoId, String provider) throws InvalidConfigurationException {
        LocalRepositoryStorage result = this.localRepositoryStorages.get(provider);
        if (result != null) {
            return result;
        }
        throw new InvalidConfigurationException("Repository " + repoId + " have local storage with unsupported provider: " + provider);
    }
}

