/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.plexus.util.StringUtils;
import org.joda.time.DateTime;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.Configurator;
import org.sonatype.nexus.configuration.ExternalConfiguration;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.model.CRepositoryExternalConfigurationHolderFactory;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.mime.MimeSupport;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.access.AccessManager;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.attributes.AttributesHandler;
import org.sonatype.nexus.proxy.cache.CacheManager;
import org.sonatype.nexus.proxy.cache.PathCache;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryEventExpireNotFoundCaches;
import org.sonatype.nexus.proxy.events.RepositoryEventLocalStatusChanged;
import org.sonatype.nexus.proxy.events.RepositoryEventRecreateAttributes;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDeleteRoot;
import org.sonatype.nexus.proxy.events.RepositoryItemEventRetrieve;
import org.sonatype.nexus.proxy.events.RepositoryItemEventStoreCreate;
import org.sonatype.nexus.proxy.events.RepositoryItemEventStoreUpdate;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.ContentGenerator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageCollectionItem;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.DefaultStorageNotFoundItem;
import org.sonatype.nexus.proxy.item.PreparedContentLocator;
import org.sonatype.nexus.proxy.item.ReadLockingContentLocator;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidFactory;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsRemotelyAccessibleAttribute;
import org.sonatype.nexus.proxy.item.uid.RepositoryItemUidAttributeManager;
import org.sonatype.nexus.proxy.repository.AbstractRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.ConfigurableRepository;
import org.sonatype.nexus.proxy.repository.DeletionNotifierWalker;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.NoopRepositoryMetadataManager;
import org.sonatype.nexus.proxy.repository.RecreateAttributesWalker;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryMetadataManager;
import org.sonatype.nexus.proxy.repository.RepositoryWritePolicy;
import org.sonatype.nexus.proxy.repository.RequestStrategy;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.storage.local.DefaultLocalStorageContext;
import org.sonatype.nexus.proxy.storage.local.LocalRepositoryStorage;
import org.sonatype.nexus.proxy.storage.local.LocalStorageContext;
import org.sonatype.nexus.proxy.targets.TargetRegistry;
import org.sonatype.nexus.proxy.targets.TargetSet;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.ParentOMatic;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

public abstract class AbstractRepository
extends ConfigurableRepository
implements Repository {
    private CacheManager cacheManager;
    private TargetRegistry targetRegistry;
    private RepositoryItemUidFactory repositoryItemUidFactory;
    private RepositoryItemUidAttributeManager repositoryItemUidAttributeManager;
    private Walker walker;
    private MimeSupport mimeSupport;
    private Map<String, ContentGenerator> contentGenerators;
    private AttributesHandler attributesHandler;
    private AccessManager accessManager;
    private LocalStorageContext localStorageContext;
    private PathCache notFoundCache;
    private final Map<String, RequestStrategy> requestStrategies = Maps.newHashMap();
    private LocalRepositoryStorage localStorage;
    private boolean localUrlChanged = false;
    private boolean madeSearchable = false;
    private boolean localStatusChanged = false;

    @Inject
    public void populateAbstractRepository(CacheManager cacheManager, TargetRegistry targetRegistry, RepositoryItemUidFactory repositoryItemUidFactory, RepositoryItemUidAttributeManager repositoryItemUidAttributeManager, AccessManager accessManager, Walker walker, MimeSupport mimeSupport, Map<String, ContentGenerator> contentGenerators, AttributesHandler attributesHandler) {
        this.cacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManager);
        this.targetRegistry = (TargetRegistry)Preconditions.checkNotNull((Object)targetRegistry);
        this.repositoryItemUidFactory = (RepositoryItemUidFactory)Preconditions.checkNotNull((Object)repositoryItemUidFactory);
        this.repositoryItemUidAttributeManager = (RepositoryItemUidAttributeManager)Preconditions.checkNotNull((Object)repositoryItemUidAttributeManager);
        this.walker = (Walker)Preconditions.checkNotNull((Object)walker);
        this.mimeSupport = (MimeSupport)Preconditions.checkNotNull((Object)mimeSupport);
        this.contentGenerators = (Map)Preconditions.checkNotNull(contentGenerators);
        this.attributesHandler = (AttributesHandler)Preconditions.checkNotNull((Object)attributesHandler);
        this.accessManager = (AccessManager)Preconditions.checkNotNull((Object)accessManager);
        this.localStorageContext = new DefaultLocalStorageContext(this.getApplicationConfiguration().getGlobalLocalStorageContext());
    }

    protected MimeSupport getMimeSupport() {
        return this.mimeSupport;
    }

    @Override
    public MimeRulesSource getMimeRulesSource() {
        return MimeRulesSource.NOOP;
    }

    @Override
    protected abstract Configurator getConfigurator();

    @Override
    protected abstract CRepositoryExternalConfigurationHolderFactory<?> getExternalConfigurationHolderFactory();

    @Override
    protected void doConfigure() throws ConfigurationException {
        super.doConfigure();
        if (this.notFoundCache == null) {
            this.notFoundCache = this.cacheManager.getPathCache(this.getId());
        }
    }

    @Override
    public boolean commitChanges() throws ConfigurationException {
        boolean wasDirty = super.commitChanges();
        if (wasDirty) {
            this.eventBus().post((Object)this.getRepositoryConfigurationUpdatedEvent());
        }
        this.localUrlChanged = false;
        this.madeSearchable = false;
        this.localStatusChanged = false;
        return wasDirty;
    }

    @Override
    public boolean rollbackChanges() {
        this.localUrlChanged = false;
        this.madeSearchable = false;
        this.localStatusChanged = false;
        return super.rollbackChanges();
    }

    protected RepositoryConfigurationUpdatedEvent getRepositoryConfigurationUpdatedEvent() {
        RepositoryConfigurationUpdatedEvent event = new RepositoryConfigurationUpdatedEvent(this);
        event.setLocalUrlChanged(this.localUrlChanged);
        event.setMadeSearchable(this.madeSearchable);
        event.setLocalStatusChanged(this.localStatusChanged);
        return event;
    }

    protected AbstractRepositoryConfiguration getExternalConfiguration(boolean forModification) {
        ExternalConfiguration<?> ec;
        CRepositoryCoreConfiguration cc = this.getCurrentCoreConfiguration();
        if (cc != null && (ec = cc.getExternalConfiguration()) != null) {
            return (AbstractRepositoryConfiguration)ec.getConfiguration(forModification);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStrategy registerRequestStrategy(String key, RequestStrategy strategy) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)strategy);
        Map<String, RequestStrategy> map = this.requestStrategies;
        synchronized (map) {
            return this.requestStrategies.put(key, strategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestStrategy unregisterRequestStrategy(String key) {
        Preconditions.checkNotNull((Object)key);
        Map<String, RequestStrategy> map = this.requestStrategies;
        synchronized (map) {
            return this.requestStrategies.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, RequestStrategy> getRegisteredStrategies() {
        Map<String, RequestStrategy> map = this.requestStrategies;
        synchronized (map) {
            return Maps.newHashMap(this.requestStrategies);
        }
    }

    protected RepositoryItemUidFactory getRepositoryItemUidFactory() {
        return this.repositoryItemUidFactory;
    }

    @Override
    public PathCache getNotFoundCache() {
        return this.notFoundCache;
    }

    @Override
    public void setIndexable(boolean indexable) {
        if (!this.isIndexable() && indexable) {
            this.madeSearchable = true;
        }
        super.setIndexable(indexable);
    }

    @Override
    public void setLocalUrl(String localUrl) throws LocalStorageException {
        String newLocalUrl = null;
        if (localUrl != null) {
            newLocalUrl = localUrl.trim();
        }
        if (newLocalUrl != null) {
            if (newLocalUrl.endsWith("/")) {
                newLocalUrl = newLocalUrl.substring(0, newLocalUrl.length() - 1);
            }
            this.getLocalStorage().validateStorageUrl(newLocalUrl);
        }
        if (((CRepository)this.getCurrentConfiguration(false)).getLocalStorage() != null && !StringUtils.equals((String)newLocalUrl, (String)((CRepository)this.getCurrentConfiguration(false)).getLocalStorage().getUrl())) {
            this.localUrlChanged = true;
        }
        super.setLocalUrl(localUrl);
    }

    @Override
    public void setLocalStatus(LocalStatus localStatus) {
        if (!localStatus.equals((Object)this.getLocalStatus())) {
            LocalStatus oldLocalStatus = this.getLocalStatus();
            super.setLocalStatus(localStatus);
            this.localStatusChanged = true;
            this.eventBus().post((Object)new RepositoryEventLocalStatusChanged(this, oldLocalStatus, localStatus));
        }
    }

    @Override
    public <F> F adaptToFacet(Class<F> t) {
        if (this.getRepositoryKind().isFacetAvailable(t)) {
            return (F)this;
        }
        return null;
    }

    protected Walker getWalker() {
        return this.walker;
    }

    protected Map<String, ContentGenerator> getContentGenerators() {
        return this.contentGenerators;
    }

    @Override
    public AccessManager getAccessManager() {
        return this.accessManager;
    }

    @VisibleForTesting
    public void setAccessManager(AccessManager accessManager) {
        this.accessManager = accessManager;
    }

    protected boolean shouldServiceOperation(ResourceStoreRequest request, String action) {
        if (!this.getLocalStatus().shouldServiceRequest()) {
            this.log.debug("Not performing {}, {} is not in service.", (Object)action, (Object)this);
            return false;
        }
        if (request.getProcessedRepositories().contains(this.getId())) {
            this.log.debug("Not performing {}, {} was already processed in this request.", (Object)action, (Object)this);
            return false;
        }
        request.addProcessedRepository(this.getId());
        return true;
    }

    @Override
    public final void expireCaches(ResourceStoreRequest request) {
        this.expireCaches(request, null);
    }

    @Override
    public final boolean expireCaches(ResourceStoreRequest request, WalkerFilter filter) {
        if (!this.shouldServiceOperation(request, "expireCaches")) {
            return false;
        }
        this.log.debug("Expiring caches in repository {} from path='{}'", (Object)this, (Object)request.getRequestPath());
        return this.doExpireCaches(request, filter);
    }

    protected boolean doExpireCaches(ResourceStoreRequest request, WalkerFilter filter) {
        return this.doExpireNotFoundCaches(request, filter);
    }

    @Override
    public final void expireNotFoundCaches(ResourceStoreRequest request) {
        this.expireNotFoundCaches(request, null);
    }

    @Override
    public final boolean expireNotFoundCaches(ResourceStoreRequest request, WalkerFilter filter) {
        if (!this.shouldServiceOperation(request, "expireNotFoundCaches")) {
            return false;
        }
        this.log.debug("Expiring NFC caches in repository {} from path='{}'", (Object)this, (Object)request.getRequestPath());
        return this.doExpireNotFoundCaches(request, filter);
    }

    protected boolean doExpireNotFoundCaches(ResourceStoreRequest request, WalkerFilter filter) {
        boolean cacheAltered;
        block9: {
            block7: {
                block8: {
                    if (StringUtils.isBlank((String)request.getRequestPath())) {
                        request.setRequestPath("/");
                    }
                    cacheAltered = false;
                    if (filter != null) break block7;
                    if (!"/".equals(request.getRequestPath())) break block8;
                    if (this.getNotFoundCache() != null) {
                        cacheAltered = this.getNotFoundCache().purge();
                    }
                    break block9;
                }
                if (this.getNotFoundCache() == null) break block9;
                boolean altered1 = this.getNotFoundCache().removeWithParents(request.getRequestPath());
                boolean altered2 = this.getNotFoundCache().removeWithChildren(request.getRequestPath());
                cacheAltered = altered1 || altered2;
                break block9;
            }
            ParentOMatic parentOMatic = new ParentOMatic(false);
            DefaultWalkerContext context = new DefaultWalkerContext(this, request);
            Collection<String> nfcPaths = this.getNotFoundCache().listKeysInCache();
            for (String nfcPath : nfcPaths) {
                DefaultStorageNotFoundItem nfcItem = new DefaultStorageNotFoundItem(this, new ResourceStoreRequest(nfcPath));
                if (!filter.shouldProcess(context, nfcItem)) continue;
                parentOMatic.addAndMarkPath(nfcPath);
            }
            for (String path : parentOMatic.getMarkedPaths()) {
                boolean removed = this.getNotFoundCache().remove(path);
                cacheAltered = cacheAltered || removed;
            }
        }
        if (this.log.isDebugEnabled()) {
            if (cacheAltered) {
                this.log.info("NFC for repository {} from path='{}' was cleared.", (Object)this, (Object)request.getRequestPath());
            } else {
                this.log.debug("Clear NFC for repository {} from path='{}' did not alter cache.", (Object)this, (Object)request.getRequestPath());
            }
        }
        this.eventBus().post((Object)new RepositoryEventExpireNotFoundCaches(this, request.getRequestPath(), request.getRequestContext().flatten(), cacheAltered));
        return cacheAltered;
    }

    @Override
    public RepositoryMetadataManager getRepositoryMetadataManager() {
        return new NoopRepositoryMetadataManager();
    }

    @Override
    public final Collection<String> evictUnusedItems(ResourceStoreRequest request, long timestamp) {
        if (!this.shouldServiceOperation(request, "evictUnusedItems")) {
            return Collections.emptyList();
        }
        this.log.debug("Evicting unused items in repository {}, from path='{}'", (Object)this, (Object)request.getRequestPath());
        return this.doEvictUnusedItems(request, timestamp);
    }

    protected Collection<String> doEvictUnusedItems(ResourceStoreRequest request, long timestamp) {
        return Collections.emptyList();
    }

    @Override
    public final boolean recreateAttributes(ResourceStoreRequest request, Map<String, String> initialData) {
        block4: {
            if (!this.shouldServiceOperation(request, "recreateAttributes")) {
                return false;
            }
            if (StringUtils.isEmpty((String)request.getRequestPath())) {
                request.setRequestPath("/");
            }
            this.log.info("Rebuilding item attributes in repository {} from path='{}'", (Object)this, (Object)request.getRequestPath());
            RecreateAttributesWalker walkerProcessor = new RecreateAttributesWalker(this, initialData);
            DefaultWalkerContext ctx = new DefaultWalkerContext(this, request);
            ctx.getProcessors().add(walkerProcessor);
            try {
                this.getWalker().walk(ctx);
            }
            catch (WalkerException e) {
                if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block4;
                throw e;
            }
        }
        this.eventBus().post((Object)new RepositoryEventRecreateAttributes(this));
        return true;
    }

    @Override
    public AttributesHandler getAttributesHandler() {
        return this.attributesHandler;
    }

    @Override
    public LocalStorageContext getLocalStorageContext() {
        return this.localStorageContext;
    }

    @Override
    public LocalRepositoryStorage getLocalStorage() {
        return this.localStorage;
    }

    @Override
    public void setLocalStorage(LocalRepositoryStorage localStorage) {
        ((CRepository)this.getCurrentConfiguration(true)).getLocalStorage().setProvider(localStorage.getProviderId());
        this.localStorage = localStorage;
    }

    @Override
    public StorageItem retrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkConditions(request, Action.read);
        StorageItem item = this.retrieveItem(false, request);
        if (StorageCollectionItem.class.isAssignableFrom(item.getClass()) && !this.isBrowseable()) {
            this.log.debug(this.getId() + " retrieveItem() :: FOUND a collection on " + request.toString() + " but repository is not Browseable.");
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Repository %s is not browsable", this));
        }
        this.checkPostConditions(request, item);
        return item;
    }

    @Override
    public void copyItem(ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkConditions(from, Action.read);
        this.checkConditions(to, this.getResultingActionOnWrite(to));
        this.copyItem(false, from, to);
    }

    @Override
    public void moveItem(ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkConditions(from, Action.read);
        this.checkConditions(from, Action.delete);
        this.checkConditions(to, this.getResultingActionOnWrite(to));
        this.moveItem(false, from, to);
    }

    @Override
    public void deleteItem(ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkConditions(request, Action.delete);
        this.deleteItem(false, request);
    }

    @Override
    public void storeItem(ResourceStoreRequest request, InputStream is, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException, AccessDeniedException {
        try {
            this.checkConditions(request, this.getResultingActionOnWrite(request));
        }
        catch (ItemNotFoundException e) {
            throw new AccessDeniedException(request, e.getMessage());
        }
        DefaultStorageFileItem fItem = new DefaultStorageFileItem(this, request, true, true, (ContentLocator)new PreparedContentLocator(is, this.getMimeSupport().guessMimeTypeFromPath(this.getMimeRulesSource(), request.getRequestPath()), -1L));
        if (userAttributes != null) {
            fItem.getRepositoryItemAttributes().putAll(userAttributes);
        }
        this.storeItem(false, fItem);
    }

    @Override
    public void createCollection(ResourceStoreRequest request, Map<String, String> userAttributes) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException, AccessDeniedException {
        try {
            this.checkConditions(request, this.getResultingActionOnWrite(request));
        }
        catch (ItemNotFoundException e) {
            throw new AccessDeniedException(request, e.getMessage());
        }
        DefaultStorageCollectionItem coll = new DefaultStorageCollectionItem(this, request, true, true);
        if (userAttributes != null) {
            coll.getRepositoryItemAttributes().putAll(userAttributes);
        }
        this.storeItem(false, coll);
    }

    @Override
    public Collection<StorageItem> list(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException, AccessDeniedException {
        this.checkConditions(request, Action.read);
        Collection<StorageItem> items = null;
        if (!this.isBrowseable()) {
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Repository %s is not browsable", this));
        }
        items = this.list(false, request);
        return items;
    }

    @Override
    public TargetSet getTargetsForRequest(ResourceStoreRequest request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getTargetsForRequest() :: " + this.getId() + ":" + request.getRequestPath());
        }
        return this.targetRegistry.getTargetsForRepositoryPath(this, request.getRequestPath());
    }

    @Override
    public boolean hasAnyTargetsForRequest(ResourceStoreRequest request) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("hasAnyTargetsForRequest() :: " + this.getId());
        }
        return this.targetRegistry.hasAnyApplicableTarget(this);
    }

    @Override
    public Action getResultingActionOnWrite(ResourceStoreRequest rsr) throws LocalStorageException {
        boolean isInLocalStorage = this.getLocalStorage().containsItem(this, rsr);
        if (isInLocalStorage) {
            return Action.update;
        }
        return Action.create;
    }

    @Override
    public StorageItem retrieveItem(boolean fromTask, ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ".retrieveItem() :: " + request.toString());
        }
        if (!this.getLocalStatus().shouldServiceRequest()) {
            throw new RepositoryNotAvailableException(this);
        }
        request.addProcessedRepository(this.getId());
        this.maintainNotFoundCache(request);
        RepositoryItemUid uid = this.createUid(request.getRequestPath());
        RepositoryItemUidLock uidLock = uid.getLock();
        uidLock.lock(Action.read);
        try {
            StorageItem item = this.doRetrieveItem(request);
            if (item instanceof StorageFileItem && ((StorageFileItem)item).isContentGenerated()) {
                StorageFileItem file = (StorageFileItem)item;
                String key = file.getContentGeneratorId();
                if (this.getContentGenerators().containsKey(key)) {
                    ContentGenerator generator = this.getContentGenerators().get(key);
                    try {
                        file.setContentLocator(generator.generateContent(this, uid.getPath(), file));
                    }
                    catch (Exception e) {
                        throw new LocalStorageException("Could not generate content:", e);
                    }
                } else {
                    this.log.info(String.format("The file in repository %s on path=\"%s\" should be generated by ContentGeneratorId=%s, but component does not exists!", RepositoryStringUtils.getHumanizedNameString(this), uid.getPath(), key));
                    throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "The generator for generated path %s with key %s not found in %s", request.getRequestPath(), key, this));
                }
            }
            this.eventBus().post((Object)new RepositoryItemEventRetrieve(this, item));
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getId() + " retrieveItem() :: FOUND " + uid.toString());
            }
            StorageItem storageItem = item;
            return storageItem;
        }
        catch (ItemNotFoundException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getId() + " retrieveItem() :: NOT FOUND " + uid.toString());
            }
            if (this.shouldAddToNotFoundCache(request)) {
                this.addToNotFoundCache(request);
            }
            throw ex;
        }
        finally {
            uidLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyItem(boolean fromTask, ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        block7: {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getId() + ".copyItem() :: " + from.toString() + " --> " + to.toString());
            }
            if (!this.getLocalStatus().shouldServiceRequest()) {
                throw new RepositoryNotAvailableException(this);
            }
            this.maintainNotFoundCache(from);
            RepositoryItemUid fromUid = this.createUid(from.getRequestPath());
            RepositoryItemUid toUid = this.createUid(to.getRequestPath());
            RepositoryItemUidLock fromUidLock = fromUid.getLock();
            RepositoryItemUidLock toUidLock = toUid.getLock();
            fromUidLock.lock(Action.read);
            toUidLock.lock(Action.create);
            try {
                StorageItem item = this.retrieveItem(fromTask, from);
                if (!StorageFileItem.class.isAssignableFrom(item.getClass())) break block7;
                try {
                    DefaultStorageFileItem target = new DefaultStorageFileItem(this, to, true, true, ((StorageFileItem)item).getContentLocator());
                    this.storeItem(fromTask, target);
                    this.removeFromNotFoundCache(to);
                }
                catch (IOException e) {
                    throw new LocalStorageException("Could not get the content of source file (is it file?)!", e);
                }
            }
            finally {
                toUidLock.unlock();
                fromUidLock.unlock();
            }
        }
    }

    @Override
    public void moveItem(boolean fromTask, ResourceStoreRequest from, ResourceStoreRequest to) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ".moveItem() :: " + from.toString() + " --> " + to.toString());
        }
        if (!this.getLocalStatus().shouldServiceRequest()) {
            throw new RepositoryNotAvailableException(this);
        }
        this.copyItem(fromTask, from, to);
        this.deleteItem(fromTask, from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(boolean fromTask, ResourceStoreRequest request) throws UnsupportedStorageOperationException, IllegalOperationException, ItemNotFoundException, StorageException {
        block12: {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getId() + ".deleteItem() :: " + request.toString());
            }
            if (!this.getLocalStatus().shouldServiceRequest()) {
                throw new RepositoryNotAvailableException(this);
            }
            this.maintainNotFoundCache(request);
            RepositoryItemUid uid = this.createUid(request.getRequestPath());
            RepositoryItemUidLock uidLock = uid.getLock();
            uidLock.lock(Action.delete);
            try {
                block13: {
                    AbstractStorageItem item = null;
                    try {
                        item = this.getLocalStorage().retrieveItem(this, request);
                    }
                    catch (ItemNotFoundException ex) {
                        if (this.shouldNeglectItemNotFoundExOnDelete(request, ex)) {
                            item = null;
                        }
                        throw ex;
                    }
                    if (item == null) break block12;
                    this.eventBus().post((Object)new RepositoryItemEventDeleteRoot(this, item));
                    if (item instanceof StorageCollectionItem) {
                        this.log.debug("deleting a collection '{}'", (Object)item.getPath());
                        if (this.isNotFoundCacheActive()) {
                            this.getNotFoundCache().removeWithChildren(request.getRequestPath());
                        }
                        DeletionNotifierWalker dnw = new DeletionNotifierWalker(this.eventBus(), request);
                        DefaultWalkerContext ctx = new DefaultWalkerContext(this, request);
                        ctx.getProcessors().add(dnw);
                        try {
                            this.getWalker().walk(ctx);
                        }
                        catch (WalkerException e) {
                            if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block13;
                            throw e;
                        }
                    }
                }
                this.doDeleteItem(request);
            }
            finally {
                uidLock.unlock();
            }
        }
    }

    protected boolean shouldNeglectItemNotFoundExOnDelete(ResourceStoreRequest request, ItemNotFoundException ex) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeItem(boolean fromTask, StorageItem item) throws UnsupportedStorageOperationException, IllegalOperationException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ".storeItem() :: " + item.getRepositoryItemUid().toString());
        }
        if (!this.getLocalStatus().shouldServiceRequest()) {
            throw new RepositoryNotAvailableException(this);
        }
        RepositoryItemUid uid = this.createUid(item.getPath());
        item.setRepositoryItemUid(uid);
        RepositoryItemUid uploaderUid = this.createUid(item.getPath() + ".storeItem()");
        RepositoryItemUidLock uidUploaderLock = uploaderUid.getLock();
        uidUploaderLock.lock(Action.create);
        Action action = this.getResultingActionOnWrite(item.getResourceStoreRequest());
        try {
            RepositoryItemUidLock uidLock = uid.getLock();
            uidLock.lock(Action.read);
            try {
                this.getLocalStorage().storeItem(this, item);
            }
            finally {
                uidLock.unlock();
            }
        }
        finally {
            uidUploaderLock.unlock();
        }
        this.removeFromNotFoundCache(item.getResourceStoreRequest());
        if (Action.create.equals((Object)action)) {
            this.eventBus().post((Object)new RepositoryItemEventStoreCreate(this, item));
        } else {
            this.eventBus().post((Object)new RepositoryItemEventStoreUpdate(this, item));
        }
    }

    @Override
    public Collection<StorageItem> list(boolean fromTask, ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ".list() :: " + request.toString());
        }
        if (!this.getLocalStatus().shouldServiceRequest()) {
            throw new RepositoryNotAvailableException(this);
        }
        request.addProcessedRepository(this.getId());
        StorageItem item = this.retrieveItem(fromTask, request);
        if (item instanceof StorageCollectionItem) {
            return this.list(fromTask, (StorageCollectionItem)item);
        }
        throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Path %s in repository %s is not a collection", request.getRequestPath(), this));
    }

    @Override
    public Collection<StorageItem> list(boolean fromTask, StorageCollectionItem coll) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ".list() :: " + coll.getRepositoryItemUid().toString());
        }
        if (!this.getLocalStatus().shouldServiceRequest()) {
            throw new RepositoryNotAvailableException(this);
        }
        this.maintainNotFoundCache(coll.getResourceStoreRequest());
        Collection<StorageItem> items = this.doListItems(new ResourceStoreRequest(coll));
        return items;
    }

    @Override
    public RepositoryItemUid createUid(String path) {
        return this.getRepositoryItemUidFactory().createUid(this, path);
    }

    @Override
    public RepositoryItemUidAttributeManager getRepositoryItemUidAttributeManager() {
        return this.repositoryItemUidAttributeManager;
    }

    @Override
    public void maintainNotFoundCache(ResourceStoreRequest request) throws ItemNotFoundException {
        if (this.isNotFoundCacheActive() && !request.isRequestAsExpired() && this.getNotFoundCache().contains(request.getRequestPath())) {
            if (this.getNotFoundCache().isExpired(request.getRequestPath())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("The path " + request.getRequestPath() + " is in NFC but expired.");
                }
                this.removeFromNotFoundCache(request);
            } else {
                StringBuilder sb = new StringBuilder("The path ").append(request.getRequestPath()).append(" is cached ");
                long expirationTime = this.getNotFoundCache().getExpirationTime(request.getRequestPath());
                if (expirationTime > 0L) {
                    sb.append("until ").append(new DateTime(expirationTime)).append(" ");
                }
                String message = sb.append("as not found in repository ").append(this).toString();
                this.log.debug(message);
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, message, new Object[0]));
            }
        }
    }

    @Override
    public void addToNotFoundCache(ResourceStoreRequest request) {
        if (this.isNotFoundCacheActive()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding path " + request.getRequestPath() + " to NFC.");
            }
            this.getNotFoundCache().put(request.getRequestPath(), Boolean.TRUE, this.getNotFoundCacheTimeToLive() * 60);
        }
    }

    @Override
    public void removeFromNotFoundCache(ResourceStoreRequest request) {
        if (this.isNotFoundCacheActive()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Removing path " + request.getRequestPath() + " from NFC.");
            }
            this.getNotFoundCache().removeWithParents(request.getRequestPath());
        }
    }

    protected void checkConditions(ResourceStoreRequest request, Action action) throws ItemNotFoundException, IllegalOperationException, AccessDeniedException {
        RepositoryItemUid uid;
        if (!this.getLocalStatus().shouldServiceRequest()) {
            throw new RepositoryNotAvailableException(this);
        }
        if (request.isExternal() && !(uid = this.createUid(request.getRequestPath())).getBooleanAttributeValue(IsRemotelyAccessibleAttribute.class)) {
            this.log.debug("Request for remotely non-accessible UID {} is forbidden", (Object)uid);
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "External access to UID %s not allowed!", uid));
        }
        if (RepositoryWritePolicy.READ_ONLY.equals((Object)this.getWritePolicy()) && !this.isActionAllowedReadOnly(action)) {
            throw new IllegalRequestException(request, "Repository with ID='" + this.getId() + "' is Read Only, but action was '" + action.toString() + "'!");
        }
        this.enforceWritePolicy(request, action);
        this.getAccessManager().decide(this, request, action);
        this.checkRequestStrategies(request, action);
    }

    protected void checkRequestStrategies(ResourceStoreRequest request, Action action) throws ItemNotFoundException, IllegalOperationException {
        Map<String, RequestStrategy> effectiveRequestStrategies = this.getRegisteredStrategies();
        for (RequestStrategy strategy : effectiveRequestStrategies.values()) {
            strategy.onHandle(this, request, action);
        }
    }

    protected void checkPostConditions(ResourceStoreRequest request, StorageItem item) throws IllegalOperationException, ItemNotFoundException {
        Map<String, RequestStrategy> effectiveRequestStrategies = this.getRegisteredStrategies();
        for (RequestStrategy strategy : effectiveRequestStrategies.values()) {
            strategy.onServing(this, request, item);
        }
    }

    protected void enforceWritePolicy(ResourceStoreRequest request, Action action) throws IllegalRequestException {
        if (Action.update.equals((Object)action) && !RepositoryWritePolicy.ALLOW_WRITE.equals((Object)this.getWritePolicy())) {
            throw new IllegalRequestException(request, "Repository with ID='" + this.getId() + "' does not allow updating artifacts.");
        }
    }

    @Override
    public boolean isCompatible(Repository repository) {
        return this.getRepositoryContentClass().isCompatible(repository.getRepositoryContentClass());
    }

    protected void doDeleteItem(ResourceStoreRequest request) throws UnsupportedStorageOperationException, ItemNotFoundException, StorageException {
        this.getLocalStorage().deleteItem(this, request);
    }

    protected Collection<StorageItem> doListItems(ResourceStoreRequest request) throws ItemNotFoundException, StorageException {
        return this.getLocalStorage().listItems(this, request);
    }

    protected StorageItem doRetrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        return this.doRetrieveLocalItem(request);
    }

    protected AbstractStorageItem doRetrieveLocalItem(ResourceStoreRequest request) throws ItemNotFoundException, LocalStorageException {
        AbstractStorageItem localItem = null;
        try {
            StorageFileItem file;
            localItem = this.getLocalStorage().retrieveItem(this, request);
            if (localItem instanceof StorageFileItem && !((file = (StorageFileItem)((Object)localItem)).getContentLocator() instanceof ReadLockingContentLocator)) {
                RepositoryItemUid uid = this.createUid(request.getRequestPath());
                file.setContentLocator(new ReadLockingContentLocator(uid, file.getContentLocator()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Item " + request.toString() + " found in local storage.");
            }
        }
        catch (ItemNotFoundException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Item " + request.toString() + " not found in local storage.");
            }
            throw ex;
        }
        return localItem;
    }

    protected boolean isActionAllowedReadOnly(Action action) {
        return action.isReadAction();
    }

    protected boolean shouldAddToNotFoundCache(ResourceStoreRequest request) {
        return !request.isRequestLocalOnly() && !request.isRequestRemoteOnly();
    }
}

