/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.application.AuthenticationInfoConverter;
import org.sonatype.nexus.configuration.application.GlobalRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.validator.ApplicationValidationResponse;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.repository.AbstractRepositoryConfigurator;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.remote.RemoteProviderHintFactory;
import org.sonatype.nexus.proxy.storage.remote.RemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;

public abstract class AbstractProxyRepositoryConfigurator
extends AbstractRepositoryConfigurator {
    private AuthenticationInfoConverter authenticationInfoConverter;
    private GlobalRemoteConnectionSettings globalRemoteConnectionSettings;
    private RemoteProviderHintFactory remoteProviderHintFactory;
    private Map<String, RemoteRepositoryStorage> remoteRepositoryStorages;

    @Inject
    public void populateAbstractProxyRepositoryConfigurator(AuthenticationInfoConverter authenticationInfoConverter, GlobalRemoteConnectionSettings globalRemoteConnectionSettings, RemoteProviderHintFactory remoteProviderHintFactory, Map<String, RemoteRepositoryStorage> remoteRepositoryStorages) {
        this.authenticationInfoConverter = (AuthenticationInfoConverter)Preconditions.checkNotNull((Object)authenticationInfoConverter);
        this.globalRemoteConnectionSettings = (GlobalRemoteConnectionSettings)Preconditions.checkNotNull((Object)globalRemoteConnectionSettings);
        this.remoteProviderHintFactory = (RemoteProviderHintFactory)Preconditions.checkNotNull((Object)remoteProviderHintFactory);
        this.remoteRepositoryStorages = (Map)Preconditions.checkNotNull(remoteRepositoryStorages);
    }

    @Override
    public void doApplyConfiguration(Repository repository, ApplicationConfiguration configuration, CRepositoryCoreConfiguration coreConfig) throws ConfigurationException {
        super.doApplyConfiguration(repository, configuration, coreConfig);
        CRepository repo = (CRepository)coreConfig.getConfiguration(true);
        if (repo.getRemoteStorage() != null) {
            ProxyRepository prepository = (ProxyRepository)repository;
            try {
                if (repo.getRemoteStorage() != null) {
                    RemoteRepositoryStorage oldRemoteStorage = prepository.getRemoteStorage();
                    RemoteRepositoryStorage configRemoteStorage = this.getRemoteRepositoryStorage(repo.getId(), repo.getRemoteStorage().getUrl(), repo.getRemoteStorage().getProvider());
                    if (oldRemoteStorage == null || oldRemoteStorage != configRemoteStorage) {
                        configRemoteStorage.validateStorageUrl(repo.getRemoteStorage().getUrl());
                        prepository.setRemoteStorage(configRemoteStorage);
                        RemoteStorageContext ctx = prepository.getRemoteStorageContext();
                        if (ctx != null) {
                            ctx.incrementGeneration();
                        }
                    } else {
                        oldRemoteStorage.validateStorageUrl(repo.getRemoteStorage().getUrl());
                    }
                    if (repo.getRemoteStorage().getAuthentication() != null) {
                        prepository.setRemoteAuthenticationSettings(this.authenticationInfoConverter.convertAndValidateFromModel(repo.getRemoteStorage().getAuthentication()));
                    }
                    if (repo.getRemoteStorage().getConnectionSettings() != null) {
                        prepository.setRemoteConnectionSettings(this.globalRemoteConnectionSettings.convertAndValidateFromModel(repo.getRemoteStorage().getConnectionSettings()));
                    }
                } else {
                    prepository.setRemoteStorage(null);
                }
            }
            catch (RemoteStorageException e) {
                ApplicationValidationResponse response = new ApplicationValidationResponse();
                ValidationMessage error = new ValidationMessage("remoteStorageUrl", e.getMessage(), e.getMessage());
                response.addValidationError(error);
                throw new InvalidConfigurationException((ValidationResponse)response);
            }
        }
    }

    @Override
    protected void doPrepareForSave(Repository repository, ApplicationConfiguration configuration, CRepositoryCoreConfiguration coreConfiguration) {
        super.doPrepareForSave(repository, configuration, coreConfiguration);
        if (repository instanceof ProxyRepository) {
            ProxyRepository prepository = (ProxyRepository)repository;
            CRepository repoConfig = (CRepository)coreConfiguration.getConfiguration(true);
            if (repoConfig.getRemoteStorage() != null) {
                RemoteStorageContext rsc = prepository.getRemoteStorageContext();
                if (this.remoteProviderHintFactory.getDefaultHttpRoleHint().equals(prepository.getRemoteStorage().getProviderId())) {
                    repoConfig.getRemoteStorage().setProvider(null);
                }
                if (rsc.hasRemoteAuthenticationSettings()) {
                    repoConfig.getRemoteStorage().setAuthentication(this.authenticationInfoConverter.convertToModel(rsc.getRemoteAuthenticationSettings()));
                } else {
                    repoConfig.getRemoteStorage().setAuthentication(null);
                }
                if (rsc.hasRemoteConnectionSettings()) {
                    repoConfig.getRemoteStorage().setConnectionSettings(this.globalRemoteConnectionSettings.convertToModel(rsc.getRemoteConnectionSettings()));
                } else {
                    repoConfig.getRemoteStorage().setConnectionSettings(null);
                }
            }
        }
    }

    protected RemoteRepositoryStorage getRemoteRepositoryStorage(String repoId, String remoteUrl, String provider) throws InvalidConfigurationException {
        try {
            String mungledHint = this.remoteProviderHintFactory.getRoleHint(remoteUrl, provider);
            RemoteRepositoryStorage result = this.remoteRepositoryStorages.get(mungledHint);
            if (result != null) {
                return result;
            }
            throw new InvalidConfigurationException("Repository " + repoId + " have remote storage with unsupported provider: " + provider);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("Repository " + repoId + " have remote storage with unsupported provider: " + provider, (Throwable)e);
        }
    }
}

