/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.nexus.proxy.repository.AbstractRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.ProxyMode;
import org.sonatype.nexus.proxy.repository.RepositoryStatusCheckMode;

public abstract class AbstractProxyRepositoryConfiguration
extends AbstractRepositoryConfiguration {
    private static final String PROXY_MODE = "proxyMode";
    private static final String REMOTE_STATUS_CHECK_MODE = "remoteStatusCheckMode";
    private static final String ITEM_MAX_AGE = "itemMaxAge";
    private static final String ITEM_AGING_ACTIVE = "itemAgingActive";
    private static final String AUTO_BLOCK_ACTIVE = "autoBlockActive";
    public static final String FILE_TYPE_VALIDATION = "fileTypeValidation";

    public AbstractProxyRepositoryConfiguration(Xpp3Dom configuration) {
        super(configuration);
    }

    public ProxyMode getProxyMode() {
        return ProxyMode.valueOf(this.getNodeValue(this.getRootNode(), PROXY_MODE, ProxyMode.ALLOW.toString()));
    }

    public void setProxyMode(ProxyMode mode) {
        this.setNodeValue(this.getRootNode(), PROXY_MODE, mode.toString());
    }

    public boolean isFileTypeValidation() {
        return Boolean.valueOf(this.getNodeValue(this.getRootNode(), FILE_TYPE_VALIDATION, "true"));
    }

    public void setFileTypeValidation(boolean doValidate) {
        this.setNodeValue(this.getRootNode(), FILE_TYPE_VALIDATION, Boolean.toString(doValidate));
    }

    public RepositoryStatusCheckMode getRepositoryStatusCheckMode() {
        return RepositoryStatusCheckMode.valueOf(this.getNodeValue(this.getRootNode(), REMOTE_STATUS_CHECK_MODE, RepositoryStatusCheckMode.AUTO_BLOCKED_ONLY.toString()));
    }

    public void setRepositoryStatusCheckMode(RepositoryStatusCheckMode mode) {
        this.setNodeValue(this.getRootNode(), REMOTE_STATUS_CHECK_MODE, mode.toString());
    }

    public int getItemMaxAge() {
        return Integer.parseInt(this.getNodeValue(this.getRootNode(), ITEM_MAX_AGE, "1440"));
    }

    public void setItemMaxAge(int age) {
        this.setNodeValue(this.getRootNode(), ITEM_MAX_AGE, String.valueOf(age));
    }

    public boolean isItemAgingActive() {
        return Boolean.parseBoolean(this.getNodeValue(this.getRootNode(), ITEM_AGING_ACTIVE, Boolean.TRUE.toString()));
    }

    public void setItemAgingActive(boolean value) {
        this.setNodeValue(this.getRootNode(), ITEM_AGING_ACTIVE, Boolean.toString(value));
    }

    public boolean isAutoBlockActive() {
        return Boolean.parseBoolean(this.getNodeValue(this.getRootNode(), AUTO_BLOCK_ACTIVE, Boolean.TRUE.toString()));
    }

    public void setAutoBlockActive(boolean value) {
        this.setNodeValue(this.getRootNode(), AUTO_BLOCK_ACTIVE, Boolean.toString(value));
    }
}

