/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.codehaus.plexus.util.ExceptionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.configuration.model.CRemoteStorage;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageEOFException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.RemoteAccessDeniedException;
import org.sonatype.nexus.proxy.RemoteAccessException;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.RemoteStorageTransportException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryEventEvictUnusedItems;
import org.sonatype.nexus.proxy.events.RepositoryEventExpireProxyCaches;
import org.sonatype.nexus.proxy.events.RepositoryEventProxyModeChanged;
import org.sonatype.nexus.proxy.events.RepositoryEventProxyModeSet;
import org.sonatype.nexus.proxy.events.RepositoryItemEventCacheCreate;
import org.sonatype.nexus.proxy.events.RepositoryItemEventCacheUpdate;
import org.sonatype.nexus.proxy.events.RepositoryItemValidationEvent;
import org.sonatype.nexus.proxy.item.AbstractStorageItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.repository.AbstractProxyRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.AbstractRepository;
import org.sonatype.nexus.proxy.repository.EvictUnusedItemsWalkerProcessor;
import org.sonatype.nexus.proxy.repository.ExpireCacheWalker;
import org.sonatype.nexus.proxy.repository.ItemContentValidator;
import org.sonatype.nexus.proxy.repository.ProxyMode;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.RemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.repository.RemoteConnectionSettings;
import org.sonatype.nexus.proxy.repository.RemoteStatus;
import org.sonatype.nexus.proxy.repository.RepositoryStatusCheckMode;
import org.sonatype.nexus.proxy.repository.RepositoryStatusCheckerThread;
import org.sonatype.nexus.proxy.repository.RepositoryWritePolicy;
import org.sonatype.nexus.proxy.repository.RequestStrategy;
import org.sonatype.nexus.proxy.repository.threads.ThreadPoolManager;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.proxy.storage.remote.AbstractHTTPRemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.DefaultRemoteStorageContext;
import org.sonatype.nexus.proxy.storage.remote.RemoteRepositoryStorage;
import org.sonatype.nexus.proxy.storage.remote.RemoteStorageContext;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.nexus.proxy.walker.WalkerFilter;
import org.sonatype.nexus.util.ConstantNumberSequence;
import org.sonatype.nexus.util.FibonacciNumberSequence;
import org.sonatype.nexus.util.NumberSequence;
import org.sonatype.nexus.util.SystemPropertiesHelper;

public abstract class AbstractProxyRepository
extends AbstractRepository
implements ProxyRepository {
    private static final long DEFAULT_REMOTE_STATUS_RETAIN_TIME = 300000L;
    private static final long REMOTE_STATUS_RETAIN_TIME = SystemPropertiesHelper.getLong("plexus.autoblock.remote.status.retain.time", 300000L);
    private static final long AUTO_BLOCK_STATUS_MAX_RETAIN_TIME = 3600000L;
    private SystemStatus systemStatus;
    private ThreadPoolManager poolManager;
    private RepositoryStatusCheckerThread repositoryStatusCheckerThread;
    private RemoteStorageContext remoteStorageContext;
    private RemoteRepositoryStorage remoteStorage;
    private final Map<String, ItemContentValidator> itemContentValidators = Maps.newHashMap();
    private volatile RemoteStatus remoteStatus = RemoteStatus.UNKNOWN;
    private volatile long remoteStatusUpdated = 0L;
    private volatile boolean remoteUrlChanged = false;
    private volatile NumberSequence remoteStatusRetainTimeSequence = new ConstantNumberSequence(REMOTE_STATUS_RETAIN_TIME);
    private static final boolean PROXY_CACHE_INVALIDATION_TOKEN_DISABLED = SystemPropertiesHelper.getBoolean(AbstractProxyRepository.class.getName() + ".proxyCacheInvalidationToken.disabled", false);
    protected volatile String proxyCacheInvalidationToken;
    public static final String PROXY_CACHE_INVALIDATION_TOKEN_KEY = "proxyRepository-invalidationToken";
    private volatile boolean _remoteStatusChecking = false;

    @Inject
    public void populateAbstractProxyRepository(SystemStatus systemStatus, ThreadPoolManager poolManager) {
        this.systemStatus = (SystemStatus)Preconditions.checkNotNull((Object)systemStatus);
        this.poolManager = (ThreadPoolManager)Preconditions.checkNotNull((Object)poolManager);
        this.remoteStorageContext = new DefaultRemoteStorageContext(this.getApplicationConfiguration().getGlobalRemoteStorageContext());
    }

    @Override
    protected AbstractProxyRepositoryConfiguration getExternalConfiguration(boolean forModification) {
        return (AbstractProxyRepositoryConfiguration)this.getCurrentCoreConfiguration().getExternalConfiguration().getConfiguration(forModification);
    }

    @Subscribe
    public void on(NexusStoppedEvent e) {
        this.disposeRepositoryStatusCheckerThread();
    }

    private void createRepositoryStatusCheckerThread() {
        if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class) && this.repositoryStatusCheckerThread == null) {
            this.repositoryStatusCheckerThread = new RepositoryStatusCheckerThread(LoggerFactory.getLogger((String)(this.getClass().getName() + "-" + this.getId())), this.systemStatus, this);
            this.repositoryStatusCheckerThread.setRunning(true);
            this.repositoryStatusCheckerThread.setDaemon(true);
            this.repositoryStatusCheckerThread.start();
        }
    }

    private void disposeRepositoryStatusCheckerThread() {
        if (this.repositoryStatusCheckerThread != null) {
            this.repositoryStatusCheckerThread.setRunning(false);
            this.repositoryStatusCheckerThread.interrupt();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeRepositoryStatusCheckerThread();
    }

    @Override
    protected void doConfigure() throws ConfigurationException {
        super.doConfigure();
        this.createRepositoryStatusCheckerThread();
    }

    @Override
    public boolean commitChanges() throws ConfigurationException {
        boolean result = super.commitChanges();
        if (result) {
            this.remoteUrlChanged = false;
        }
        return result;
    }

    @Override
    public boolean rollbackChanges() {
        this.remoteUrlChanged = false;
        return super.rollbackChanges();
    }

    @Override
    protected RepositoryConfigurationUpdatedEvent getRepositoryConfigurationUpdatedEvent() {
        RepositoryConfigurationUpdatedEvent event = super.getRepositoryConfigurationUpdatedEvent();
        event.setRemoteUrlChanged(this.remoteUrlChanged);
        return event;
    }

    @Override
    public final void expireProxyCaches(ResourceStoreRequest request) {
        this.expireProxyCaches(request, null);
    }

    @Override
    public final boolean expireProxyCaches(ResourceStoreRequest request, WalkerFilter filter) {
        if (!this.shouldServiceOperation(request, "expireProxyCaches")) {
            return false;
        }
        this.log.debug("Expiring proxy caches in repository {} from path='{}'", (Object)this, (Object)request.getRequestPath());
        return this.doExpireProxyCaches(request, filter);
    }

    protected boolean doExpireProxyCaches(ResourceStoreRequest request, WalkerFilter filter) {
        boolean cacheAltered;
        if (!this.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            return false;
        }
        if (StringUtils.isEmpty((String)request.getRequestPath())) {
            request.setRequestPath("/");
        }
        if (!PROXY_CACHE_INVALIDATION_TOKEN_DISABLED && "/".equals(request.getRequestPath())) {
            this.proxyCacheInvalidationToken = String.valueOf(System.nanoTime());
            this.log.debug("Proxy cache marked as invalid for repository {}, token: {}", (Object)this, (Object)this.proxyCacheInvalidationToken);
            cacheAltered = true;
        } else {
            ExpireCacheWalker expireCacheWalkerProcessor;
            block9: {
                request.setRequestLocalOnly(true);
                DefaultWalkerContext ctx = new DefaultWalkerContext(this, request, filter);
                expireCacheWalkerProcessor = new ExpireCacheWalker(this);
                ctx.getProcessors().add(expireCacheWalkerProcessor);
                try {
                    this.getWalker().walk(ctx);
                }
                catch (WalkerException e) {
                    if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block9;
                    throw e;
                }
            }
            cacheAltered = expireCacheWalkerProcessor.isCacheAltered();
        }
        if (this.log.isDebugEnabled()) {
            if (cacheAltered) {
                this.log.info("Proxy cache was expired for repository {} from path='{}'", (Object)this, (Object)request.getRequestPath());
            } else {
                this.log.debug("Proxy cache not altered for repository {} from path='{}'", (Object)this, (Object)request.getRequestPath());
            }
        }
        this.eventBus().post((Object)new RepositoryEventExpireProxyCaches(this, request.getRequestPath(), request.getRequestContext().flatten(), cacheAltered));
        return cacheAltered;
    }

    @Override
    protected boolean doExpireCaches(ResourceStoreRequest request, WalkerFilter filter) {
        boolean v1 = this.doExpireProxyCaches(request, filter);
        boolean v2 = super.doExpireCaches(request, filter);
        return v1 || v2;
    }

    @Override
    protected Collection<String> doEvictUnusedItems(ResourceStoreRequest request, long timestamp) {
        if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            Collection<String> result = this.doEvictUnusedItems(request, timestamp, new EvictUnusedItemsWalkerProcessor(timestamp), new EvictUnusedItemsWalkerProcessor.EvictUnusedItemsWalkerFilter());
            this.eventBus().post((Object)new RepositoryEventEvictUnusedItems(this));
            return result;
        }
        return super.doEvictUnusedItems(request, timestamp);
    }

    protected Collection<String> doEvictUnusedItems(ResourceStoreRequest request, long timestamp, EvictUnusedItemsWalkerProcessor processor, WalkerFilter filter) {
        block2: {
            request.setRequestLocalOnly(true);
            DefaultWalkerContext ctx = new DefaultWalkerContext(this, request, filter);
            ctx.getProcessors().add(processor);
            try {
                this.getWalker().walk(ctx);
            }
            catch (WalkerException e) {
                if (e.getWalkerContext().getStopCause() instanceof ItemNotFoundException) break block2;
                throw e;
            }
        }
        return processor.getFiles();
    }

    @Override
    public Map<String, ItemContentValidator> getItemContentValidators() {
        return this.itemContentValidators;
    }

    @Override
    public boolean isFileTypeValidation() {
        return this.getExternalConfiguration(false).isFileTypeValidation();
    }

    @Override
    public void setFileTypeValidation(boolean doValidate) {
        this.getExternalConfiguration(true).setFileTypeValidation(doValidate);
    }

    @Override
    public boolean isItemAgingActive() {
        return this.getExternalConfiguration(false).isItemAgingActive();
    }

    @Override
    public void setItemAgingActive(boolean value) {
        this.getExternalConfiguration(true).setItemAgingActive(value);
    }

    @Override
    public boolean isAutoBlockActive() {
        return this.getExternalConfiguration(false).isAutoBlockActive();
    }

    @Override
    public void setAutoBlockActive(boolean val) {
        if (!val && ProxyMode.BLOCKED_AUTO.equals((Object)this.getProxyMode())) {
            this.log.warn(String.format("Proxy Repository %s was auto-blocked, but user disabled this feature. Unblocking repository, but this MAY cause Nexus to leak connections (if remote repository is still down)!", RepositoryStringUtils.getHumanizedNameString(this)));
            this.setProxyMode(ProxyMode.ALLOW);
        }
        this.getExternalConfiguration(true).setAutoBlockActive(val);
    }

    @Override
    public long getCurrentRemoteStatusRetainTime() {
        return this.remoteStatusRetainTimeSequence.peek();
    }

    @Override
    public long getNextRemoteStatusRetainTime() {
        if (this.remoteStatusRetainTimeSequence.peek() <= 3600000L) {
            return this.remoteStatusRetainTimeSequence.next();
        }
        return this.getCurrentRemoteStatusRetainTime();
    }

    @Override
    public ProxyMode getProxyMode() {
        if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            return this.getExternalConfiguration(false).getProxyMode();
        }
        return null;
    }

    protected void setProxyMode(ProxyMode proxyMode, boolean sendNotification, Throwable cause) {
        if (this.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            ProxyMode oldProxyMode = this.getProxyMode();
            if (!ProxyMode.BLOCKED_AUTO.equals((Object)proxyMode) || !ProxyMode.BLOCKED_MANUAL.equals((Object)oldProxyMode)) {
                if (!oldProxyMode.equals((Object)proxyMode)) {
                    if (ProxyMode.BLOCKED_AUTO.equals((Object)proxyMode) || ProxyMode.BLOCKED_AUTO.equals((Object)oldProxyMode)) {
                        this.getExternalConfiguration(false).setProxyMode(proxyMode);
                        if (this.isDirty()) {
                            this.getExternalConfiguration(true).setProxyMode(proxyMode);
                        }
                    } else {
                        this.getExternalConfiguration(true).setProxyMode(proxyMode);
                    }
                }
                if (ProxyMode.BLOCKED_AUTO.equals((Object)proxyMode)) {
                    if (!(this.remoteStatusRetainTimeSequence instanceof FibonacciNumberSequence)) {
                        long initialStep = (long)this.getRemoteConnectionSettings().getConnectionTimeout() * 2L;
                        this.remoteStatusRetainTimeSequence = new FibonacciNumberSequence(initialStep);
                        this.remoteStatusRetainTimeSequence.next();
                        if (this.repositoryStatusCheckerThread != null) {
                            this.repositoryStatusCheckerThread.interrupt();
                        }
                    }
                } else {
                    this.remoteStatusRetainTimeSequence = new ConstantNumberSequence(REMOTE_STATUS_RETAIN_TIME);
                }
                if (proxyMode != null && proxyMode.shouldProxy() && !oldProxyMode.shouldProxy()) {
                    if (!oldProxyMode.shouldAutoUnblock()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("We have a BLOCKED_MANUAL -> ALLOW transition, purging NFC");
                        }
                        this.getNotFoundCache().purge();
                    }
                    this.resetRemoteStatus();
                }
                if (sendNotification) {
                    this.eventBus().post((Object)new RepositoryEventProxyModeSet(this, oldProxyMode, proxyMode, cause));
                    if (proxyMode != null && !proxyMode.equals((Object)oldProxyMode)) {
                        this.eventBus().post((Object)new RepositoryEventProxyModeChanged(this, oldProxyMode, proxyMode, cause));
                    }
                }
            }
        }
    }

    @Override
    public void setProxyMode(ProxyMode proxyMode) {
        this.setProxyMode(proxyMode, true, null);
    }

    protected void autoBlockProxying(Throwable cause) {
        ProxyMode oldProxyMode = this.getProxyMode();
        RemoteRepositoryStorage remoteStorage = this.getRemoteStorage();
        try {
            if (remoteStorage instanceof AbstractHTTPRemoteRepositoryStorage && ((AbstractHTTPRemoteRepositoryStorage)remoteStorage).isRemotePeerAmazonS3Storage(this) && cause instanceof RemoteAccessDeniedException) {
                this.log.debug("Not autoblocking repository id " + this.getId() + "since this is Amazon S3 proxy repo");
                return;
            }
        }
        catch (StorageException e) {
            this.log.debug("Unable to validate if proxy repository id " + this.getId() + "is Amazon S3", (Throwable)e);
        }
        String unavailableReason = this.parseRemoteUnavailableReason(cause);
        if (unavailableReason == null) {
            this.setRemoteStatus(RemoteStatus.UNAVAILABLE, cause);
        } else {
            this.setRemoteStatus(new RemoteStatus(RemoteStatus.Type.UNAVAILABLE, unavailableReason), cause);
        }
        boolean autoBlockActive = this.isAutoBlockActive();
        if (!ProxyMode.BLOCKED_AUTO.equals((Object)oldProxyMode)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Remote peer of proxy repository " + RepositoryStringUtils.getHumanizedNameString(this) + " threw a " + cause.getClass().getName() + " exception.");
            if (cause instanceof RemoteAccessException) {
                sb.append(" Please set up authorization information for this repository.");
            } else if (cause instanceof StorageException) {
                sb.append(" Connection/transport problems occured while connecting to remote peer of the repository.");
            }
            if (autoBlockActive) {
                sb.append(" Auto-blocking this repository to prevent further connection-leaks and known-to-fail outbound connections until administrator fixes the problems, or Nexus detects remote repository as healthy.");
            }
            if (this.log.isDebugEnabled()) {
                this.log.warn(sb.toString(), cause);
            } else {
                sb.append(" - Cause(s): ").append(cause.getMessage());
                for (Throwable c = cause.getCause(); c != null; c = c.getCause()) {
                    sb.append(" > ").append(c.getMessage());
                }
                this.log.warn(sb.toString());
            }
        }
        if (autoBlockActive && oldProxyMode != null) {
            this.setProxyMode(ProxyMode.BLOCKED_AUTO, true, cause);
        }
    }

    protected void autoUnBlockProxying() {
        this.setRemoteStatus(RemoteStatus.AVAILABLE, null);
        ProxyMode oldProxyMode = this.getProxyMode();
        if (oldProxyMode.shouldAutoUnblock()) {
            this.log.warn(String.format("Remote peer of proxy repository %s detected as healthy, un-blocking the proxy repository (it was AutoBlocked by Nexus).", RepositoryStringUtils.getHumanizedNameString(this)));
            this.setProxyMode(ProxyMode.ALLOW, true, null);
        }
    }

    protected String parseRemoteUnavailableReason(Throwable cause) {
        if (cause == null) {
            return null;
        }
        if (cause.getCause() != null) {
            if (cause.getCause() instanceof SSLPeerUnverifiedException) {
                return "Untrusted Remote";
            }
            if (cause.getCause() instanceof SSLException) {
                return cause.getCause().getMessage();
            }
        }
        return null;
    }

    @Override
    public RepositoryStatusCheckMode getRepositoryStatusCheckMode() {
        return this.getExternalConfiguration(false).getRepositoryStatusCheckMode();
    }

    @Override
    public void setRepositoryStatusCheckMode(RepositoryStatusCheckMode mode) {
        this.getExternalConfiguration(true).setRepositoryStatusCheckMode(mode);
    }

    @Override
    public String getRemoteUrl() {
        if (((CRepository)this.getCurrentConfiguration(false)).getRemoteStorage() != null) {
            return ((CRepository)this.getCurrentConfiguration(false)).getRemoteStorage().getUrl();
        }
        return null;
    }

    @Override
    public void setRemoteUrl(String remoteUrl) throws RemoteStorageException {
        if (this.getRemoteStorage() != null) {
            String newRemoteUrl = remoteUrl.trim();
            String oldRemoteUrl = this.getRemoteUrl();
            if (!newRemoteUrl.endsWith("/")) {
                newRemoteUrl = newRemoteUrl + "/";
            }
            this.getRemoteStorage().validateStorageUrl(newRemoteUrl);
            ((CRepository)this.getCurrentConfiguration(true)).getRemoteStorage().setUrl(newRemoteUrl);
            if (StringUtils.isEmpty((String)oldRemoteUrl) && StringUtils.isNotEmpty((String)newRemoteUrl) || StringUtils.isNotEmpty((String)oldRemoteUrl) && !oldRemoteUrl.equals(newRemoteUrl)) {
                this.remoteUrlChanged = true;
            }
        } else {
            throw new RemoteStorageException("No remote storage set on repository \"" + this.getName() + "\" (ID=\"" + this.getId() + "\"), cannot set remoteUrl!");
        }
    }

    @Override
    public int getItemMaxAge() {
        return this.getExternalConfiguration(false).getItemMaxAge();
    }

    @Override
    public void setItemMaxAge(int itemMaxAge) {
        this.getExternalConfiguration(true).setItemMaxAge(itemMaxAge);
    }

    protected void resetRemoteStatus() {
        this.remoteStatusUpdated = 0L;
    }

    @Override
    public RemoteStatus getRemoteStatus(ResourceStoreRequest request, boolean forceCheck) {
        if (forceCheck || System.currentTimeMillis() - this.remoteStatusUpdated > REMOTE_STATUS_RETAIN_TIME) {
            this.remoteStatus = RemoteStatus.UNKNOWN;
        }
        if (this.getProxyMode() != null && RemoteStatus.UNKNOWN.equals(this.remoteStatus) && !this._remoteStatusChecking) {
            this._remoteStatusChecking = true;
            this.poolManager.getRepositoryThreadPool(this).submit(new RemoteStatusUpdateCallable(request));
        }
        return this.remoteStatus;
    }

    private void setRemoteStatus(RemoteStatus remoteStatus, Throwable cause) {
        this.remoteStatus = remoteStatus;
        if (RemoteStatus.AVAILABLE.equals(remoteStatus) || RemoteStatus.UNAVAILABLE.equals(remoteStatus)) {
            this.remoteStatusUpdated = System.currentTimeMillis();
        }
    }

    @Override
    public RemoteStorageContext getRemoteStorageContext() {
        return this.remoteStorageContext;
    }

    @Override
    public RemoteConnectionSettings getRemoteConnectionSettings() {
        return this.getRemoteStorageContext().getRemoteConnectionSettings();
    }

    @Override
    public void setRemoteConnectionSettings(RemoteConnectionSettings settings) {
        this.getRemoteStorageContext().setRemoteConnectionSettings(settings);
    }

    @Override
    public RemoteAuthenticationSettings getRemoteAuthenticationSettings() {
        return this.getRemoteStorageContext().getRemoteAuthenticationSettings();
    }

    @Override
    public void setRemoteAuthenticationSettings(RemoteAuthenticationSettings settings) {
        this.getRemoteStorageContext().setRemoteAuthenticationSettings(settings);
        if (this.getProxyMode() != null && this.getProxyMode().shouldAutoUnblock()) {
            this.setProxyMode(ProxyMode.ALLOW);
        }
    }

    @Override
    public RemoteRepositoryStorage getRemoteStorage() {
        return this.remoteStorage;
    }

    @Override
    public void setRemoteStorage(RemoteRepositoryStorage remoteStorage) {
        this.remoteStorage = remoteStorage;
        if (remoteStorage == null) {
            ((CRepository)this.getCurrentConfiguration(true)).setRemoteStorage(null);
        } else {
            if (((CRepository)this.getCurrentConfiguration(true)).getRemoteStorage() == null) {
                ((CRepository)this.getCurrentConfiguration(true)).setRemoteStorage(new CRemoteStorage());
            }
            ((CRepository)this.getCurrentConfiguration(true)).getRemoteStorage().setProvider(remoteStorage.getProviderId());
            this.setWritePolicy(RepositoryWritePolicy.READ_ONLY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractStorageItem doCacheItem(AbstractStorageItem item) throws LocalStorageException {
        AbstractStorageItem result = null;
        try {
            Action action;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caching item " + item.getRepositoryItemUid().toString() + " in local storage of repository.");
            }
            RepositoryItemUidLock itemLock = item.getRepositoryItemUid().getLock();
            itemLock.lock(Action.create);
            try {
                action = this.getResultingActionOnWrite(item.getResourceStoreRequest());
                this.getLocalStorage().storeItem(this, item);
                this.removeFromNotFoundCache(item.getResourceStoreRequest());
                result = this.doRetrieveLocalItem(item.getResourceStoreRequest());
            }
            finally {
                itemLock.unlock();
            }
            result.getItemContext().setParentContext(item.getItemContext());
            if (Action.create.equals((Object)action)) {
                this.eventBus().post((Object)new RepositoryItemEventCacheCreate(this, result));
            } else {
                this.eventBus().post((Object)new RepositoryItemEventCacheUpdate(this, result));
            }
        }
        catch (ItemNotFoundException ex) {
            this.log.warn("Nexus BUG in " + RepositoryStringUtils.getHumanizedNameString(this) + ", ItemNotFoundException during cache! Please report this issue along with the stack trace below!", (Throwable)ex);
            result = item;
        }
        catch (UnsupportedStorageOperationException ex) {
            this.log.warn("LocalStorage or repository " + RepositoryStringUtils.getHumanizedNameString(this) + " does not handle STORE operation, not caching remote fetched item.", (Throwable)ex);
            result = item;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected StorageItem doRetrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        if (this.log.isDebugEnabled()) {
            db = new StringBuilder(request.toString());
            db.append(" :: localOnly=").append(request.isRequestLocalOnly());
            db.append(", remoteOnly=").append(request.isRequestRemoteOnly());
            db.append(", asExpired=").append(request.isRequestAsExpired());
            if (this.getProxyMode() != null) {
                db.append(", ProxyMode=" + this.getProxyMode().toString());
            }
            this.log.debug(db.toString());
        }
        itemUid = this.createUid(request.getRequestPath());
        itemUidLock = itemUid.getLock();
        itemUidLock.lock(Action.read);
        try {
            block19: {
                if (!this.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
                    var4_4 = super.doRetrieveItem(request);
                    return var4_4;
                }
                localItem = null;
                if (!request.isRequestRemoteOnly()) {
                    try {
                        localItem = (AbstractStorageItem)super.doRetrieveItem(request);
                        if (localItem != null && !request.isRequestAsExpired() && !this.isOld(localItem)) {
                            var5_6 = localItem;
                            return var5_6;
                        }
                    }
                    catch (ItemNotFoundException e) {
                        localItem = null;
                    }
                }
                itemUidLock.lock(Action.create);
                if (request.isRequestRemoteOnly()) ** GOTO lbl44
                localItem = (AbstractStorageItem)super.doRetrieveItem(request);
                if (localItem == null || request.isRequestAsExpired() || this.isOld(localItem)) break block19;
                e = localItem;
                itemUidLock.unlock();
                return e;
            }
            try {
                block20: {
                    break block20;
                    {
                        catch (ItemNotFoundException e) {
                            localItem = null;
                        }
                    }
                }
                var5_10 = this.doRetrieveItem0(request, localItem);
                itemUidLock.unlock();
                return var5_10;
            }
            catch (Throwable var6_11) {
                itemUidLock.unlock();
                throw var6_11;
            }
        }
        finally {
            itemUidLock.unlock();
        }
    }

    protected void shouldTryRemote(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException {
        if (request.isRequestLocalOnly()) {
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Request is marked as local-only, remote access not allowed from %s", this));
        }
        if (this.getProxyMode() != null && !this.getProxyMode().shouldProxy()) {
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Repository proxy-mode is %s, remote access not allowed from %s", new Object[]{this.getProxyMode(), this}));
        }
    }

    protected StorageItem doRetrieveItem0(ResourceStoreRequest request, AbstractStorageItem localItem) throws IllegalOperationException, ItemNotFoundException, StorageException {
        AbstractStorageItem item = null;
        AbstractStorageItem remoteItem = null;
        ItemNotFoundException noRemoteAccessReason = null;
        try {
            this.shouldTryRemote(request);
        }
        catch (ItemNotFoundException e) {
            noRemoteAccessReason = e;
        }
        if (noRemoteAccessReason == null) {
            for (RequestStrategy strategy : this.getRegisteredStrategies().values()) {
                try {
                    strategy.onRemoteAccess(this, request, localItem);
                }
                catch (ItemNotFoundException e) {
                    noRemoteAccessReason = e;
                    break;
                }
            }
        }
        if (noRemoteAccessReason == null) {
            block45: {
                if (localItem == null || request.isRequestAsExpired() || this.isOld(localItem)) {
                    try {
                        boolean shouldGetRemote = false;
                        if (localItem != null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Item " + request.toString() + " is old, checking for newer file on remote then local: " + new Date(localItem.getModified()));
                            }
                            try {
                                shouldGetRemote = this.doCheckRemoteItemExistence(localItem, request);
                                if (!shouldGetRemote) {
                                    this.markItemRemotelyChecked(localItem);
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("No newer version of item " + request.toString() + " found on remote storage.");
                                    }
                                } else if (this.log.isDebugEnabled()) {
                                    this.log.debug("Newer version of item " + request.toString() + " is found on remote storage.");
                                }
                            }
                            catch (RemoteStorageException ex) {
                                if (!(ex instanceof RemoteAccessDeniedException) && !(ex instanceof RemoteStorageTransportException)) {
                                    this.autoBlockProxying(ex);
                                }
                                if (ex instanceof RemoteStorageTransportException) {
                                    throw ex;
                                }
                                shouldGetRemote = false;
                            }
                            catch (IOException ex) {
                                shouldGetRemote = false;
                            }
                        } else {
                            shouldGetRemote = true;
                        }
                        if (shouldGetRemote) {
                            try {
                                remoteItem = this.doRetrieveRemoteItem(request);
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Item " + request.toString() + " found in remote storage.");
                                }
                                break block45;
                            }
                            catch (StorageException ex) {
                                if (ex instanceof RemoteStorageException && !(ex instanceof RemoteAccessDeniedException) && !(ex instanceof RemoteStorageTransportException)) {
                                    this.autoBlockProxying(ex);
                                }
                                if (ex instanceof RemoteStorageTransportException || ex instanceof LocalStorageEOFException) {
                                    throw ex;
                                }
                                if (ex instanceof RemoteAccessDeniedException) {
                                    this.log.debug("Error code 403 {} obtaining {} from remote storage.", (Object)ex.getMessage(), (Object)request);
                                    request.getRequestContext().put("remote.accessDeniedException", (Object)ex);
                                }
                                remoteItem = null;
                                try {
                                    if (localItem == null) {
                                        this.deleteItem(false, request);
                                    }
                                    break block45;
                                }
                                catch (ItemNotFoundException itemNotFoundException) {
                                    break block45;
                                }
                                catch (UnsupportedStorageOperationException unsupportedStorageOperationException) {}
                            }
                            break block45;
                        }
                        remoteItem = null;
                    }
                    catch (ItemNotFoundException ex) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Item " + request.toString() + " not found in remote storage.");
                        }
                        remoteItem = null;
                    }
                }
            }
            if (localItem == null && remoteItem == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Item " + request.toString() + " does not exist in local or remote storage, throwing ItemNotFoundException.");
                }
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Path %s not found in local nor in remote storage of %s", request.getRequestPath(), this));
            }
            if (localItem != null && remoteItem == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Item " + request.toString() + " does exist in local storage and is fresh, returning local one.");
                }
                item = localItem;
            } else {
                item = remoteItem;
            }
        } else if (localItem != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Item " + request.toString() + " does exist locally and cannot go remote, returning local one.");
            }
            item = localItem;
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Item " + request.toString() + " does not exist locally and cannot go remote, throwing ItemNotFoundException.");
            }
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, noRemoteAccessReason.getMessage(), new Object[0]), (Throwable)noRemoteAccessReason);
        }
        return item;
    }

    private void sendContentValidationEvents(ResourceStoreRequest request, List<RepositoryItemValidationEvent> events, boolean isContentValid) {
        if (this.log.isDebugEnabled() && !isContentValid) {
            this.log.debug("Item " + request.toString() + " failed content integrity validation.");
        }
        for (RepositoryItemValidationEvent event : events) {
            this.eventBus().post((Object)event);
        }
    }

    protected void markItemRemotelyChecked(StorageItem item) throws IOException, ItemNotFoundException {
        this.getAttributesHandler().touchItemCheckedRemotely(System.currentTimeMillis(), item);
    }

    protected boolean doValidateRemoteItemContent(ResourceStoreRequest req, String baseUrl, AbstractStorageItem item, List<RepositoryItemValidationEvent> events) {
        boolean isValid = true;
        for (Map.Entry<String, ItemContentValidator> icventry : this.getItemContentValidators().entrySet()) {
            try {
                boolean isValidByCurrentItemContentValidator = icventry.getValue().isRemoteItemContentValid(this, req, baseUrl, item, events);
                if (!isValidByCurrentItemContentValidator) {
                    this.log.info(String.format("Proxied item %s evaluated as INVALID during content validation (validator=%s, sourceUrl=%s)", item.getRepositoryItemUid().toString(), icventry.getKey(), item.getRemoteUrl()));
                }
                isValid = isValid && isValidByCurrentItemContentValidator;
            }
            catch (StorageException e) {
                this.log.info(String.format("Proxied item %s evaluated as INVALID during content validation (validator=%s, sourceUrl=%s)", item.getRepositoryItemUid().toString(), icventry.getKey(), item.getRemoteUrl()), (Throwable)e);
                isValid = false;
            }
        }
        return isValid;
    }

    protected boolean doCheckRemoteItemExistence(StorageItem localItem, ResourceStoreRequest request) throws RemoteAccessException, RemoteStorageException {
        if (localItem != null) {
            return this.getRemoteStorage().containsItem(localItem.getModified(), this, request);
        }
        return this.getRemoteStorage().containsItem(this, request);
    }

    protected AbstractStorageItem doRetrieveRemoteItem(ResourceStoreRequest request) throws ItemNotFoundException, RemoteAccessException, StorageException {
        RepositoryItemUid itemUid = this.createUid(request.getRequestPath());
        RepositoryItemUidLock itemUidLock = itemUid.getLock();
        itemUidLock.lock(Action.create);
        try {
            List<String> remoteUrls = this.getRemoteUrls(request);
            ArrayList<RepositoryItemValidationEvent> events = new ArrayList<RepositoryItemValidationEvent>();
            Exception lastException = null;
            boolean storageCleanupNeeded = false;
            block16: for (String remoteUrl : remoteUrls) {
                RemoteConnectionSettings settings;
                int retryCount = 1;
                if (this.getRemoteStorageContext() != null && (settings = this.getRemoteStorageContext().getRemoteConnectionSettings()) != null) {
                    retryCount = settings.getRetrievalRetryCount();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using URL:" + remoteUrl + ", retryCount=" + retryCount);
                }
                try {
                    this.getRemoteStorage().validateStorageUrl(remoteUrl);
                }
                catch (RemoteStorageException e) {
                    lastException = e;
                    this.logFailedUrl(remoteUrl, e);
                    continue;
                }
                catch (Exception e) {
                    lastException = e;
                    this.log.warn("Failed URL validation: {}", (Object)remoteUrl, (Object)e);
                    continue;
                }
                for (int i = 0; i < retryCount; ++i) {
                    Throwable t;
                    try {
                        AbstractStorageItem remoteItem = this.getRemoteStorage().retrieveItem(this, request, remoteUrl);
                        storageCleanupNeeded = true;
                        remoteItem = this.doCacheItem(remoteItem);
                        if (!this.doValidateRemoteItemContent(request, remoteUrl, remoteItem, events)) continue block16;
                        this.sendContentValidationEvents(request, events, true);
                        AbstractStorageItem abstractStorageItem = remoteItem;
                        return abstractStorageItem;
                    }
                    catch (ItemNotFoundException e) {
                        lastException = e;
                        continue block16;
                    }
                    catch (RemoteAccessException e) {
                        lastException = e;
                        this.logFailedUrl(remoteUrl, e);
                        continue block16;
                    }
                    catch (RemoteStorageException e) {
                        if (e instanceof RemoteStorageTransportException) {
                            throw e;
                        }
                        lastException = e;
                        if (this.log.isDebugEnabled()) {
                            this.logFailedUrl(remoteUrl, e);
                            continue;
                        }
                        t = ExceptionUtils.getRootCause((Throwable)e);
                        if (t == null) {
                            t = e;
                        }
                        this.log.error(String.format("Got RemoteStorageException in proxy repository %s while retrieving remote artifact \"%s\" from URL %s, this is %s (re)try, cause: %s: %s", RepositoryStringUtils.getHumanizedNameString(this), request.toString(), remoteUrl, String.valueOf(i + 1), t.getClass().getName(), t.getMessage()));
                        continue;
                    }
                    catch (LocalStorageException e) {
                        lastException = e;
                        if (this.log.isDebugEnabled()) {
                            this.logFailedUrl(remoteUrl, e);
                            continue;
                        }
                        t = ExceptionUtils.getRootCause((Throwable)e);
                        if (t == null) {
                            t = e;
                        }
                        this.log.error("Got LocalStorageException in proxy repository {} while caching retrieved artifact \"{}\" got from URL {}, will attempt next mirror", new Object[]{RepositoryStringUtils.getHumanizedNameString(this), request, remoteUrl, t});
                        continue;
                    }
                    catch (RuntimeException e) {
                        lastException = e;
                        this.log.warn("Failed URL retrieve/cache: {}", (Object)remoteUrl, (Object)e);
                        continue block16;
                    }
                }
            }
            if (storageCleanupNeeded || request.isRequestRemoteOnly()) {
                this.sendContentValidationEvents(request, events, false);
                try {
                    AbstractStorageItem item = this.getLocalStorage().retrieveItem(this, request);
                    if (!(item instanceof StorageCollectionItem)) {
                        this.getLocalStorage().deleteItem(this, request);
                    }
                }
                catch (ItemNotFoundException item) {
                }
                catch (UnsupportedStorageOperationException e) {
                    this.log.warn("Unexpected Exception in " + RepositoryStringUtils.getHumanizedNameString(this), (Throwable)e);
                }
            }
            if (lastException instanceof StorageException) {
                throw (StorageException)lastException;
            }
            if (lastException instanceof ItemNotFoundException) {
                throw (ItemNotFoundException)lastException;
            }
            if (storageCleanupNeeded) {
                throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Path %s fetched from remote storage of %s but failed validation.", request.getRequestPath(), this));
            }
            throw new ItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "Path %s could not be fetched from remote storage of %s", request.getRequestPath(), this), (Throwable)lastException);
        }
        finally {
            itemUidLock.unlock();
        }
    }

    protected List<String> getRemoteUrls(ResourceStoreRequest request) {
        return Lists.newArrayList((Object[])new String[]{this.getRemoteUrl()});
    }

    private void logFailedUrl(String url, Exception e) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Failed URL: {}", (Object)url, (Object)e);
        }
    }

    protected boolean isOld(StorageItem item) {
        return this.isOld(this.getItemMaxAge(), item);
    }

    protected boolean isOld(int maxAge, StorageItem item) {
        return this.isOld(maxAge, item, this.isItemAgingActive());
    }

    protected boolean isOld(int maxAge, StorageItem item, boolean shouldCalculate) {
        if (!shouldCalculate) {
            return true;
        }
        String itemInvalidationToken = item.getRepositoryItemAttributes().get(PROXY_CACHE_INVALIDATION_TOKEN_KEY);
        if (this.proxyCacheInvalidationToken != null && !this.proxyCacheInvalidationToken.equals(itemInvalidationToken)) {
            this.log.debug("Item treated as expired due to proxy-cache invalidation token mismatch: {} != {}; item: {}", new Object[]{this.proxyCacheInvalidationToken, itemInvalidationToken, item});
            item.setExpired(true);
            item.getRepositoryItemAttributes().put(PROXY_CACHE_INVALIDATION_TOKEN_KEY, this.proxyCacheInvalidationToken);
            try {
                this.getAttributesHandler().storeAttributes(item);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return true;
        }
        if (item.isExpired()) {
            return true;
        }
        if (StorageCollectionItem.class.isAssignableFrom(item.getClass())) {
            return false;
        }
        if (maxAge < 0) {
            return false;
        }
        return System.currentTimeMillis() - item.getRemoteChecked() >= (long)maxAge * 60L * 1000L;
    }

    protected boolean isRemoteStorageReachable(ResourceStoreRequest request) throws StorageException {
        return this.getRemoteStorage().isReachable(this, request);
    }

    @Override
    protected boolean isActionAllowedReadOnly(Action action) {
        return action.equals((Object)Action.read) || action.equals((Object)Action.delete);
    }

    @Override
    protected boolean shouldAddToNotFoundCache(ResourceStoreRequest request) {
        boolean shouldAddToNFC = super.shouldAddToNotFoundCache(request);
        if (shouldAddToNFC) {
            boolean bl = shouldAddToNFC = this.getProxyMode() == null || this.getProxyMode().shouldProxy();
            if (!shouldAddToNFC && this.log.isDebugEnabled()) {
                this.log.debug(String.format("Proxy repository '%s' is is not allowed to issue remote requests (%s), not adding path '%s' to NFC", new Object[]{this.getId(), this.getProxyMode(), request.getRequestPath()}));
            }
        }
        return shouldAddToNFC;
    }

    static {
        if (PROXY_CACHE_INVALIDATION_TOKEN_DISABLED) {
            LoggerFactory.getLogger(AbstractProxyRepository.class).info("Proxy-cache invalidation-token support disabled");
        }
    }

    private class RemoteStatusUpdateCallable
    implements Callable<Object> {
        private ResourceStoreRequest request;

        public RemoteStatusUpdateCallable(ResourceStoreRequest request) {
            this.request = request;
        }

        @Override
        public Object call() throws Exception {
            block7: {
                try {
                    try {
                        if (!AbstractProxyRepository.this.getProxyMode().shouldCheckRemoteStatus()) {
                            AbstractProxyRepository.this.setRemoteStatus(RemoteStatus.UNAVAILABLE, new ItemNotFoundException(ItemNotFoundException.reasonFor(this.request, AbstractProxyRepository.this, "Proxy mode %s or repository %s forbids remote storage use.", new Object[]{AbstractProxyRepository.this.getProxyMode(), AbstractProxyRepository.this})));
                            break block7;
                        }
                        if (AbstractProxyRepository.this.isRemoteStorageReachable(this.request)) {
                            AbstractProxyRepository.this.autoUnBlockProxying();
                            break block7;
                        }
                        AbstractProxyRepository.this.autoBlockProxying(new ItemNotFoundException(ItemNotFoundException.reasonFor(this.request, AbstractProxyRepository.this, "Remote peer of repository %s detected as unavailable.", AbstractProxyRepository.this)));
                    }
                    catch (RemoteStorageException e) {
                        AbstractProxyRepository.this.autoBlockProxying(e);
                    }
                }
                finally {
                    AbstractProxyRepository.this._remoteStatusChecking = false;
                }
            }
            return null;
        }
    }
}

