/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.CoreConfiguration;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.proxy.repository.AbstractRepositoryConfiguration;

public class AbstractGroupRepositoryConfiguration
extends AbstractRepositoryConfiguration {
    private static final String MEMBER_REPOSITORIES = "memberRepositories";

    public AbstractGroupRepositoryConfiguration(Xpp3Dom configuration) {
        super(configuration);
    }

    public List<String> getMemberRepositoryIds() {
        return this.getCollection(this.getRootNode(), MEMBER_REPOSITORIES);
    }

    public void setMemberRepositoryIds(List<String> ids) {
        this.setCollection(this.getRootNode(), MEMBER_REPOSITORIES, ids);
    }

    public void clearMemberRepositoryIds() {
        List<String> empty = Collections.emptyList();
        this.setCollection(this.getRootNode(), MEMBER_REPOSITORIES, empty);
    }

    public void addMemberRepositoryId(String repositoryId) {
        this.addToCollection(this.getRootNode(), MEMBER_REPOSITORIES, repositoryId, true);
    }

    public void removeMemberRepositoryId(String repositoryId) {
        this.removeFromCollection(this.getRootNode(), MEMBER_REPOSITORIES, repositoryId);
    }

    @Override
    public ValidationResponse doValidateChanges(ApplicationConfiguration applicationConfiguration, CoreConfiguration owner, Xpp3Dom config) {
        HashSet uniqueReposesIds;
        ValidationResponse response = super.doValidateChanges(applicationConfiguration, owner, config);
        List allReposes = applicationConfiguration.getConfigurationModel().getRepositories();
        ArrayList<String> allReposesIds = new ArrayList<String>(allReposes.size());
        for (CRepository repository : allReposes) {
            allReposesIds.add(repository.getId());
        }
        List<String> memberRepositoryIds = this.getMemberRepositoryIds();
        if (!allReposesIds.containsAll(memberRepositoryIds)) {
            ValidationMessage message = new ValidationMessage(MEMBER_REPOSITORIES, "Group repository points to nonexistent members!", "The source nexus repository is not existing.");
            response.addValidationError(message);
        }
        if ((uniqueReposesIds = Sets.newHashSet(memberRepositoryIds)).size() != memberRepositoryIds.size()) {
            response.addValidationError(new ValidationMessage(MEMBER_REPOSITORIES, "Group repository has same member multiple times!", "Group repository has same member multiple times!"));
        }
        return response;
    }
}

