/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.LocalStorageException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.events.RepositoryEventEvictUnusedItems;
import org.sonatype.nexus.proxy.events.RepositoryGroupMembersChangedEvent;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.item.DefaultStorageCollectionItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsGroupLocalOnlyAttribute;
import org.sonatype.nexus.proxy.mapping.RequestRepositoryMapper;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.AbstractGroupRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.AbstractRepository;
import org.sonatype.nexus.proxy.repository.GroupItemNotFoundException;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.InvalidGroupingException;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.proxy.walker.WalkerFilter;

public abstract class AbstractGroupRepository
extends AbstractRepository
implements GroupRepository {
    private RepositoryRegistry repoRegistry;
    private RequestRepositoryMapper requestRepositoryMapper;

    @Inject
    public void populateAbstractGroupRepository(RepositoryRegistry repoRegistry, RequestRepositoryMapper requestRepositoryMapper) {
        this.repoRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repoRegistry);
        this.requestRepositoryMapper = requestRepositoryMapper;
    }

    @Override
    protected AbstractGroupRepositoryConfiguration getExternalConfiguration(boolean forWrite) {
        return (AbstractGroupRepositoryConfiguration)super.getExternalConfiguration(forWrite);
    }

    @Subscribe
    public void onEvent(RepositoryRegistryEventRemove evt) {
        AbstractGroupRepositoryConfiguration extConfig = this.getExternalConfiguration(false);
        if (extConfig != null && extConfig.getMemberRepositoryIds().contains(evt.getRepository().getId())) {
            this.removeMemberRepositoryId(evt.getRepository().getId());
        }
    }

    @Override
    protected void prepareForSave() throws ConfigurationException {
        super.prepareForSave();
        boolean membersChanged = false;
        List<String> currentMemberIds = Collections.emptyList();
        List<String> newMemberIds = Collections.emptyList();
        if (this.isConfigured()) {
            boolean bl = membersChanged = this.getCurrentCoreConfiguration().isDirty() && !this.getExternalConfiguration(false).getMemberRepositoryIds().equals(this.getExternalConfiguration(true).getMemberRepositoryIds());
            if (membersChanged) {
                currentMemberIds = this.getExternalConfiguration(false).getMemberRepositoryIds();
                newMemberIds = this.getExternalConfiguration(true).getMemberRepositoryIds();
            }
        }
        if (membersChanged) {
            this.eventBus().post((Object)new RepositoryGroupMembersChangedEvent(this, currentMemberIds, newMemberIds));
        }
    }

    @Override
    protected boolean doExpireCaches(ResourceStoreRequest request, WalkerFilter filter) {
        List<Repository> members = this.getMemberRepositories();
        for (Repository member : members) {
            member.expireCaches(request, filter);
        }
        return super.doExpireCaches(request, filter);
    }

    @Override
    protected Collection<String> doEvictUnusedItems(ResourceStoreRequest request, long timestamp) {
        HashSet<String> result = new HashSet<String>();
        List<Repository> members = this.getMemberRepositories();
        for (Repository repository : members) {
            result.addAll(repository.evictUnusedItems(request, timestamp));
        }
        this.eventBus().post((Object)new RepositoryEventEvictUnusedItems(this));
        return result;
    }

    @Override
    protected Collection<StorageItem> doListItems(ResourceStoreRequest request) throws ItemNotFoundException, StorageException {
        HashSet<String> names = new HashSet<String>();
        ArrayList<StorageItem> result = new ArrayList<StorageItem>();
        boolean found = false;
        try {
            AbstractGroupRepository.addItems(names, result, this.getLocalStorage().listItems(this, request));
            found = true;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        RepositoryItemUid uid = this.createUid(request.getRequestPath());
        boolean isRequestGroupLocalOnly = request.isRequestGroupLocalOnly() || uid.getBooleanAttributeValue(IsGroupLocalOnlyAttribute.class);
        LinkedHashMap memberThrowables = Maps.newLinkedHashMap();
        if (!isRequestGroupLocalOnly) {
            for (Repository repo : this.getMemberRepositories()) {
                if (!request.getProcessedRepositories().contains(repo.getId())) {
                    try {
                        AbstractGroupRepository.addItems(names, result, repo.list(false, request));
                        found = true;
                    }
                    catch (ItemNotFoundException e) {
                        memberThrowables.put(repo, e);
                    }
                    catch (IllegalOperationException e) {
                        memberThrowables.put(repo, e);
                    }
                    catch (StorageException e) {
                        memberThrowables.put(repo, e);
                    }
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(String.format("Repository %s member of group %s was already processed during this request! Skipping it from processing. Request: %s", RepositoryStringUtils.getHumanizedNameString(repo), RepositoryStringUtils.getHumanizedNameString(this), request.toString()));
            }
        }
        if (!found) {
            if (!isRequestGroupLocalOnly) {
                throw new GroupItemNotFoundException(request, this, memberThrowables);
            }
            throw new GroupItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "The %s not found in local storage of group repository %s (no member processing happened).", request.getRequestPath(), this), memberThrowables);
        }
        return result;
    }

    private static void addItems(HashSet<String> names, ArrayList<StorageItem> result, Collection<StorageItem> listItems) {
        for (StorageItem item : listItems) {
            if (!names.add(item.getPath())) continue;
            result.add(item);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected StorageItem doRetrieveItem(ResourceStoreRequest request) throws IllegalOperationException, ItemNotFoundException, StorageException {
        LinkedHashMap memberThrowables;
        boolean hasRequestAuthorizedFlag;
        block18: {
            boolean isRequestGroupLocalOnly;
            if (!request.isRequestGroupMembersOnly()) {
                try {
                    return super.doRetrieveItem(request);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
            if (!(hasRequestAuthorizedFlag = request.getRequestContext().containsKey("request.authorized"))) {
                request.getRequestContext().put("request.authorized", (Object)Boolean.TRUE);
            }
            memberThrowables = Maps.newLinkedHashMap();
            RepositoryItemUid uid = this.createUid(request.getRequestPath());
            boolean bl = isRequestGroupLocalOnly = request.isRequestGroupLocalOnly() || uid.getBooleanAttributeValue(IsGroupLocalOnlyAttribute.class);
            if (!isRequestGroupLocalOnly) {
                for (Repository repo : this.getRequestRepositories(request)) {
                    if (!request.getProcessedRepositories().contains(repo.getId())) {
                        try {
                            StorageItem item = repo.retrieveItem(request);
                            if (item instanceof StorageCollectionItem) {
                                item = new DefaultStorageCollectionItem(this, request, true, false);
                            }
                            StorageItem storageItem = item;
                            return storageItem;
                        }
                        catch (IllegalOperationException e) {
                            memberThrowables.put(repo, e);
                            continue;
                        }
                        catch (ItemNotFoundException e) {
                            memberThrowables.put(repo, e);
                            continue;
                        }
                        catch (StorageException e) {
                            memberThrowables.put(repo, e);
                            continue;
                        }
                        catch (AccessDeniedException e) {
                            memberThrowables.put(repo, e);
                            continue;
                        }
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug(String.format("Repository %s member of group %s was already processed during this request! Skipping it from processing. Request: %s", RepositoryStringUtils.getHumanizedNameString(repo), RepositoryStringUtils.getHumanizedNameString(this), request.toString()));
                }
            }
            if (isRequestGroupLocalOnly) break block18;
            throw new GroupItemNotFoundException(request, this, memberThrowables);
        }
        throw new GroupItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "The %s not found in local storage of group repository %s (no member processing happened).", request.getRequestPath(), this), memberThrowables);
        finally {
            if (!hasRequestAuthorizedFlag) {
                request.getRequestContext().remove("request.authorized");
            }
        }
    }

    @Override
    public List<String> getMemberRepositoryIds() {
        ArrayList<String> result = new ArrayList<String>(this.getExternalConfiguration(false).getMemberRepositoryIds().size());
        for (String id : this.getExternalConfiguration(false).getMemberRepositoryIds()) {
            result.add(id);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void setMemberRepositoryIds(List<String> repositories) throws NoSuchRepositoryException, InvalidGroupingException {
        this.getExternalConfiguration(true).clearMemberRepositoryIds();
        for (String repoId : repositories) {
            this.addMemberRepositoryId(repoId);
        }
    }

    @Override
    public void addMemberRepositoryId(String repositoryId) throws NoSuchRepositoryException, InvalidGroupingException {
        Repository repo = this.repoRegistry.getRepository(repositoryId);
        ArrayList<String> memberIds = new ArrayList<String>(this.getExternalConfiguration(false).getMemberRepositoryIds());
        memberIds.add(repo.getId());
        this.checkForCyclicReference(this.getId(), memberIds, this.getId());
        this.validateMemberRepository(repo);
        this.getExternalConfiguration(true).addMemberRepositoryId(repo.getId());
    }

    private void checkForCyclicReference(String id, List<String> memberRepositoryIds, String path) throws InvalidGroupingException {
        if (memberRepositoryIds.contains(id)) {
            throw new InvalidGroupingException(id, path);
        }
        for (String memberId : memberRepositoryIds) {
            try {
                GroupRepository group = this.repoRegistry.getRepositoryWithFacet(memberId, GroupRepository.class);
                this.checkForCyclicReference(id, group.getMemberRepositoryIds(), path + '/' + memberId);
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {}
        }
    }

    @Override
    public void removeMemberRepositoryId(String repositoryId) {
        this.getExternalConfiguration(true).removeMemberRepositoryId(repositoryId);
    }

    @Override
    public List<Repository> getMemberRepositories() {
        ArrayList<Repository> result = new ArrayList<Repository>();
        for (String repoId : this.getMemberRepositoryIds()) {
            try {
                Repository repo = this.repoRegistry.getRepository(repoId);
                result.add(repo);
            }
            catch (NoSuchRepositoryException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn("Could not find repository '{}' while iterating members", (Object)repoId, (Object)e);
                    continue;
                }
                this.log.warn("Could not find repository '{}' while iterating members", (Object)repoId);
            }
        }
        return result;
    }

    protected void validateMemberRepository(Repository repository) throws InvalidGroupingException {
        if (!this.getRepositoryContentClass().isCompatible(repository.getRepositoryContentClass())) {
            throw new InvalidGroupingException(this.getRepositoryContentClass(), repository.getRepositoryContentClass());
        }
    }

    protected List<Repository> getRequestRepositories(ResourceStoreRequest request) throws StorageException {
        List<Repository> members = this.getMemberRepositories();
        try {
            return this.requestRepositoryMapper.getMappedRepositories(this, request, members);
        }
        catch (NoSuchResourceStoreException e) {
            throw new LocalStorageException(e);
        }
    }

    @Override
    public List<StorageItem> doRetrieveItems(ResourceStoreRequest request) throws GroupItemNotFoundException, StorageException {
        ArrayList<StorageItem> items = new ArrayList<StorageItem>();
        RepositoryItemUid uid = this.createUid(request.getRequestPath());
        boolean isRequestGroupLocalOnly = request.isRequestGroupLocalOnly() || uid.getBooleanAttributeValue(IsGroupLocalOnlyAttribute.class);
        LinkedHashMap memberThrowables = Maps.newLinkedHashMap();
        if (!isRequestGroupLocalOnly) {
            for (Repository repository : this.getRequestRepositories(request)) {
                if (!request.getProcessedRepositories().contains(repository.getId())) {
                    try {
                        StorageItem item = repository.retrieveItem(false, request);
                        items.add(item);
                        continue;
                    }
                    catch (ItemNotFoundException e) {
                        memberThrowables.put(repository, e);
                        continue;
                    }
                    catch (RepositoryNotAvailableException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(RepositoryStringUtils.getFormattedMessage("Member repository %s is not available, request failed.", e.getRepository()));
                        }
                        memberThrowables.put(repository, e);
                        continue;
                    }
                    catch (StorageException e) {
                        throw e;
                    }
                    catch (IllegalOperationException e) {
                        this.log.warn("Member repository request failed", (Throwable)e);
                        memberThrowables.put(repository, e);
                        continue;
                    }
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(String.format("Repository %s member of group %s was already processed during this request! Skipping it from processing. Request: %s", RepositoryStringUtils.getHumanizedNameString(repository), RepositoryStringUtils.getHumanizedNameString(this), request.toString()));
            }
        }
        if (items.isEmpty()) {
            if (!isRequestGroupLocalOnly) {
                throw new GroupItemNotFoundException(request, this, memberThrowables);
            }
            throw new GroupItemNotFoundException(ItemNotFoundException.reasonFor(request, this, "The %s not found in local storage of group repository %s (no member processing happened).", request.getRequestPath(), this), memberThrowables);
        }
        return items;
    }

    @Override
    public void maintainNotFoundCache(ResourceStoreRequest request) throws ItemNotFoundException {
        try {
            super.maintainNotFoundCache(request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public List<Repository> getTransitiveMemberRepositories() {
        return this.getTransitiveMemberRepositories(this);
    }

    protected List<Repository> getTransitiveMemberRepositories(GroupRepository group) {
        ArrayList<Repository> repos = new ArrayList<Repository>();
        for (Repository repo : group.getMemberRepositories()) {
            if (repo.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
                repos.addAll(this.getTransitiveMemberRepositories(repo.adaptToFacet(GroupRepository.class)));
                continue;
            }
            repos.add(repo);
        }
        return repos;
    }

    @Override
    public List<String> getTransitiveMemberRepositoryIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Repository repo : this.getTransitiveMemberRepositories()) {
            ids.add(repo.getId());
        }
        return ids;
    }
}

