/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.registry;

import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;

public class RepositoryTypeDescriptor {
    private final Class<? extends Repository> role;
    private final String hint;
    private final String prefix;
    private final int repositoryMaxInstanceCount;
    private AtomicInteger instanceCount = new AtomicInteger(0);

    public RepositoryTypeDescriptor(Class<? extends Repository> role, String hint, String prefix) {
        this(role, hint, prefix, -1);
    }

    public RepositoryTypeDescriptor(Class<? extends Repository> role, String hint, String prefix, int repositoryMaxInstanceCount) {
        this.role = role;
        this.hint = hint;
        this.prefix = prefix;
        this.repositoryMaxInstanceCount = repositoryMaxInstanceCount;
    }

    public Class<? extends Repository> getRole() {
        return this.role;
    }

    public String getHint() {
        return this.hint;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getRepositoryMaxInstanceCount() {
        return this.repositoryMaxInstanceCount;
    }

    public int getInstanceCount() {
        return this.instanceCount.get();
    }

    public int instanceRegistered(RepositoryRegistry registry) {
        return this.instanceCount.incrementAndGet();
    }

    public int instanceUnregistered(RepositoryRegistry registry) {
        return this.instanceCount.decrementAndGet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        RepositoryTypeDescriptor other = (RepositoryTypeDescriptor)o;
        return this.getRole().equals(other.getRole()) && StringUtils.equals((String)this.getHint(), (String)other.getHint()) && StringUtils.equals((String)this.getPrefix(), (String)other.getPrefix());
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + (this.hint == null ? 0 : this.hint.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public String toString() {
        return "RepositoryType=(" + this.getRole().getName() + ":" + this.getHint() + ")";
    }
}

