/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.configuration.application.runtime.ApplicationRuntimeConfigurationBuilder;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryTypeDescriptor;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;

@Singleton
@Named
public class DefaultRepositoryTypeRegistry
implements RepositoryTypeRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRepositoryTypeRegistry.class);
    private final Map<String, ContentClass> contentClasses;
    private final ApplicationRuntimeConfigurationBuilder applicationRuntimeConfigurationBuilder;
    private ConcurrentMap<String, ContentClass> repoCachedContentClasses;
    private Multimap<Class<? extends Repository>, RepositoryTypeDescriptor> repositoryTypeDescriptorsMap;

    @Inject
    public DefaultRepositoryTypeRegistry(Map<String, ContentClass> contentClasses, ApplicationRuntimeConfigurationBuilder applicationRuntimeConfigurationBuilder) {
        this.contentClasses = (Map)Preconditions.checkNotNull(contentClasses);
        this.applicationRuntimeConfigurationBuilder = (ApplicationRuntimeConfigurationBuilder)Preconditions.checkNotNull((Object)applicationRuntimeConfigurationBuilder);
        this.repoCachedContentClasses = Maps.newConcurrentMap();
        ArrayListMultimap result = ArrayListMultimap.create();
        Class<Repository> role = null;
        role = Repository.class;
        result.put(role, (Object)new RepositoryTypeDescriptor(role, "maven1", "repositories", -1));
        result.put(role, (Object)new RepositoryTypeDescriptor(role, "maven2", "repositories", -1));
        role = ShadowRepository.class;
        result.put(role, (Object)new RepositoryTypeDescriptor(role, "m2-m1-shadow", "shadows", -1));
        result.put(role, (Object)new RepositoryTypeDescriptor(role, "m1-m2-shadow", "shadows", -1));
        role = GroupRepository.class;
        result.put(role, (Object)new RepositoryTypeDescriptor(role, "maven1", "groups", -1));
        result.put(role, (Object)new RepositoryTypeDescriptor(role, "maven2", "groups", -1));
        logger.info("Registered default repository types.");
        this.repositoryTypeDescriptorsMap = result;
    }

    protected Multimap<Class<? extends Repository>, RepositoryTypeDescriptor> getRepositoryTypeDescriptors() {
        return this.repositoryTypeDescriptorsMap;
    }

    @Override
    public Set<RepositoryTypeDescriptor> getRegisteredRepositoryTypeDescriptors() {
        return Collections.unmodifiableSet(new HashSet(this.getRepositoryTypeDescriptors().values()));
    }

    @Override
    public boolean registerRepositoryTypeDescriptors(RepositoryTypeDescriptor d) {
        boolean added = this.getRepositoryTypeDescriptors().put(d.getRole(), (Object)d);
        if (added) {
            if (d.getRepositoryMaxInstanceCount() == -1) {
                logger.info("Registered Repository type " + d.toString() + ".");
            } else {
                logger.info("Registered Repository type " + d.toString() + " with maximal instance limit set to " + d.getRepositoryMaxInstanceCount() + ".");
            }
        }
        return added;
    }

    @Override
    public boolean unregisterRepositoryTypeDescriptors(RepositoryTypeDescriptor d) {
        boolean removed = this.getRepositoryTypeDescriptors().remove(d.getRole(), (Object)d);
        if (removed) {
            logger.info("Unregistered repository type " + d.toString());
        }
        return removed;
    }

    @Override
    public Map<String, ContentClass> getContentClasses() {
        return Collections.unmodifiableMap(new HashMap<String, ContentClass>(this.contentClasses));
    }

    @Override
    public Set<String> getCompatibleContentClasses(ContentClass contentClass) {
        HashSet<String> compatibles = new HashSet<String>();
        for (ContentClass cc : this.contentClasses.values()) {
            if (!cc.isCompatible(contentClass) && !contentClass.isCompatible(cc)) continue;
            compatibles.add(cc.getId());
        }
        return compatibles;
    }

    @Override
    public Set<Class<? extends Repository>> getRepositoryRoles() {
        Set<RepositoryTypeDescriptor> rtds = this.getRegisteredRepositoryTypeDescriptors();
        HashSet<Class<? extends Repository>> result = new HashSet<Class<? extends Repository>>(rtds.size());
        for (RepositoryTypeDescriptor rtd : rtds) {
            result.add(rtd.getRole());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<String> getExistingRepositoryHints(Class<? extends Repository> role) {
        if (!this.getRepositoryTypeDescriptors().containsKey(role)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (RepositoryTypeDescriptor rtd : this.getRepositoryTypeDescriptors().get(role)) {
            result.add(rtd.getHint());
        }
        return result;
    }

    @Override
    public RepositoryTypeDescriptor getRepositoryTypeDescriptor(Class<? extends Repository> role, String hint) {
        if (!this.getRepositoryTypeDescriptors().containsKey(role)) {
            return null;
        }
        for (RepositoryTypeDescriptor rtd : this.getRepositoryTypeDescriptors().get(role)) {
            if (!rtd.getHint().equals(hint)) continue;
            return rtd;
        }
        return null;
    }

    @Override
    @Deprecated
    public RepositoryTypeDescriptor getRepositoryTypeDescriptor(String role, String hint) {
        Class roleClass = null;
        for (Class registeredClass : this.getRepositoryTypeDescriptors().keySet()) {
            if (!registeredClass.getName().equals(role)) continue;
            roleClass = registeredClass;
            break;
        }
        if (roleClass == null) {
            return null;
        }
        for (RepositoryTypeDescriptor rtd : this.getRepositoryTypeDescriptors().get(roleClass)) {
            if (!rtd.getHint().equals(hint)) continue;
            return rtd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentClass getRepositoryContentClass(Class<? extends Repository> role, String hint) {
        if (!this.getRepositoryRoles().contains(role)) {
            return null;
        }
        ContentClass result = null;
        String cacheKey = role + ":" + hint;
        if (this.repoCachedContentClasses.containsKey(cacheKey)) {
            result = (ContentClass)this.repoCachedContentClasses.get(cacheKey);
        } else {
            try {
                Repository repository = null;
                try {
                    repository = this.applicationRuntimeConfigurationBuilder.createRepository(role, hint);
                    result = repository.getRepositoryContentClass();
                    this.repoCachedContentClasses.put(cacheKey, result);
                }
                finally {
                    this.applicationRuntimeConfigurationBuilder.releaseRepository(repository);
                }
            }
            catch (Exception e) {
                logger.warn("Container lookup failed", (Throwable)e);
                result = null;
            }
        }
        return result;
    }
}

