/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.AbstractConfigurable;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventPostRemove;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.registry.RepositoryTypeDescriptor;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Singleton
@Named
public class DefaultRepositoryRegistry
extends ComponentSupport
implements RepositoryRegistry {
    private final EventBus eventBus;
    private final RepositoryTypeRegistry repositoryTypeRegistry;
    private final Map<String, Repository> _repositories = Maps.newHashMap();
    private volatile Map<String, Repository> _repositoriesView;

    @Inject
    public DefaultRepositoryRegistry(EventBus eventBus, RepositoryTypeRegistry repositoryTypeRegistry) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.repositoryTypeRegistry = (RepositoryTypeRegistry)Preconditions.checkNotNull((Object)repositoryTypeRegistry);
    }

    @Override
    public void addRepository(Repository repository) {
        RepositoryTypeDescriptor rtd = this.repositoryTypeRegistry.getRepositoryTypeDescriptor(repository.getProviderRole(), repository.getProviderHint());
        this.insertRepository(rtd, repository);
        this.log.info("Added repository {}", (Object)RepositoryStringUtils.getFullHumanizedNameString(repository));
    }

    @Override
    public void removeRepository(String repoId) throws NoSuchRepositoryException {
        this.doRemoveRepository(repoId, false);
    }

    @Override
    public void removeRepositorySilently(String repoId) throws NoSuchRepositoryException {
        this.doRemoveRepository(repoId, true);
    }

    @Override
    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(new ArrayList<Repository>(this.getRepositoriesMap().values()));
    }

    @Override
    public <T> List<T> getRepositoriesWithFacet(Class<T> f) {
        List<Repository> repositories = this.getRepositories();
        ArrayList<T> result = new ArrayList<T>();
        for (Repository repository : repositories) {
            if (!repository.getRepositoryKind().isFacetAvailable(f)) continue;
            result.add(repository.adaptToFacet(f));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Repository getRepository(String repoId) throws NoSuchRepositoryException {
        Map<String, Repository> repositories = this.getRepositoriesMap();
        if (repositories.containsKey(repoId)) {
            return repositories.get(repoId);
        }
        throw new NoSuchRepositoryException(repoId);
    }

    @Override
    public <T> T getRepositoryWithFacet(String repoId, Class<T> f) throws NoSuchRepositoryException {
        Repository r = this.getRepository(repoId);
        if (r.getRepositoryKind().isFacetAvailable(f)) {
            return r.adaptToFacet(f);
        }
        throw new NoSuchRepositoryException(repoId);
    }

    @Override
    public boolean repositoryIdExists(String repositoryId) {
        return this.getRepositoriesMap().containsKey(repositoryId);
    }

    @Override
    public List<String> getGroupsOfRepository(String repositoryId) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Repository repository = this.getRepository(repositoryId);
            for (GroupRepository group : this.getGroupsOfRepository(repository)) {
                result.add(group.getId());
            }
        }
        catch (NoSuchRepositoryException noSuchRepositoryException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public List<GroupRepository> getGroupsOfRepository(Repository repository) {
        ArrayList<GroupRepository> result = new ArrayList<GroupRepository>();
        block0: for (Repository repo : this.getRepositories()) {
            if (repo.getId().equals(repository.getId()) || !repo.getRepositoryKind().isFacetAvailable(GroupRepository.class)) continue;
            GroupRepository group = repo.adaptToFacet(GroupRepository.class);
            for (Repository member : group.getMemberRepositories()) {
                if (!repository.getId().equals(member.getId())) continue;
                result.add(group);
                continue block0;
            }
        }
        return result;
    }

    protected synchronized Map<String, Repository> getRepositoriesMap() {
        if (this._repositoriesView == null) {
            this._repositoriesView = Collections.unmodifiableMap(new HashMap<String, Repository>(this._repositories));
        }
        return this._repositoriesView;
    }

    protected synchronized void repositoriesMapPut(Repository repository) {
        this._repositories.put(repository.getId(), repository);
        this._repositoriesView = Collections.unmodifiableMap(new HashMap<String, Repository>(this._repositories));
    }

    protected synchronized void repositoriesMapRemove(String repositoryId) {
        this._repositories.remove(repositoryId);
        this._repositoriesView = Collections.unmodifiableMap(new HashMap<String, Repository>(this._repositories));
    }

    protected void doRemoveRepository(String repoId, boolean silently) throws NoSuchRepositoryException {
        Repository repository = this.getRepository(repoId);
        RepositoryTypeDescriptor rtd = this.repositoryTypeRegistry.getRepositoryTypeDescriptor(repository.getProviderRole(), repository.getProviderHint());
        this.deleteRepository(rtd, repository, silently);
        if (!silently) {
            this.log.info("Removed repository {}", (Object)RepositoryStringUtils.getFullHumanizedNameString(repository));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRepository(RepositoryTypeDescriptor rtd, Repository repository) {
        DefaultRepositoryRegistry defaultRepositoryRegistry = this;
        synchronized (defaultRepositoryRegistry) {
            this.repositoriesMapPut(repository);
            rtd.instanceRegistered(this);
        }
        this.eventBus.post((Object)new RepositoryRegistryEventAdd(this, repository));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRepository(RepositoryTypeDescriptor rtd, Repository repository, boolean silently) {
        if (!silently) {
            this.eventBus.post((Object)new RepositoryRegistryEventRemove(this, repository));
        }
        if (repository instanceof AbstractConfigurable) {
            ((AbstractConfigurable)((Object)repository)).unregisterFromEventBus();
        }
        DefaultRepositoryRegistry defaultRepositoryRegistry = this;
        synchronized (defaultRepositoryRegistry) {
            rtd.instanceUnregistered(this);
            this.repositoriesMapRemove(repository.getId());
        }
        if (!silently) {
            this.eventBus.post((Object)new RepositoryRegistryEventPostRemove(this, repository));
        }
    }
}

