/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.mirror;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.configuration.model.CMirror;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.proxy.mirror.PublishedMirrors;
import org.sonatype.nexus.proxy.repository.Mirror;

public class DefaultPublishedMirrors
implements PublishedMirrors {
    private final CRepositoryCoreConfiguration configuration;

    public DefaultPublishedMirrors(CRepositoryCoreConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setMirrors(List<Mirror> mirrors) {
        if (mirrors == null || mirrors.isEmpty()) {
            this.getConfiguration(true).getMirrors().clear();
        } else {
            ArrayList<CMirror> modelMirrors = new ArrayList<CMirror>(mirrors.size());
            for (Mirror mirror : mirrors) {
                CMirror model = new CMirror();
                model.setId(mirror.getId());
                model.setUrl(mirror.getUrl());
                modelMirrors.add(model);
            }
            this.getConfiguration(true).setMirrors(modelMirrors);
        }
    }

    @Override
    public List<Mirror> getMirrors() {
        List modelMirrors = this.getConfiguration(false).getMirrors();
        ArrayList<Mirror> mirrors = new ArrayList<Mirror>(modelMirrors.size());
        for (CMirror model : modelMirrors) {
            Mirror mirror = new Mirror(model.getId(), model.getUrl());
            mirrors.add(mirror);
        }
        return Collections.unmodifiableList(mirrors);
    }

    protected CRepository getConfiguration(boolean forWrite) {
        return (CRepository)this.configuration.getConfiguration(forWrite);
    }
}

