/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.task.executor;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableRunnable;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableSupport;
import org.sonatype.nexus.proxy.maven.routing.internal.task.executor.ConstrainedExecutor;
import org.sonatype.nexus.proxy.maven.routing.internal.task.executor.Statistics;

public class ConstrainedExecutorImpl
implements ConstrainedExecutor {
    private final Executor executor;
    private final HashMap<String, CancelableRunnableWrapper> currentlyRunningCancelableRunnables;
    private final HashMap<String, Semaphore> currentlyRunningSemaphores;

    public ConstrainedExecutorImpl(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.currentlyRunningCancelableRunnables = new HashMap();
        this.currentlyRunningSemaphores = new HashMap();
    }

    @Override
    public synchronized Statistics getStatistics() {
        return new Statistics(new HashSet<String>(this.currentlyRunningCancelableRunnables.keySet()));
    }

    @Override
    public synchronized void cancelAllJobs() {
        for (CancelableRunnable cancelableRunnable : this.currentlyRunningCancelableRunnables.values()) {
            cancelableRunnable.cancel();
        }
        this.currentlyRunningCancelableRunnables.clear();
        this.currentlyRunningSemaphores.clear();
    }

    @Override
    public synchronized boolean hasRunningWithKey(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.currentlyRunningCancelableRunnables.containsKey(key);
    }

    @Override
    public synchronized boolean cancelRunningWithKey(String key) {
        Preconditions.checkNotNull((Object)key);
        CancelableRunnableWrapper oldCommand = this.currentlyRunningCancelableRunnables.get(key);
        if (oldCommand != null) {
            oldCommand.cancel();
        }
        return oldCommand != null;
    }

    @Override
    public synchronized boolean mayExecute(String key, CancelableRunnable command) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)command);
        CancelableRunnableWrapper oldCommand = this.currentlyRunningCancelableRunnables.get(key);
        if (oldCommand != null) {
            return false;
        }
        CancelableRunnableWrapper wrappedCommand = new CancelableRunnableWrapper(this, key, this.getSemaphore(key), command);
        this.currentlyRunningCancelableRunnables.put(key, wrappedCommand);
        this.executor.execute(wrappedCommand);
        return true;
    }

    @Override
    public synchronized boolean mustExecute(String key, CancelableRunnable command) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)command);
        boolean canceledOldJob = this.cancelRunningWithKey(key);
        CancelableRunnableWrapper wrappedCommand = new CancelableRunnableWrapper(this, key, this.getSemaphore(key), command);
        this.currentlyRunningCancelableRunnables.put(key, wrappedCommand);
        this.executor.execute(wrappedCommand);
        return canceledOldJob;
    }

    protected Semaphore getSemaphore(String key) {
        if (!this.currentlyRunningSemaphores.containsKey(key)) {
            this.currentlyRunningSemaphores.put(key, new Semaphore(1));
        }
        return this.currentlyRunningSemaphores.get(key);
    }

    protected synchronized void cancelableStopping(CancelableRunnableWrapper wrappedCommand) {
        if (!wrappedCommand.isCanceled()) {
            this.currentlyRunningCancelableRunnables.remove(wrappedCommand.getKey());
            this.currentlyRunningSemaphores.remove(wrappedCommand.getKey());
        }
    }

    protected static class CancelableRunnableWrapper
    implements CancelableRunnable {
        private final ConstrainedExecutorImpl host;
        private final String key;
        private final Semaphore semaphore;
        private final CancelableRunnable runnable;
        private final CancelableSupport cancelableSupport;

        public CancelableRunnableWrapper(ConstrainedExecutorImpl host, String key, Semaphore semaphore, CancelableRunnable runnable) {
            this.host = (ConstrainedExecutorImpl)Preconditions.checkNotNull((Object)host);
            this.key = (String)Preconditions.checkNotNull((Object)key);
            this.semaphore = (Semaphore)Preconditions.checkNotNull((Object)semaphore);
            this.runnable = (CancelableRunnable)Preconditions.checkNotNull((Object)runnable);
            this.cancelableSupport = new CancelableSupport();
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public void run() {
            try {
                this.semaphore.acquire();
                if (this.isCanceled()) {
                    return;
                }
                try {
                    this.runnable.run();
                }
                finally {
                    this.host.cancelableStopping(this);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.semaphore.release();
            }
        }

        @Override
        public boolean isCanceled() {
            return this.cancelableSupport.isCanceled();
        }

        @Override
        public void cancel() {
            this.runnable.cancel();
            this.cancelableSupport.cancel();
        }
    }
}

