/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.sonatype.nexus.proxy.maven.routing.internal.task.ProgressListener;
import org.sonatype.nexus.proxy.maven.routing.internal.task.ProgressListenerUtil;
import org.sonatype.nexus.proxy.maven.routing.internal.task.ProgressListenerWrapper;
import org.sonatype.nexus.proxy.maven.routing.internal.task.RunnableCanceledException;
import org.sonatype.nexus.proxy.maven.routing.internal.task.RunnableInterruptedException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

public abstract class RunnableSupport
extends ComponentSupport
implements Runnable {
    private final ProgressListenerWrapper progressListenerWrapper;
    private final String name;

    protected RunnableSupport(ProgressListener progressListener, String name) {
        Preconditions.checkArgument((name != null && name.trim().length() > 0 ? 1 : 0) != 0);
        this.progressListenerWrapper = new ProgressListenerWrapper(progressListener);
        this.name = name;
    }

    protected String getName() {
        return this.name;
    }

    protected ProgressListener getProgressListener() {
        return this.progressListenerWrapper;
    }

    @Override
    public void run() {
        ProgressListener oldProgressListener = ProgressListenerUtil.getCurrentProgressListener();
        try {
            ProgressListenerUtil.setCurrentProgressListener(this.getProgressListener());
            this.log.debug("{} running...", (Object)this.getName());
            this.doRun();
            this.log.debug("{} done...", (Object)this.getName());
        }
        catch (InterruptedException | RunnableInterruptedException e) {
            this.log.info("{} interrupted: {}", (Object)this.getName(), (Object)e.getMessage());
        }
        catch (RunnableCanceledException e) {
            this.log.info("{} canceled: {}", (Object)this.getName(), (Object)e.getMessage());
        }
        catch (Exception e) {
            this.log.warn("{} failed:", (Object)this.getName(), (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            ProgressListenerUtil.setCurrentProgressListener(oldProgressListener);
        }
    }

    protected abstract void doRun() throws Exception;
}

