/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.task;

import com.google.common.base.Preconditions;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.maven.routing.internal.task.ProgressListener;

public class LoggingProgressListener
implements ProgressListener {
    private final Logger logger;
    private final Stack<TaskWork> tasksStack;

    public LoggingProgressListener(Class<?> clazz) {
        this(LoggerFactory.getLogger(clazz));
    }

    public LoggingProgressListener(Logger logger) {
        this.logger = logger;
        this.tasksStack = new Stack();
    }

    @Override
    public void beginTask(String name, int workAmount) {
        TaskWork tw = new TaskWork(name, workAmount);
        this.tasksStack.push(tw);
        this.logger.info("Begin task: {}, work to do {}.", (Object)tw.getName(), (Object)tw.getTotal());
    }

    @Override
    public void working(String message, int workAmountDelta) {
        TaskWork tw = this.safePeek();
        tw.addWorkAmountDelta(workAmountDelta);
        this.logger.info("Working: {}, done {} out of {}.", new Object[]{message, tw.getCurrent(), tw.getTotal()});
    }

    @Override
    public void endTask(String message) {
        TaskWork tw = this.safePeek();
        this.logger.info("End task: {}, done {} out of {}.", new Object[]{message, tw.getCurrent(), tw.getTotal()});
        this.tasksStack.pop();
    }

    protected TaskWork safePeek() {
        if (this.tasksStack.isEmpty()) {
            this.tasksStack.push(new TaskWork("Task", -1));
        }
        return this.tasksStack.peek();
    }

    private static final class TaskWork {
        private final String name;
        private int total;
        private int current;

        public TaskWork(String name, int total) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.total = total > -1 ? total : 0;
            this.current = 0;
        }

        public String getName() {
            return this.name;
        }

        public int getTotal() {
            return this.total;
        }

        public int getCurrent() {
            return this.current;
        }

        public void addWorkAmountDelta(int delta) {
            if (delta < 1) {
                return;
            }
            this.current += delta;
        }
    }
}

