/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.task;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.proxy.maven.routing.internal.task.Cancelable;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableSupport;
import org.sonatype.nexus.proxy.maven.routing.internal.task.RunnableCanceledException;
import org.sonatype.nexus.proxy.maven.routing.internal.task.RunnableInterruptedException;

public class CancelableUtil {
    private static final ThreadLocal<Cancelable> CURRENT = new ThreadLocal<Cancelable>(){

        @Override
        protected Cancelable initialValue() {
            return new CancelableSupport();
        }
    };

    private CancelableUtil() {
    }

    protected static void setCurrentCancelable(Cancelable cancelable) {
        if (cancelable == null) {
            CURRENT.set(new CancelableSupport());
        } else {
            CURRENT.set(cancelable);
        }
    }

    protected static Cancelable getCurrentCancelable() {
        return CURRENT.get();
    }

    protected static void checkInterruption(Cancelable c) throws RunnableCanceledException, RunnableInterruptedException {
        Cancelable cancelable = (Cancelable)Preconditions.checkNotNull((Object)c);
        Thread.yield();
        if (cancelable.isCanceled()) {
            throw new RunnableCanceledException("Thread \"" + Thread.currentThread().getName() + "\" is canceled!");
        }
        if (Thread.interrupted()) {
            throw new RunnableInterruptedException("Thread \"" + Thread.currentThread().getName() + "\" is interrupted!");
        }
    }

    public static void checkInterruption() throws RunnableCanceledException, RunnableInterruptedException {
        CancelableUtil.checkInterruption(CancelableUtil.getCurrentCancelable());
    }
}

