/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.task;

import org.sonatype.nexus.proxy.maven.routing.internal.task.Cancelable;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableRunnable;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableSupport;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableUtil;
import org.sonatype.nexus.proxy.maven.routing.internal.task.ProgressListener;
import org.sonatype.nexus.proxy.maven.routing.internal.task.RunnableCanceledException;
import org.sonatype.nexus.proxy.maven.routing.internal.task.RunnableInterruptedException;
import org.sonatype.nexus.proxy.maven.routing.internal.task.RunnableSupport;

public abstract class CancelableRunnableSupport
extends RunnableSupport
implements CancelableRunnable {
    private final CancelableSupport cancelableSupport = new CancelableSupport();

    protected CancelableRunnableSupport(ProgressListener progressListener, String name) {
        super(progressListener, name);
    }

    protected void checkInterruption() throws RunnableCanceledException, RunnableInterruptedException {
        CancelableUtil.checkInterruption(this.cancelableSupport);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelableSupport.isCanceled();
    }

    @Override
    public void cancel() {
        this.cancelableSupport.cancel();
    }

    @Override
    public void run() {
        if (this.isCanceled()) {
            this.log.debug("{} canceled before running, bailing out.", (Object)this.getName());
            return;
        }
        Cancelable oldCancelable = CancelableUtil.getCurrentCancelable();
        try {
            CancelableUtil.setCurrentCancelable(this.cancelableSupport);
            super.run();
        }
        finally {
            CancelableUtil.setCurrentCancelable(oldCancelable);
        }
    }
}

