/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.scrape;

import javax.inject.Named;
import javax.inject.Singleton;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractGeneratedIndexPageScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.ScrapeContext;

@Named(value="svn-index")
@Singleton
public class SvnIndexScraper
extends AbstractGeneratedIndexPageScraper {
    protected static final String ID = "svn-index";

    public SvnIndexScraper() {
        super(3000, ID);
    }

    @Override
    protected String getTargetedServer() {
        return "Subversion Index Page";
    }

    @Override
    protected Element getParentDirectoryElement(Page page) {
        Document doc = Jsoup.parseBodyFragment((String)"<a href=\"../\">..</a>", (String)page.getUrl());
        return doc.getElementsByTag("a").first();
    }

    @Override
    protected AbstractScraper.RemoteDetectionResult detectRemoteRepository(ScrapeContext context, Page page) {
        AbstractScraper.RemoteDetectionResult result = super.detectRemoteRepository(context, page);
        if (AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED == result.getRemoteDetectionOutcome()) {
            Elements elements = page.getDocument().getElementsByTag("a");
            for (Element element : elements) {
                String elementHref = element.absUrl("href");
                if (!"http://subversion.tigris.org/".equals(elementHref) && !"http://subversion.apache.org/".equals(elementHref)) continue;
                return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED, this.getTargetedServer(), "Should be scraped.");
            }
        }
        return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.UNRECOGNIZED, this.getTargetedServer(), "Remote is not a generated index page of " + this.getTargetedServer());
    }
}

