/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.scrape;

import com.google.common.base.Preconditions;
import org.apache.http.client.HttpClient;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.routing.PrefixSource;

public class ScrapeContext
extends Page.RepositoryPageContext {
    private final String remoteRepositoryRootUrl;
    private final int scrapeDepth;
    private boolean stopped;
    private PrefixSource prefixSource;
    private String message;

    public ScrapeContext(MavenProxyRepository remoteRepository, HttpClient httpClient, int scrapeDepth) {
        super(httpClient, remoteRepository);
        this.remoteRepositoryRootUrl = (String)Preconditions.checkNotNull((Object)remoteRepository.getRemoteUrl());
        this.scrapeDepth = (Integer)Preconditions.checkNotNull((Object)scrapeDepth);
        this.stopped = false;
    }

    public void stop(PrefixSource prefixSource, String message) {
        this.stopped = true;
        this.prefixSource = (PrefixSource)Preconditions.checkNotNull((Object)prefixSource);
        this.message = (String)Preconditions.checkNotNull((Object)message);
    }

    public void stop(String message) {
        this.stopped = true;
        this.prefixSource = null;
        this.message = (String)Preconditions.checkNotNull((Object)message);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isSuccessful() {
        return this.isStopped() && this.prefixSource != null;
    }

    public PrefixSource getPrefixSource() {
        return this.prefixSource;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRemoteRepositoryRootUrl() {
        return this.remoteRepositoryRootUrl;
    }

    public int getScrapeDepth() {
        return this.scrapeDepth;
    }

    @Override
    public MavenProxyRepository getProxyRepository() {
        return (MavenProxyRepository)super.getProxyRepository();
    }
}

