/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.scrape;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractGeneratedIndexPageScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.ScrapeContext;

@Named(value="nginx-index")
@Singleton
public class NginxIndexScraper
extends AbstractGeneratedIndexPageScraper {
    protected static final String ID = "nginx-index";

    public NginxIndexScraper() {
        super(5000, ID);
    }

    @Override
    protected String getTargetedServer() {
        return "Nginx Index Page";
    }

    @Override
    protected Element getParentDirectoryElement(Page page) {
        Document doc = Jsoup.parseBodyFragment((String)"<a href=\"../\">../</a>", (String)page.getUrl());
        return doc.getElementsByTag("a").first();
    }

    @Override
    protected AbstractScraper.RemoteDetectionResult detectRemoteRepository(ScrapeContext context, Page page) {
        Header serverHeader;
        AbstractScraper.RemoteDetectionResult result = super.detectRemoteRepository(context, page);
        if (AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED == result.getRemoteDetectionOutcome() && (serverHeader = page.getHttpResponse().getFirstHeader("Server")) != null && serverHeader.getValue() != null && serverHeader.getValue().startsWith("nginx/")) {
            return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED, this.getTargetedServer(), "Should be scraped.");
        }
        return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.UNRECOGNIZED, this.getTargetedServer(), "Remote is not a generated index page of " + this.getTargetedServer());
    }
}

