/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.scrape;

import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractGeneratedIndexPageScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.ScrapeContext;

@Named(value="nexus")
@Singleton
public class NexusScraper
extends AbstractGeneratedIndexPageScraper {
    protected static final String ID = "nexus";

    public NexusScraper() {
        super(1000, ID);
    }

    @Override
    protected String getTargetedServer() {
        return "Sonatype Nexus";
    }

    @Override
    protected Element getParentDirectoryElement(Page page) {
        Document doc = Jsoup.parseBodyFragment((String)"<a href=\"../\">Parent Directory</a>", (String)page.getUrl());
        return doc.getElementsByTag("a").first();
    }

    @Override
    protected AbstractScraper.RemoteDetectionResult detectRemoteRepository(ScrapeContext context, Page page) {
        AbstractScraper.RemoteDetectionResult result = super.detectRemoteRepository(context, page);
        if (AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED == result.getRemoteDetectionOutcome()) {
            try {
                Page repoMetadataPage = Page.getPageFor(context, context.getRemoteRepositoryRootUrl() + ".meta/repository-metadata.xml");
                if (page.getHttpResponse().getStatusLine().getStatusCode() == 200) {
                    Elements url = repoMetadataPage.getDocument().getElementsByTag("url");
                    Elements layout = repoMetadataPage.getDocument().getElementsByTag("layout");
                    Elements localUrl = repoMetadataPage.getDocument().getElementsByTag("localUrl");
                    Elements memberRepositories = repoMetadataPage.getDocument().getElementsByTag("memberRepositories");
                    if (!url.isEmpty() && !layout.isEmpty() && "maven2".equals(layout.get(0).text())) {
                        if (localUrl.isEmpty() && memberRepositories.isEmpty()) {
                            return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED, this.getTargetedServer(), "Remote is a hosted repository.");
                        }
                        if (!localUrl.isEmpty() && memberRepositories.isEmpty()) {
                            return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_NOT_BE_SCRAPED, this.getTargetedServer(), "Remote is a proxy repository.");
                        }
                        if (localUrl.isEmpty() && !memberRepositories.isEmpty()) {
                            return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_NOT_BE_SCRAPED, this.getTargetedServer(), "Remote is a group repository.");
                        }
                        return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_NOT_BE_SCRAPED, this.getTargetedServer(), "Remote is not a hosted repository.");
                    }
                    if (!(url.isEmpty() || layout.isEmpty() || "maven2".equals(layout.get(0).text()))) {
                        return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_NOT_BE_SCRAPED, this.getTargetedServer(), "Remote is not a Maven2 repository.");
                    }
                }
            }
            catch (IOException e) {
                this.log.debug("Problem during fetch of /.meta/repository-metadata.xml from remote of {}", (Object)context.getProxyRepository(), (Object)e);
            }
        }
        return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.UNRECOGNIZED, this.getTargetedServer(), "Remote is not a generated index page of " + this.getTargetedServer());
    }
}

