/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.scrape;

import javax.inject.Named;
import javax.inject.Singleton;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractGeneratedIndexPageScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.ScrapeContext;

@Named(value="httpd-index")
@Singleton
public class HttpdIndexScraper
extends AbstractGeneratedIndexPageScraper {
    protected static final String ID = "httpd-index";

    public HttpdIndexScraper() {
        super(2000, ID);
    }

    @Override
    protected String getTargetedServer() {
        return "Apache HTTPD Index Page";
    }

    @Override
    protected Element getParentDirectoryElement(Page page) {
        Document doc = Jsoup.parseBodyFragment((String)"<a href=\"../\">Parent Directory</a>", (String)page.getUrl());
        return doc.getElementsByTag("a").first();
    }

    @Override
    protected AbstractScraper.RemoteDetectionResult detectRemoteRepository(ScrapeContext context, Page page) {
        AbstractScraper.RemoteDetectionResult result = super.detectRemoteRepository(context, page);
        if (AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED == result.getRemoteDetectionOutcome()) {
            if (!page.hasHeaderAndStartsWith("Server", "Apache/")) {
                return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.UNRECOGNIZED, this.getTargetedServer(), "Remote is not a generated index page of " + this.getTargetedServer());
            }
            Elements addressElements = page.getDocument().getElementsByTag("address");
            if (!addressElements.isEmpty() && !addressElements.get(0).text().startsWith("Apache")) {
                return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.UNRECOGNIZED, this.getTargetedServer(), "Remote is not a generated index page of " + this.getTargetedServer());
            }
            return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED, this.getTargetedServer(), "Should be scraped.");
        }
        return result;
    }
}

