/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.scrape;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.ScrapeContext;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableUtil;
import org.sonatype.nexus.util.PathUtils;

@Named(value="amazons3-index")
@Singleton
public class AmazonS3IndexScraper
extends AbstractScraper {
    protected static final String ID = "amazons3-index";

    public AmazonS3IndexScraper() {
        super(4000, ID);
    }

    protected String getTargetedServer() {
        return "Amazon S3";
    }

    @Override
    protected AbstractScraper.RemoteDetectionResult detectRemoteRepository(ScrapeContext context, Page page) {
        if (page.hasHeaderAndEqualsWith("Server", "AmazonS3") && page.hasHeader("x-amz-request-id")) {
            if (this.isAccessDeniedResponse(page)) {
                return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_NOT_BE_SCRAPED, this.getTargetedServer(), "Bucket is not publicly accessible.");
            }
            return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED, this.getTargetedServer(), "Should be scraped.");
        }
        return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.UNRECOGNIZED, this.getTargetedServer(), "Remote is not " + this.getTargetedServer());
    }

    @Override
    protected List<String> diveIn(ScrapeContext context, Page page) throws IOException {
        String prefix = null;
        Page initialPage = page;
        String initialPageUrl = page.getUrl();
        if (initialPage.getHttpResponse().getStatusLine().getStatusCode() != 200) {
            prefix = this.getKeyFromNoSuchKeyResponse(initialPage);
            if (prefix == null) {
                this.log.info("Unexpected S3 response from remote of {}, cannot scrape this: {}", (Object)context.getProxyRepository(), (Object)initialPage.getDocument().outerHtml());
                context.stop("Remote recognized as " + this.getTargetedServer() + ", but unexpected response code and response body received (see logs).");
                return null;
            }
            initialPageUrl = context.getRemoteRepositoryRootUrl().substring(0, context.getRemoteRepositoryRootUrl().length() - prefix.length());
            this.log.debug("Retrying URL {} to scrape remote of {} on URL {}", new Object[]{initialPageUrl, context.getProxyRepository(), context.getRemoteRepositoryRootUrl()});
            initialPage = Page.getPageFor(context, initialPageUrl + "?prefix=" + prefix);
        }
        HashSet<String> entries = new HashSet<String>();
        this.diveIn(context, initialPage, initialPageUrl, prefix, entries);
        return new ArrayList<String>(entries);
    }

    protected void diveIn(ScrapeContext context, Page firstPage, String rootUrl, String prefix, Set<String> entries) throws IOException {
        boolean truncated;
        Page page = firstPage;
        do {
            truncated = this.isTruncated(page);
            CancelableUtil.checkInterruption();
            if (page.getHttpResponse().getStatusLine().getStatusCode() != 200) {
                context.stop("Remote recognized as " + this.getTargetedServer() + ", but cannot be scraped (unexpected response status " + page.getHttpResponse().getStatusLine() + ")");
                return;
            }
            Elements root = page.getDocument().getElementsByTag("ListBucketResult");
            if (root.size() != 1 || !root.get(0).attr("xmlns").equals("http://s3.amazonaws.com/doc/2006-03-01/")) {
                context.stop("Remote recognized as " + this.getTargetedServer() + ", but unexpected response was received (not \"ListBucketResult\").");
                return;
            }
            this.log.debug("Processing S3 page response from remote of {} got from URL {}", (Object)context.getProxyRepository(), (Object)page.getUrl());
            String markerElement = null;
            Elements elements = page.getDocument().getElementsByTag("Contents");
            for (Element element : elements) {
                long size;
                String key;
                Elements sizeElements;
                Elements keyElements = element.getElementsByTag("Key");
                if (keyElements.isEmpty() || (sizeElements = element.getElementsByTag("Size")).isEmpty() || (key = keyElements.get(0).text()).startsWith(".") || key.contains("/.") || (size = Long.parseLong(sizeElements.get(0).text())) <= 0L) continue;
                markerElement = key;
                String fixedKey = prefix != null ? key.substring(prefix.length()) : key;
                String normalizedPath = PathUtils.pathFrom(PathUtils.elementsOf(fixedKey), context.getScrapeDepth());
                entries.add(normalizedPath);
            }
            if (!truncated) continue;
            CancelableUtil.checkInterruption();
            ArrayList<String> queryParams = new ArrayList<String>();
            if (prefix != null) {
                queryParams.add("prefix=" + prefix);
            }
            if (markerElement != null) {
                queryParams.add("marker=" + markerElement);
            }
            String url = this.appendParameters(rootUrl, queryParams);
            page = Page.getPageFor(context, url);
        } while (truncated);
    }

    protected String appendParameters(String baseUrl, List<String> queryParams) {
        StringBuilder sb = new StringBuilder(baseUrl);
        boolean first = true;
        for (String queryParam : queryParams) {
            if (first) {
                sb.append("?");
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(queryParam);
        }
        return sb.toString();
    }

    protected boolean isAccessDeniedResponse(Page page) {
        return page.getHttpResponse().getStatusLine().getStatusCode() == 403;
    }

    protected String getKeyFromNoSuchKeyResponse(Page page) {
        if (page.getHttpResponse().getStatusLine().getStatusCode() == 404) {
            Elements keyNodes;
            Elements errorNodes = page.getDocument().getElementsByTag("Error");
            Elements codeNodes = errorNodes.isEmpty() ? new Elements() : errorNodes.get(0).getElementsByTag("Code");
            Elements elements = keyNodes = errorNodes.isEmpty() ? new Elements() : errorNodes.get(0).getElementsByTag("Key");
            if (errorNodes.size() == 1 && codeNodes.size() == 1 && "NoSuchKey".equals(codeNodes.get(0).text()) && keyNodes.size() == 1) {
                return keyNodes.get(0).text();
            }
        }
        return null;
    }

    protected boolean isTruncated(Page page) {
        Elements truncatedNodes;
        Elements root = page.getDocument().getElementsByTag("ListBucketResult");
        Elements elements = truncatedNodes = root.isEmpty() ? new Elements() : root.get(0).getElementsByTag("IsTruncated");
        return root.size() == 1 && truncatedNodes.size() == 1 && "true".equals(truncatedNodes.get(0).text());
    }
}

