/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.scrape;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.routing.internal.AbstractPrioritized;
import org.sonatype.nexus.proxy.maven.routing.internal.ArrayListPrefixSource;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.ScrapeContext;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.Scraper;
import org.sonatype.nexus.util.PathUtils;

public abstract class AbstractScraper
extends AbstractPrioritized
implements Scraper {
    private final String id;
    private static final UrlEncode URLENCODE = new UrlEncode();

    protected AbstractScraper(int priority, String id) {
        super(priority);
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void scrape(ScrapeContext context, Page page) {
        RemoteDetectionResult detectionResult = this.detectRemoteRepository(context, page);
        switch (detectionResult.getRemoteDetectionOutcome()) {
            case RECOGNIZED_SHOULD_BE_SCRAPED: {
                this.log.debug("Remote repository of {} on URL={} recognized as {}, scraping it...", new Object[]{context.getProxyRepository(), context.getRemoteRepositoryRootUrl(), detectionResult.getRemoteDetectedServer()});
                try {
                    List<String> entries = this.diveIn(context, page);
                    if (context.isStopped()) break;
                    if (entries != null) {
                        ArrayListPrefixSource prefixSource = new ArrayListPrefixSource(entries);
                        context.stop(prefixSource, "Remote recognized as " + detectionResult.getRemoteDetectedServer() + " (harvested " + String.valueOf(entries.size()) + " entries, " + context.getScrapeDepth() + " levels deep).");
                        break;
                    }
                    context.stop("Remote recognized as " + detectionResult.getRemoteDetectedServer() + ", but could not scrape it (see logs).");
                }
                catch (IOException e) {
                    this.log.debug("Remote repository of {} recognized as {}, but scrape failed: {}", new Object[]{context.getProxyRepository(), detectionResult.getRemoteDetectedServer(), e.toString()});
                    context.stop("Remote recognized as " + detectionResult.getRemoteDetectedServer() + ", but scrape failed:" + e.getMessage());
                }
                break;
            }
            case RECOGNIZED_SHOULD_NOT_BE_SCRAPED: {
                this.log.debug("Remote repository of {} on URL={} recognized as {}, but not scraping it: {}", new Object[]{context.getProxyRepository(), context.getRemoteRepositoryRootUrl(), detectionResult.getRemoteDetectedServer(), detectionResult.getMessage()});
                context.stop("Remote recognized as " + detectionResult.getRemoteDetectedServer() + ", but not scraping it: " + detectionResult.getMessage());
                break;
            }
            default: {
                this.log.debug("Remote repository of {} on URL={} not recognized as {}, skipping it.", new Object[]{context.getProxyRepository(), context.getRemoteRepositoryRootUrl(), detectionResult.getRemoteDetectedServer()});
            }
        }
    }

    protected abstract RemoteDetectionResult detectRemoteRepository(ScrapeContext var1, Page var2);

    protected abstract List<String> diveIn(ScrapeContext var1, Page var2) throws IOException;

    protected String getRemoteUrlForRepositoryPath(ScrapeContext context, List<String> pathElements) {
        String sp = PathUtils.pathFrom(pathElements, URLENCODE);
        while (sp.startsWith("/")) {
            sp = sp.substring(1);
        }
        return context.getRemoteRepositoryRootUrl() + sp;
    }

    private static final class UrlEncode
    implements Function<String, String> {
        private UrlEncode() {
        }

        public String apply(@Nullable String input) {
            try {
                return URLEncoder.encode(input, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("WAT?", e);
            }
        }
    }

    public static class RemoteDetectionResult {
        private final RemoteDetectionOutcome remoteDetectionOutcome;
        private final String remoteDetectedServer;
        private final String message;

        public RemoteDetectionResult(RemoteDetectionOutcome remoteDetectionOutcome, String remoteDetectedServer, String message) {
            this.remoteDetectionOutcome = (RemoteDetectionOutcome)((Object)Preconditions.checkNotNull((Object)((Object)remoteDetectionOutcome)));
            this.remoteDetectedServer = (String)Preconditions.checkNotNull((Object)remoteDetectedServer);
            this.message = (String)Preconditions.checkNotNull((Object)message);
        }

        public RemoteDetectionOutcome getRemoteDetectionOutcome() {
            return this.remoteDetectionOutcome;
        }

        public String getRemoteDetectedServer() {
            return this.remoteDetectedServer;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum RemoteDetectionOutcome {
        UNRECOGNIZED,
        RECOGNIZED_SHOULD_BE_SCRAPED,
        RECOGNIZED_SHOULD_NOT_BE_SCRAPED;

    }
}

