/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal.scrape;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.AbstractScraper;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.ScrapeContext;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.Scraper;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableUtil;
import org.sonatype.nexus.proxy.walker.ParentOMatic;
import org.sonatype.nexus.util.Node;
import org.sonatype.nexus.util.SystemPropertiesHelper;

public abstract class AbstractGeneratedIndexPageScraper
extends AbstractScraper {
    private long pageSleepTimeMillis = SystemPropertiesHelper.getLong(Scraper.class.getName() + ".pageSleepTimeMillis", 200L);

    protected AbstractGeneratedIndexPageScraper(int priority, String id) {
        super(priority, id);
    }

    protected abstract String getTargetedServer();

    @Override
    protected AbstractScraper.RemoteDetectionResult detectRemoteRepository(ScrapeContext context, Page page) {
        Elements elements;
        if (page.getHttpResponse().getStatusLine().getStatusCode() == 200 && !(elements = page.getDocument().getElementsByTag("a")).isEmpty()) {
            Element templateParentLink = this.getParentDirectoryElement(page);
            for (Element element : elements) {
                if (!templateParentLink.text().equals(element.text()) || !templateParentLink.absUrl("href").equals(element.absUrl("href"))) continue;
                return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.RECOGNIZED_SHOULD_BE_SCRAPED, this.getTargetedServer(), "Remote is a generated index page of " + this.getTargetedServer());
            }
        }
        return new AbstractScraper.RemoteDetectionResult(AbstractScraper.RemoteDetectionOutcome.UNRECOGNIZED, this.getTargetedServer(), "Remote is not a generated index page of " + this.getTargetedServer());
    }

    @Override
    protected List<String> diveIn(ScrapeContext context, Page page) throws IOException {
        ParentOMatic parentOMatic = new ParentOMatic();
        this.diveIn(context, page, 0, parentOMatic, parentOMatic.getRoot());
        if (parentOMatic.getRoot().isLeaf()) {
            context.stop("Remote recognized as " + this.getTargetedServer() + ", but scraped 0 entries. This is considered a failure.");
            return null;
        }
        List<String> entries = parentOMatic.getAllLeafPaths();
        return entries;
    }

    protected void diveIn(ScrapeContext context, Page page, int currentDepth, ParentOMatic parentOMatic, Node<ParentOMatic.Payload> currentNode) throws IOException {
        if (currentDepth >= context.getScrapeDepth()) {
            return;
        }
        CancelableUtil.checkInterruption();
        this.log.debug("Processing page response from URL {} for repository {}", (Object)page.getUrl(), (Object)context.getProxyRepository());
        Elements elements = page.getDocument().getElementsByTag("a");
        List<String> pathElements = currentNode.getPathElements();
        String currentPath = currentNode.getPath();
        for (Element element : elements) {
            int siblingDepth;
            if (!this.isDeeperRepoLink(context, pathElements, element) || element.text().startsWith(".")) continue;
            Node<ParentOMatic.Payload> newSibling = parentOMatic.addPath(currentPath + "/" + element.text());
            if (!element.absUrl("href").endsWith("/") || (siblingDepth = currentDepth + 1) >= context.getScrapeDepth()) continue;
            this.maySleepBeforeSubsequentFetch();
            String newSiblingEncodedUrl = this.getRemoteUrlForRepositoryPath(context, newSibling.getPathElements()) + "/";
            Page siblingPage = Page.getPageFor(context, newSiblingEncodedUrl);
            if (siblingPage.getHttpResponse().getStatusLine().getStatusCode() == 200) {
                this.diveIn(context, siblingPage, siblingDepth, parentOMatic, newSibling);
                continue;
            }
            throw new Page.UnexpectedPageResponse(page.getUrl(), page.getHttpResponse().getStatusLine());
        }
    }

    protected void maySleepBeforeSubsequentFetch() {
        if (this.pageSleepTimeMillis > 0L) {
            try {
                Thread.sleep(this.pageSleepTimeMillis);
            }
            catch (InterruptedException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    protected boolean isDeeperRepoLink(ScrapeContext context, List<String> pathElements, Element aTag) {
        if (aTag.attr("href").startsWith("?")) {
            return false;
        }
        String linkAbsoluteUrl = aTag.absUrl("href");
        String currentUrl = this.getRemoteUrlForRepositoryPath(context, pathElements);
        return linkAbsoluteUrl.startsWith(currentUrl);
    }

    protected abstract Element getParentDirectoryElement(Page var1);
}

