/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.nexus.proxy.maven.routing.WritablePrefixSource;
import org.sonatype.nexus.proxy.maven.routing.internal.ArrayListPrefixSource;
import org.sonatype.nexus.proxy.maven.routing.internal.PathMatcher;
import org.sonatype.nexus.util.PathUtils;

public class WritablePrefixSourceModifier {
    private final WritablePrefixSource writablePrefixSource;
    private final int maxDepth;
    private final List<String> toBeAdded;
    private final List<String> toBeRemoved;
    private List<String> prefixSourceEntries;
    private PathMatcher pathMatcher;

    public WritablePrefixSourceModifier(WritablePrefixSource writablePrefixSource, int maxDepth) throws IOException {
        Preconditions.checkArgument((maxDepth >= 2 ? 1 : 0) != 0);
        this.writablePrefixSource = (WritablePrefixSource)Preconditions.checkNotNull((Object)writablePrefixSource);
        this.maxDepth = maxDepth;
        this.toBeAdded = new ArrayList<String>();
        this.toBeRemoved = new ArrayList<String>();
        this.reset(writablePrefixSource.readEntries());
    }

    public boolean offerEntry(String entry) {
        boolean modified = false;
        String normalizedEntry = PathUtils.pathFrom(PathUtils.elementsOf(entry), this.maxDepth);
        if (!this.pathMatcher.matches(normalizedEntry) && !this.toBeAdded.contains(normalizedEntry)) {
            this.toBeAdded.add(normalizedEntry);
            modified = true;
        }
        return modified;
    }

    public boolean revokeEntry(String entry) {
        boolean modified = false;
        String normalizedEntry = PathUtils.pathFrom(PathUtils.elementsOf(entry));
        if (this.pathMatcher.contains(normalizedEntry) && !this.toBeRemoved.contains(normalizedEntry)) {
            for (String prefixEntry : this.prefixSourceEntries) {
                if (!prefixEntry.startsWith(normalizedEntry)) continue;
                this.toBeRemoved.add(prefixEntry);
                modified = true;
            }
        }
        return modified;
    }

    public boolean hasChanges() {
        return !this.toBeRemoved.isEmpty() || !this.toBeAdded.isEmpty();
    }

    public boolean apply() throws IOException {
        if (this.hasChanges()) {
            ArrayList<String> entries = new ArrayList<String>(this.writablePrefixSource.readEntries());
            entries.removeAll(this.toBeRemoved);
            entries.addAll(this.toBeAdded);
            ArrayListPrefixSource newEntries = new ArrayListPrefixSource(entries);
            this.writablePrefixSource.writeEntries(newEntries);
            this.reset(newEntries.readEntries());
            return true;
        }
        return false;
    }

    public boolean reset() throws IOException {
        if (this.hasChanges()) {
            this.reset(this.writablePrefixSource.readEntries());
            return true;
        }
        return false;
    }

    protected void reset(List<String> entries) {
        this.toBeAdded.clear();
        this.toBeRemoved.clear();
        this.prefixSourceEntries = entries;
        this.pathMatcher = new PathMatcher(entries);
    }
}

