/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.routing.internal.ManagerImpl;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableRunnableSupport;
import org.sonatype.nexus.proxy.maven.routing.internal.task.ProgressListener;

public class UpdateRepositoryRunnable
extends CancelableRunnableSupport {
    private final ApplicationStatusSource applicationStatusSource;
    private final ManagerImpl manager;
    private final MavenRepository mavenRepository;

    public UpdateRepositoryRunnable(ProgressListener progressListener, ApplicationStatusSource applicationStatusSource, ManagerImpl manager, MavenRepository mavenRepository) {
        super(progressListener, mavenRepository.getId() + " AR-Updater");
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.manager = (ManagerImpl)Preconditions.checkNotNull((Object)manager);
        this.mavenRepository = (MavenRepository)Preconditions.checkNotNull((Object)mavenRepository);
    }

    @Override
    protected void doRun() {
        if (!this.applicationStatusSource.getSystemStatus().isNexusStarted()) {
            this.log.warn("Nexus stopped during background prefix file updates for {}, bailing out.", (Object)this.mavenRepository);
            return;
        }
        try {
            this.manager.updateAndPublishPrefixFile(this.mavenRepository);
        }
        catch (Exception e) {
            try {
                this.manager.unpublish(this.mavenRepository);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Throwables.propagate((Throwable)e);
        }
    }
}

