/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.maven.routing.Config;
import org.sonatype.nexus.proxy.maven.routing.internal.InvalidInputException;
import org.sonatype.nexus.util.PathUtils;

public class TextFilePrefixSourceMarshaller {
    public static final String MAGIC = "## repository-prefixes/2.0";
    protected static final String LEGACY_MAGIC = "# Prefix file generated by Sonatype Nexus";
    protected static final String[] HEADERS = new String[]{"#", "# Prefix file generated by Sonatype Nexus", "# Do not edit, changes will be overwritten!"};
    protected static final Charset CHARSET = Charset.forName("UTF-8");
    protected static final String UNSUPPORTED = "@ unsupported";
    private final int prefixFileMaxSize;
    private final int prefixFileMaxLineLength;
    private final int prefixFileMaxEntryCount;
    private static final Result RESULT_UNSUPPORTED = new Result(){

        @Override
        public boolean supported() {
            return false;
        }

        @Override
        public List<String> entries() {
            return Collections.emptyList();
        }
    };

    public TextFilePrefixSourceMarshaller(Config config) {
        Preconditions.checkArgument((config.getPrefixFileMaxSize() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((config.getPrefixFileMaxLineLength() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((config.getPrefixFileMaxEntriesCount() > 0 ? 1 : 0) != 0);
        this.prefixFileMaxSize = config.getPrefixFileMaxSize();
        this.prefixFileMaxLineLength = config.getPrefixFileMaxLineLength();
        this.prefixFileMaxEntryCount = config.getPrefixFileMaxEntriesCount();
    }

    public void write(List<String> entries, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, CHARSET));
        printWriter.println(MAGIC);
        for (String header : HEADERS) {
            printWriter.println(header);
        }
        for (String entry : entries) {
            printWriter.println(entry);
        }
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Result read(StorageFileItem file) throws InvalidInputException, IOException {
        if (file.getLength() > (long)this.prefixFileMaxSize) {
            throw new InvalidInputException("Prefix file size exceeds maximum allowed size (" + this.prefixFileMaxSize + "), refusing to load it.");
        }
        try (Closer closer = Closer.create();){
            BufferedReader reader = (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader(file.getInputStream(), CHARSET)));
            final ArrayList<String> entries = new ArrayList<String>();
            String line = reader.readLine();
            if (!(MAGIC.equals(line) || LEGACY_MAGIC.equals(line) || UNSUPPORTED.equals(line))) {
                throw new InvalidInputException("Prefix file does not start with expected \"## repository-prefixes/2.0\" header, refusing to load the file.");
            }
            while (line != null) {
                if (UNSUPPORTED.equals(line)) {
                    Result result = RESULT_UNSUPPORTED;
                    return result;
                }
                if (!(line = line.trim()).startsWith("#") && line.length() > 0) {
                    if (line.length() > this.prefixFileMaxLineLength) {
                        throw new InvalidInputException("Prefix file contains line longer than allowed (" + this.prefixFileMaxLineLength + " characters), refusing to load the file.");
                    }
                    if (!CharMatcher.ASCII.matchesAllOf((CharSequence)line)) {
                        throw new InvalidInputException("Prefix file contains non-ASCII characters, refusing to load the file.");
                    }
                    if (line.contains(":") || line.contains("<") || line.contains(">")) {
                        throw new InvalidInputException("Prefix file contains forbidden characters (colon, less or greater signs), refusing to load the file.");
                    }
                    while (line.startsWith(".")) {
                        line = line.substring(1);
                    }
                    line = line.replace('\\', '/');
                    entries.add(PathUtils.pathFrom(PathUtils.elementsOf(line)));
                }
                line = reader.readLine();
                if (entries.size() <= this.prefixFileMaxEntryCount) continue;
                throw new InvalidInputException("Prefix file entry count exceeds maximum allowed count (" + this.prefixFileMaxEntryCount + "), refusing to load it.");
            }
            Result result = new Result(){

                @Override
                public boolean supported() {
                    return true;
                }

                @Override
                public List<String> entries() {
                    return entries;
                }
            };
            return result;
        }
    }

    public void writeUnsupported(ByteArrayOutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, CHARSET));
        printWriter.println(MAGIC);
        for (String header : HEADERS) {
            printWriter.println(header);
        }
        printWriter.println(UNSUPPORTED);
        printWriter.flush();
    }

    public static interface Result {
        public boolean supported();

        public List<String> entries();
    }
}

