/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.client.HttpClient;
import org.sonatype.nexus.apachehttpclient.page.Page;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.routing.Config;
import org.sonatype.nexus.proxy.maven.routing.discovery.Prioritized;
import org.sonatype.nexus.proxy.maven.routing.discovery.RemoteStrategy;
import org.sonatype.nexus.proxy.maven.routing.discovery.StrategyFailedException;
import org.sonatype.nexus.proxy.maven.routing.discovery.StrategyResult;
import org.sonatype.nexus.proxy.maven.routing.internal.AbstractHttpRemoteStrategy;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.ScrapeContext;
import org.sonatype.nexus.proxy.maven.routing.internal.scrape.Scraper;
import org.sonatype.nexus.proxy.storage.remote.httpclient.HttpClientManager;

@Named(value="scrape")
@Singleton
public class RemoteScrapeStrategy
extends AbstractHttpRemoteStrategy
implements RemoteStrategy {
    protected static final String ID = "scrape";
    private final Config config;
    private final List<Scraper> scrapers;

    @Inject
    public RemoteScrapeStrategy(Config config, HttpClientManager httpClientManager, List<Scraper> scrapers) {
        super(Integer.MAX_VALUE, ID, httpClientManager);
        this.config = (Config)Preconditions.checkNotNull((Object)config);
        this.scrapers = (List)Preconditions.checkNotNull(scrapers);
    }

    @Override
    public StrategyResult doDiscover(MavenProxyRepository mavenProxyRepository) throws StrategyFailedException, IOException {
        String remoteRepositoryRootUrl;
        this.log.debug("Remote scrape on {} tried", (Object)mavenProxyRepository);
        try {
            remoteRepositoryRootUrl = this.getRemoteUrlOf(mavenProxyRepository);
        }
        catch (MalformedURLException e) {
            throw new StrategyFailedException("Proxy repository " + mavenProxyRepository + " remote URL malformed:" + e.getMessage(), e);
        }
        HttpClient httpClient = this.createHttpClientFor(mavenProxyRepository);
        ScrapeContext context = new ScrapeContext(mavenProxyRepository, httpClient, this.config.getRemoteScrapeDepth());
        Page rootPage = Page.getPageFor(context, remoteRepositoryRootUrl);
        ArrayList<Scraper> appliedScrapers = new ArrayList<Scraper>(this.scrapers);
        Collections.sort(appliedScrapers, new Prioritized.PriorityOrderingComparator());
        for (Scraper scraper : appliedScrapers) {
            this.log.debug("Remote scraping {} with Scraper {}", (Object)mavenProxyRepository, (Object)scraper.getId());
            scraper.scrape(context, rootPage);
            if (context.isStopped()) {
                if (context.isSuccessful()) {
                    this.log.debug("Remote scraping {} with Scraper {} succeeded.", (Object)mavenProxyRepository, (Object)scraper.getId());
                    return new StrategyResult(context.getMessage(), context.getPrefixSource(), true);
                }
                this.log.debug("Remote scraping {} with Scraper {} stopped execution.", (Object)mavenProxyRepository, (Object)scraper.getId());
                throw new StrategyFailedException(context.getMessage());
            }
            this.log.debug("Remote scraping {} with Scraper {} skipped.", (Object)mavenProxyRepository, (Object)scraper.getId());
        }
        this.log.info("Not possible remote scrape of {}, no scraper succeeded.", (Object)mavenProxyRepository);
        throw new StrategyFailedException("No scraper was able to scrape remote (or remote prevents scraping).");
    }
}

