/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.ChecksumPolicy;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.routing.Config;
import org.sonatype.nexus.proxy.maven.routing.Manager;
import org.sonatype.nexus.proxy.maven.routing.PrefixSource;
import org.sonatype.nexus.proxy.maven.routing.discovery.RemoteStrategy;
import org.sonatype.nexus.proxy.maven.routing.discovery.StrategyFailedException;
import org.sonatype.nexus.proxy.maven.routing.discovery.StrategyResult;
import org.sonatype.nexus.proxy.maven.routing.internal.AbstractHttpRemoteStrategy;
import org.sonatype.nexus.proxy.maven.routing.internal.FilePrefixSource;
import org.sonatype.nexus.proxy.maven.routing.internal.TextFilePrefixSourceMarshaller;
import org.sonatype.nexus.proxy.storage.remote.httpclient.HttpClientManager;

@Named(value="prefix-file")
@Singleton
public class RemotePrefixFileStrategy
extends AbstractHttpRemoteStrategy
implements RemoteStrategy {
    private static final PrefixSource UNSUPPORTED_PREFIXSOURCE = new PrefixSource(){

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean supported() {
            return false;
        }

        @Override
        public List<String> readEntries() throws IOException {
            return Collections.emptyList();
        }

        @Override
        public long getLostModifiedTimestamp() {
            return 0L;
        }
    };
    protected static final String ID = "prefix-file";
    private final Config config;

    @Inject
    public RemotePrefixFileStrategy(Config config, HttpClientManager httpClientManager) {
        super(100, ID, httpClientManager);
        this.config = (Config)Preconditions.checkNotNull((Object)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StrategyResult doDiscover(MavenProxyRepository mavenProxyRepository) throws StrategyFailedException, IOException {
        String path = this.config.getRemotePrefixFilePath();
        this.log.debug("Looking for remote prefix on {} at path {}", (Object)mavenProxyRepository, (Object)path);
        RepositoryItemUid uid = mavenProxyRepository.createUid(path);
        uid.getLock().lock(Action.update);
        try {
            StorageFileItem item = this.retrieveFromRemoteIfExists(mavenProxyRepository, path);
            if (item != null) {
                this.log.debug("Remote prefix on {} at path {} found!", (Object)mavenProxyRepository, (Object)path);
                long prefixFileAgeInDays = (System.currentTimeMillis() - item.getModified()) / 86400000L;
                TextFilePrefixSourceMarshaller.Result unmarshalled = new TextFilePrefixSourceMarshaller(this.config).read(item);
                if (!unmarshalled.supported()) {
                    StrategyResult strategyResult = new StrategyResult("Remote disabled automatic routing", UNSUPPORTED_PREFIXSOURCE, false);
                    return strategyResult;
                }
                if (unmarshalled.entries().isEmpty()) {
                    StrategyResult strategyResult = new StrategyResult("Remote publishes empty prefix file", UNSUPPORTED_PREFIXSOURCE, false);
                    return strategyResult;
                }
                FilePrefixSource prefixSource = new FilePrefixSource(mavenProxyRepository, path, this.config);
                if (prefixFileAgeInDays < 1L) {
                    StrategyResult strategyResult = new StrategyResult("Remote publishes prefix file (is less than a day old), using it.", prefixSource, true);
                    return strategyResult;
                }
                StrategyResult strategyResult = new StrategyResult("Remote publishes prefix file (is " + prefixFileAgeInDays + " days old), using it.", prefixSource, true);
                return strategyResult;
            }
        }
        finally {
            uid.getLock().unlock();
        }
        throw new StrategyFailedException("Remote does not publish prefix files on path " + path);
    }

    protected StorageFileItem retrieveFromRemoteIfExists(MavenProxyRepository mavenProxyRepository, String path) throws IOException {
        ResourceStoreRequest request = new ResourceStoreRequest(path);
        request.setRequestRemoteOnly(true);
        request.getRequestContext().put(Manager.ROUTING_INITIATED_FILE_OPERATION_FLAG_KEY, (Object)Boolean.TRUE);
        request.getRequestContext().put(ChecksumPolicy.REQUEST_CHECKSUM_POLICY_KEY, (Object)ChecksumPolicy.IGNORE);
        boolean presentRemotely = mavenProxyRepository.getRemoteStorage().containsItem(mavenProxyRepository, request);
        if (!presentRemotely) {
            return null;
        }
        mavenProxyRepository.removeFromNotFoundCache(request);
        try {
            StorageItem item = mavenProxyRepository.retrieveItem(true, request);
            if (item instanceof StorageFileItem) {
                return (StorageFileItem)item;
            }
            return null;
        }
        catch (IllegalOperationException e) {
            return null;
        }
        catch (ItemNotFoundException e) {
            mavenProxyRepository.removeFromNotFoundCache(request);
            return null;
        }
    }
}

