/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.routing.discovery.DiscoveryResult;
import org.sonatype.nexus.proxy.maven.routing.discovery.Prioritized;
import org.sonatype.nexus.proxy.maven.routing.discovery.RemoteContentDiscoverer;
import org.sonatype.nexus.proxy.maven.routing.discovery.RemoteStrategy;
import org.sonatype.nexus.proxy.maven.routing.discovery.StrategyFailedException;
import org.sonatype.nexus.proxy.maven.routing.discovery.StrategyResult;
import org.sonatype.nexus.proxy.maven.routing.internal.InvalidInputException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class RemoteContentDiscovererImpl
extends ComponentSupport
implements RemoteContentDiscoverer {
    private final List<RemoteStrategy> remoteStrategies;

    @Inject
    public RemoteContentDiscovererImpl(List<RemoteStrategy> remoteStrategies) {
        this.remoteStrategies = (List)Preconditions.checkNotNull(remoteStrategies);
    }

    @Override
    public DiscoveryResult<MavenProxyRepository> discoverRemoteContent(MavenProxyRepository mavenProxyRepository) {
        ArrayList<RemoteStrategy> appliedStrategies = new ArrayList<RemoteStrategy>(this.remoteStrategies);
        Collections.sort(appliedStrategies, new Prioritized.PriorityOrderingComparator());
        return this.discoverRemoteContent(mavenProxyRepository, appliedStrategies);
    }

    @Override
    public DiscoveryResult<MavenProxyRepository> discoverRemoteContent(MavenProxyRepository mavenProxyRepository, List<RemoteStrategy> remoteStrategies) {
        DiscoveryResult<MavenProxyRepository> discoveryResult = new DiscoveryResult<MavenProxyRepository>(mavenProxyRepository);
        for (RemoteStrategy strategy : remoteStrategies) {
            block9: {
                this.log.debug("Discovery of {} with strategy {} attempted", (Object)mavenProxyRepository, (Object)strategy.getId());
                try {
                    StrategyResult strategyResult = strategy.discover(mavenProxyRepository);
                    if (strategyResult.isRoutingEnabled()) {
                        discoveryResult.recordSuccess(strategy.getId(), strategyResult.getMessage(), strategyResult.getPrefixSource());
                        break block9;
                    }
                    discoveryResult.recordFailure(strategy.getId(), strategyResult.getMessage());
                    break;
                }
                catch (StrategyFailedException e) {
                    discoveryResult.recordFailure(strategy.getId(), e.getMessage());
                }
                catch (InvalidInputException e) {
                    String message = "Remote strategy " + strategy.getId() + " on " + mavenProxyRepository + " detected invalid input, results discarded: " + e.getMessage();
                    this.log.info(message);
                    discoveryResult.recordFailure(strategy.getId(), message);
                    break;
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.warn("Remote strategy {} error on {}", new Object[]{strategy.getId(), mavenProxyRepository, e});
                    } else {
                        this.log.warn("Remote strategy {} error on {}: {}", new Object[]{strategy.getId(), mavenProxyRepository, e.toString()});
                    }
                    discoveryResult.recordError(strategy.getId(), e);
                    break;
                }
            }
            if (discoveryResult.isSuccessful()) {
                this.log.debug("Discovery of {} with strategy {} successful", (Object)mavenProxyRepository, (Object)strategy.getId());
                break;
            }
            this.log.debug("Discovery of {} with strategy {} unsuccessful", (Object)mavenProxyRepository, (Object)strategy.getId());
        }
        return discoveryResult;
    }
}

