/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.routing.Manager;
import org.sonatype.nexus.proxy.maven.routing.PrefixSource;
import org.sonatype.nexus.proxy.maven.routing.ProxyRequestFilter;
import org.sonatype.nexus.proxy.maven.routing.events.PrefixFilePublishedRepositoryEvent;
import org.sonatype.nexus.proxy.maven.routing.events.PrefixFileUnpublishedRepositoryEvent;
import org.sonatype.nexus.proxy.maven.routing.internal.PathMatcher;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class ProxyRequestFilterImpl
extends ComponentSupport
implements ProxyRequestFilter {
    private final ApplicationStatusSource applicationStatusSource;
    private final Manager manager;
    private final ConcurrentHashMap<String, PathMatcher> pathMatchers = new ConcurrentHashMap();

    @Inject
    public ProxyRequestFilterImpl(EventBus eventBus, ApplicationStatusSource applicationStatusSource, Manager manager) {
        Preconditions.checkNotNull((Object)eventBus);
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.manager = (Manager)Preconditions.checkNotNull((Object)manager);
        eventBus.register((Object)this);
    }

    @Override
    public boolean allowed(MavenProxyRepository mavenProxyRepository, ResourceStoreRequest resourceStoreRequest) {
        PathMatcher pathMatcher = this.getPathMatcherFor(mavenProxyRepository);
        if (pathMatcher != null) {
            boolean allowed = pathMatcher.matches(resourceStoreRequest.getRequestPath());
            if (!allowed) {
                resourceStoreRequest.getRequestContext().put(Manager.ROUTING_REQUEST_REJECTED_FLAG_KEY, (Object)Boolean.TRUE);
            }
            return allowed;
        }
        return true;
    }

    protected PathMatcher getPathMatcherFor(MavenProxyRepository mavenProxyRepository) {
        return this.pathMatchers.get(mavenProxyRepository.getId());
    }

    protected boolean dropPathMatcherFor(MavenProxyRepository mavenProxyRepository) {
        return this.pathMatchers.remove(mavenProxyRepository.getId()) != null;
    }

    protected void buildPathMatcherFor(MavenProxyRepository mavenProxyRepository) {
        try {
            PrefixSource prefixSource = this.manager.getPrefixSourceFor(mavenProxyRepository);
            if (prefixSource.supported()) {
                PathMatcher pathMatcher = new PathMatcher(prefixSource.readEntries(), Integer.MAX_VALUE);
                this.pathMatchers.put(mavenProxyRepository.getId(), pathMatcher);
            } else {
                this.dropPathMatcherFor(mavenProxyRepository);
            }
        }
        catch (IOException e) {
            this.log.warn("Could not build PathMatcher for {}!", (Object)mavenProxyRepository, (Object)e);
            this.dropPathMatcherFor(mavenProxyRepository);
        }
    }

    protected boolean isRepositoryHandled(Repository repository) {
        return this.applicationStatusSource.getSystemStatus().isNexusStarted() && repository != null && repository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class);
    }

    @Subscribe
    public void onPrefixFilePublishedRepositoryEvent(PrefixFilePublishedRepositoryEvent evt) {
        MavenProxyRepository mavenProxyRepository = evt.getRepository().adaptToFacet(MavenProxyRepository.class);
        if (this.isRepositoryHandled(mavenProxyRepository)) {
            this.buildPathMatcherFor(mavenProxyRepository);
        }
    }

    @Subscribe
    public void onPrefixFileUnpublishedRepositoryEvent(PrefixFileUnpublishedRepositoryEvent evt) {
        MavenProxyRepository mavenProxyRepository = evt.getRepository().adaptToFacet(MavenProxyRepository.class);
        if (this.isRepositoryHandled(mavenProxyRepository)) {
            this.dropPathMatcherFor(mavenProxyRepository);
        }
    }
}

