/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.ByteArrayContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.routing.DiscoveryStatus;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;

public class PropfileDiscoveryStatusSource {
    private static final String DISCOVERY_STATUS_FILE_PATH = "/.meta/discovery-status.txt";
    private static final String LAST_DISCOVERY_STATUS_KEY = "lastDiscoveryStatus";
    private static final String LAST_DISCOVERY_STRATEGY_KEY = "lastDiscoveryStrategy";
    private static final String LAST_DISCOVERY_MESSAGE_KEY = "lastDiscoveryMessage";
    private static final String LAST_DISCOVERY_TIMESTAMP_KEY = "lastDiscoveryTimestamp";
    private final MavenProxyRepository mavenProxyRepository;

    public PropfileDiscoveryStatusSource(MavenProxyRepository mavenProxyRepository) {
        this.mavenProxyRepository = (MavenProxyRepository)Preconditions.checkNotNull((Object)mavenProxyRepository);
    }

    public boolean exists() {
        try {
            return this.getFileItem() != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DiscoveryStatus read() throws IOException {
        StorageFileItem file = this.getFileItem();
        if (file == null) {
            return null;
        }
        Properties props = new Properties();
        try (InputStream inputStream = file.getInputStream();){
            props.load(inputStream);
            DiscoveryStatus.DStatus lastDiscoveryStatus = DiscoveryStatus.DStatus.valueOf(props.getProperty(LAST_DISCOVERY_STATUS_KEY));
            String lastDiscoveryStrategy = props.getProperty(LAST_DISCOVERY_STRATEGY_KEY, "unknown");
            String lastDiscoveryMessage = props.getProperty(LAST_DISCOVERY_MESSAGE_KEY, "");
            long lastDiscoveryTimestamp = Long.parseLong(props.getProperty(LAST_DISCOVERY_TIMESTAMP_KEY, Long.toString(-1L)));
            DiscoveryStatus discoveryStatus = new DiscoveryStatus(lastDiscoveryStatus, lastDiscoveryStrategy, lastDiscoveryMessage, lastDiscoveryTimestamp);
            return discoveryStatus;
        }
        catch (IllegalArgumentException e) {
            this.deleteFileItem();
            return null;
        }
        catch (NullPointerException e) {
            this.deleteFileItem();
            return null;
        }
    }

    public void write(DiscoveryStatus discoveryStatus) throws IOException {
        Preconditions.checkNotNull((Object)discoveryStatus);
        Properties props = new Properties();
        props.put(LAST_DISCOVERY_STATUS_KEY, discoveryStatus.getStatus().name());
        props.put(LAST_DISCOVERY_STRATEGY_KEY, discoveryStatus.getLastDiscoveryStrategy());
        props.put(LAST_DISCOVERY_MESSAGE_KEY, discoveryStatus.getLastDiscoveryMessage());
        props.put(LAST_DISCOVERY_TIMESTAMP_KEY, Long.toString(discoveryStatus.getLastDiscoveryTimestamp()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        props.store(bos, "Nexus discovery status");
        this.putFileItem(new ByteArrayContentLocator(bos.toByteArray(), "text/plain"));
    }

    public void delete() throws IOException {
        this.deleteFileItem();
    }

    protected MavenProxyRepository getMavenProxyRepository() {
        return this.mavenProxyRepository;
    }

    protected StorageFileItem getFileItem() throws IOException {
        try {
            ResourceStoreRequest request = new ResourceStoreRequest(DISCOVERY_STATUS_FILE_PATH);
            request.setRequestLocalOnly(true);
            request.setRequestGroupLocalOnly(true);
            StorageItem item = this.getMavenProxyRepository().retrieveItem(true, request);
            if (item instanceof StorageFileItem) {
                return (StorageFileItem)item;
            }
            return null;
        }
        catch (IllegalOperationException e) {
            return null;
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    protected void putFileItem(ContentLocator content) throws IOException {
        ResourceStoreRequest request = new ResourceStoreRequest(DISCOVERY_STATUS_FILE_PATH);
        request.setRequestLocalOnly(true);
        request.setRequestGroupLocalOnly(true);
        DefaultStorageFileItem file = new DefaultStorageFileItem(this.getMavenProxyRepository(), request, true, true, content);
        try {
            this.getMavenProxyRepository().storeItem(true, file);
        }
        catch (UnsupportedStorageOperationException unsupportedStorageOperationException) {
        }
        catch (IllegalOperationException illegalOperationException) {
            // empty catch block
        }
    }

    protected void deleteFileItem() throws IOException {
        ResourceStoreRequest request = new ResourceStoreRequest(DISCOVERY_STATUS_FILE_PATH);
        request.setRequestLocalOnly(true);
        request.setRequestGroupLocalOnly(true);
        try {
            this.getMavenProxyRepository().deleteItemWithChecksums(true, request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (UnsupportedStorageOperationException unsupportedStorageOperationException) {
        }
        catch (IllegalOperationException illegalOperationException) {
            // empty catch block
        }
    }
}

