/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.sonatype.nexus.proxy.walker.ParentOMatic;
import org.sonatype.nexus.util.Node;
import org.sonatype.nexus.util.PathUtils;

public class PathMatcher {
    private final Node<ParentOMatic.Payload> root;

    public PathMatcher(List<String> entries) {
        this(entries, Integer.MAX_VALUE);
    }

    public PathMatcher(List<String> entries, int maxDepth) {
        Preconditions.checkArgument((maxDepth >= 2 ? 1 : 0) != 0);
        this.root = this.buildRoot((List)Preconditions.checkNotNull(entries), maxDepth);
    }

    public boolean matches(String path) {
        String pathElement;
        List<String> pathElements = PathUtils.elementsOf(path);
        Node<ParentOMatic.Payload> currentNode = this.root;
        Iterator<String> iterator = pathElements.iterator();
        while (iterator.hasNext() && (currentNode = currentNode.getChildByLabel(pathElement = iterator.next())) != null && !currentNode.isLeaf()) {
        }
        return currentNode != null && currentNode.isLeaf();
    }

    public boolean contains(String path) {
        String pathElement;
        List<String> pathElements = PathUtils.elementsOf(path);
        Node<ParentOMatic.Payload> currentNode = this.root;
        Iterator<String> iterator = pathElements.iterator();
        while (iterator.hasNext() && (currentNode = currentNode.getChildByLabel(pathElement = iterator.next())) != null && !currentNode.isLeaf()) {
        }
        return currentNode != null;
    }

    protected Node<ParentOMatic.Payload> buildRoot(List<String> entries, int maxDepth) {
        ParentOMatic parentOMatic = new ParentOMatic(true, true, false);
        for (String entry : entries) {
            parentOMatic.addAndMarkPath(entry);
        }
        if (maxDepth != Integer.MAX_VALUE) {
            parentOMatic.cutNodesDeeperThan(maxDepth);
        }
        return parentOMatic.getRoot();
    }
}

