/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.events.NexusStartedEvent;
import org.sonatype.nexus.proxy.events.NexusStoppedEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemEvent;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.AbstractMavenRepository;
import org.sonatype.nexus.proxy.maven.AbstractMavenRepositoryConfiguration;
import org.sonatype.nexus.proxy.maven.MavenGroupRepository;
import org.sonatype.nexus.proxy.maven.MavenHostedRepository;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.MavenShadowRepository;
import org.sonatype.nexus.proxy.maven.routing.Config;
import org.sonatype.nexus.proxy.maven.routing.DiscoveryConfig;
import org.sonatype.nexus.proxy.maven.routing.DiscoveryStatus;
import org.sonatype.nexus.proxy.maven.routing.Manager;
import org.sonatype.nexus.proxy.maven.routing.PrefixSource;
import org.sonatype.nexus.proxy.maven.routing.PublishingStatus;
import org.sonatype.nexus.proxy.maven.routing.RoutingStatus;
import org.sonatype.nexus.proxy.maven.routing.discovery.DiscoveryResult;
import org.sonatype.nexus.proxy.maven.routing.discovery.LocalContentDiscoverer;
import org.sonatype.nexus.proxy.maven.routing.discovery.RemoteContentDiscoverer;
import org.sonatype.nexus.proxy.maven.routing.discovery.RemoteStrategy;
import org.sonatype.nexus.proxy.maven.routing.events.PrefixFilePublishedRepositoryEvent;
import org.sonatype.nexus.proxy.maven.routing.events.PrefixFileUnpublishedRepositoryEvent;
import org.sonatype.nexus.proxy.maven.routing.internal.ArrayListPrefixSource;
import org.sonatype.nexus.proxy.maven.routing.internal.EventDispatcher;
import org.sonatype.nexus.proxy.maven.routing.internal.FilePrefixSource;
import org.sonatype.nexus.proxy.maven.routing.internal.InvalidInputException;
import org.sonatype.nexus.proxy.maven.routing.internal.PropfileDiscoveryStatusSource;
import org.sonatype.nexus.proxy.maven.routing.internal.UpdateRepositoryRunnable;
import org.sonatype.nexus.proxy.maven.routing.internal.WritablePrefixSourceModifier;
import org.sonatype.nexus.proxy.maven.routing.internal.task.LoggingProgressListener;
import org.sonatype.nexus.proxy.maven.routing.internal.task.executor.ConstrainedExecutor;
import org.sonatype.nexus.proxy.maven.routing.internal.task.executor.ConstrainedExecutorImpl;
import org.sonatype.nexus.proxy.maven.routing.internal.task.executor.Statistics;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.ProxyMode;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.threads.FakeAlmightySubject;
import org.sonatype.nexus.threads.NexusScheduledExecutorService;
import org.sonatype.nexus.threads.NexusThreadFactory;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.common.SimpleFormat;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class ManagerImpl
extends ComponentSupport
implements Manager {
    private final EventBus eventBus;
    private final ApplicationStatusSource applicationStatusSource;
    private final ApplicationConfiguration applicationConfiguration;
    private final RepositoryRegistry repositoryRegistry;
    private final Config config;
    private final LocalContentDiscoverer localContentDiscoverer;
    private final RemoteContentDiscoverer remoteContentDiscoverer;
    private final RemoteStrategy quickRemoteStrategy;
    private final EventDispatcher eventDispatcher;
    private final NexusScheduledExecutorService executor;
    private final ConstrainedExecutor constrainedExecutor;
    private volatile boolean periodicUpdaterDidRunAtLeastOnce = false;

    @Inject
    public ManagerImpl(EventBus eventBus, ApplicationStatusSource applicationStatusSource, ApplicationConfiguration applicationConfiguration, RepositoryRegistry repositoryRegistry, Config config, LocalContentDiscoverer localContentDiscoverer, RemoteContentDiscoverer remoteContentDiscoverer, @Named(value="prefix-file") RemoteStrategy quickRemoteStrategy) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.applicationStatusSource = (ApplicationStatusSource)Preconditions.checkNotNull((Object)applicationStatusSource);
        this.applicationConfiguration = (ApplicationConfiguration)Preconditions.checkNotNull((Object)applicationConfiguration);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.config = (Config)Preconditions.checkNotNull((Object)config);
        this.localContentDiscoverer = (LocalContentDiscoverer)Preconditions.checkNotNull((Object)localContentDiscoverer);
        this.remoteContentDiscoverer = (RemoteContentDiscoverer)Preconditions.checkNotNull((Object)remoteContentDiscoverer);
        this.quickRemoteStrategy = (RemoteStrategy)Preconditions.checkNotNull((Object)quickRemoteStrategy);
        ScheduledThreadPoolExecutor target = new ScheduledThreadPoolExecutor(5, new NexusThreadFactory("ar", "AR-Updater"), new ThreadPoolExecutor.AbortPolicy());
        this.executor = NexusScheduledExecutorService.forFixedSubject(target, FakeAlmightySubject.TASK_SUBJECT);
        this.constrainedExecutor = new ConstrainedExecutorImpl((Executor)((Object)this.executor));
        this.eventDispatcher = new EventDispatcher(this);
        this.eventBus.register((Object)this);
    }

    @Override
    public void startup() {
        if (this.config.isFeatureActive()) {
            for (MavenRepository mavenRepository : this.repositoryRegistry.getRepositoriesWithFacet(MavenRepository.class)) {
                FilePrefixSource prefixSource;
                if (!this.isMavenRepositorySupported(mavenRepository) || !mavenRepository.getLocalStatus().shouldServiceRequest() || !(prefixSource = this.getPrefixSourceFor(mavenRepository)).exists()) continue;
                this.log.debug("Initializing prefix file of {}", (Object)mavenRepository);
                if (prefixSource.supported()) {
                    this.eventBus.post((Object)new PrefixFilePublishedRepositoryEvent(mavenRepository, prefixSource));
                    continue;
                }
                this.eventBus.post((Object)new PrefixFileUnpublishedRepositoryEvent(mavenRepository));
            }
            this.executor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (!ManagerImpl.this.applicationStatusSource.getSystemStatus().isNexusStarted()) {
                        ManagerImpl.this.log.debug("Nexus not yet started, bailing out");
                        return;
                    }
                    ManagerImpl.this.mayUpdateAllProxyPrefixFiles();
                    ManagerImpl.this.periodicUpdaterDidRunAtLeastOnce = true;
                }
            }, 0L, TimeUnit.HOURS.toMillis(1L), TimeUnit.MILLISECONDS);
            this.eventBus.register((Object)this.eventDispatcher);
        }
    }

    @Override
    public void shutdown() {
        if (this.config.isFeatureActive()) {
            this.eventBus.unregister((Object)this.eventDispatcher);
        }
        this.executor.shutdown();
        this.constrainedExecutor.cancelAllJobs();
        try {
            if (!this.executor.awaitTermination(15L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.log.debug("Could not cleanly shut down", (Throwable)e);
        }
    }

    @Override
    public void initializePrefixFile(MavenRepository mavenRepository) {
        this.log.debug("Initializing prefix file of newly added {}", (Object)mavenRepository);
        try {
            this.updatePrefixFile(mavenRepository);
            this.log.info("Initializing non-existing prefix file of newly added {}", (Object)RepositoryStringUtils.getHumanizedNameString(mavenRepository));
        }
        catch (Exception e) {
            this.log.warn("Problem during prefix file initialisation of newly added {}", (Object)RepositoryStringUtils.getHumanizedNameString(mavenRepository), (Object)e);
            try {
                this.unpublish(mavenRepository);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void mayUpdateAllProxyPrefixFiles() {
        this.log.trace("mayUpdateAllProxyPrefixFiles started");
        for (MavenRepository mavenRepository : this.repositoryRegistry.getRepositoriesWithFacet(MavenRepository.class)) {
            if (!this.isMavenRepositorySupported(mavenRepository)) continue;
            try {
                FilePrefixSource prefixSource = this.getPrefixSourceFor(mavenRepository);
                if (!prefixSource.exists()) {
                    this.doUpdatePrefixFileAsync(true, mavenRepository);
                    continue;
                }
                MavenProxyRepository mavenProxyRepository = mavenRepository.adaptToFacet(MavenProxyRepository.class);
                if (mavenProxyRepository == null) continue;
                this.mayUpdateProxyPrefixFile(mavenProxyRepository);
            }
            catch (IllegalStateException e) {
                this.log.trace("Repository {} is not in state to be updated", (Object)mavenRepository);
            }
            catch (Exception e) {
                this.log.warn("Problem during prefix file update of repository {}", (Object)RepositoryStringUtils.getHumanizedNameString(mavenRepository), (Object)e);
            }
        }
    }

    protected boolean mayUpdateProxyPrefixFile(MavenProxyRepository mavenProxyRepository) {
        DiscoveryStatus discoveryStatus = this.getStatusFor(mavenProxyRepository).getDiscoveryStatus();
        if (discoveryStatus.getStatus().isEnabled()) {
            DiscoveryConfig config = this.getRemoteDiscoveryConfig(mavenProxyRepository);
            if (discoveryStatus.getStatus() == DiscoveryStatus.DStatus.ERROR || discoveryStatus.getStatus() == DiscoveryStatus.DStatus.ENABLED_NOT_POSSIBLE || System.currentTimeMillis() - discoveryStatus.getLastDiscoveryTimestamp() > config.getDiscoveryInterval()) {
                if (discoveryStatus.getStatus() == DiscoveryStatus.DStatus.ENABLED_IN_PROGRESS) {
                    this.log.debug("Proxy {} has never been discovered before", (Object)mavenProxyRepository);
                } else if (discoveryStatus.getStatus() == DiscoveryStatus.DStatus.ENABLED_NOT_POSSIBLE) {
                    this.log.debug("Proxy {} discovery was not possible before", (Object)mavenProxyRepository);
                } else if (discoveryStatus.getStatus() == DiscoveryStatus.DStatus.ERROR) {
                    this.log.debug("Proxy {} previous discovery hit an error", (Object)mavenProxyRepository);
                } else {
                    this.log.debug("Proxy {} needs periodic remote discovery update", (Object)mavenProxyRepository);
                }
                boolean updateSpawned = this.doUpdatePrefixFileAsync(false, mavenProxyRepository);
                if (!updateSpawned) {
                    this.log.info("Proxy {} periodic remote discovery skipped as there is an ongoing job updating it, consider raising the update interval for this repository", (Object)RepositoryStringUtils.getHumanizedNameString(mavenProxyRepository));
                }
                return updateSpawned;
            }
            this.log.debug("Proxy {} prefix file is up to date", (Object)mavenProxyRepository);
        } else {
            this.log.debug("Proxy {} prefix file update requested, but it's remote discovery is disabled", (Object)mavenProxyRepository);
        }
        return false;
    }

    @Override
    public boolean updatePrefixFile(MavenRepository mavenRepository) throws IllegalStateException {
        this.checkUpdateConditions(mavenRepository);
        return this.doUpdatePrefixFileAsync(false, mavenRepository);
    }

    @Override
    public boolean forceUpdatePrefixFile(MavenRepository mavenRepository) throws IllegalStateException {
        this.checkUpdateConditions(mavenRepository);
        return this.doUpdatePrefixFileAsync(true, mavenRepository);
    }

    @Override
    public void forceProxyQuickUpdatePrefixFile(MavenProxyRepository mavenProxyRepository) throws IllegalStateException {
        this.checkUpdateConditions(mavenProxyRepository);
        try {
            boolean stateChanged;
            this.log.debug("Quick updating prefix file of {}", (Object)mavenProxyRepository);
            this.constrainedExecutor.cancelRunningWithKey(mavenProxyRepository.getId());
            PrefixSource prefixSource = this.updateProxyPrefixFile(mavenProxyRepository, Collections.singletonList(this.quickRemoteStrategy));
            FilePrefixSource oldPrefixSource = this.getPrefixSourceFor(mavenProxyRepository);
            boolean bl = stateChanged = oldPrefixSource.supported() != (prefixSource != null && prefixSource.supported());
            if (prefixSource != null && prefixSource.supported()) {
                if (stateChanged) {
                    this.log.info("Updated and published prefix file of {}", (Object)RepositoryStringUtils.getHumanizedNameString(mavenProxyRepository));
                }
                this.publish(mavenProxyRepository, prefixSource);
            } else {
                if (stateChanged) {
                    this.log.info("Unpublished prefix file of {} (and is marked for noscrape)", (Object)RepositoryStringUtils.getHumanizedNameString(mavenProxyRepository));
                }
                this.unpublish(mavenProxyRepository);
            }
        }
        catch (Exception e) {
            try {
                this.unpublish(mavenProxyRepository);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isMavenRepositorySupported(MavenRepository mavenRepository) throws IllegalStateException {
        MavenShadowRepository mavenShadowRepository = mavenRepository.adaptToFacet(MavenShadowRepository.class);
        if (mavenShadowRepository != null) {
            return false;
        }
        return "maven2".equals(mavenRepository.getRepositoryContentClass().getId());
    }

    protected void checkUpdateConditions(MavenRepository mavenRepository) throws IllegalStateException {
        if (!this.isMavenRepositorySupported(mavenRepository)) {
            throw new IllegalStateException("Repository not supported by automatic routing feature (only Maven2 hosted, proxy and group repositories are supported)");
        }
        LocalStatus localStatus = mavenRepository.getLocalStatus();
        if (!localStatus.shouldServiceRequest()) {
            throw new IllegalStateException(SimpleFormat.format((String)"Repository out of service '%s'", (Object[])new Object[]{mavenRepository.getId()}));
        }
    }

    protected boolean doUpdatePrefixFileAsync(boolean forced, MavenRepository mavenRepository) {
        UpdateRepositoryRunnable updateRepositoryJob = new UpdateRepositoryRunnable(new LoggingProgressListener(this.log), this.applicationStatusSource, this, mavenRepository);
        if (forced) {
            boolean canceledPreviousJob = this.constrainedExecutor.mustExecute(mavenRepository.getId(), updateRepositoryJob);
            if (canceledPreviousJob) {
                this.log.debug("Forced prefix file update on {} canceled currently running discovery job", (Object)mavenRepository);
            }
            return canceledPreviousJob;
        }
        return this.constrainedExecutor.mayExecute(mavenRepository.getId(), updateRepositoryJob);
    }

    @VisibleForTesting
    public boolean isUpdatePrefixFileJobRunning() {
        if (this.config.isFeatureActive() && !this.periodicUpdaterDidRunAtLeastOnce) {
            this.log.debug("Boot process not done yet, periodic updater did not yet finish!");
            return true;
        }
        Statistics statistics = this.constrainedExecutor.getStatistics();
        this.log.debug("Running update jobs for {}", statistics.getCurrentlyRunningJobKeys());
        return !statistics.getCurrentlyRunningJobKeys().isEmpty();
    }

    protected void updateAndPublishPrefixFile(MavenRepository mavenRepository) throws IOException {
        this.log.debug("Updating prefix file of {}", (Object)mavenRepository);
        try {
            boolean stateChanged;
            PrefixSource prefixSource;
            if (mavenRepository.getRepositoryKind().isFacetAvailable(MavenGroupRepository.class)) {
                prefixSource = this.updateGroupPrefixFile(mavenRepository.adaptToFacet(MavenGroupRepository.class));
            } else if (mavenRepository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class)) {
                prefixSource = this.updateProxyPrefixFile(mavenRepository.adaptToFacet(MavenProxyRepository.class), null);
            } else if (mavenRepository.getRepositoryKind().isFacetAvailable(MavenHostedRepository.class)) {
                prefixSource = this.updateHostedPrefixFile(mavenRepository.adaptToFacet(MavenHostedRepository.class));
            } else {
                this.log.info("Repository {} unsupported by automatic routing feature", (Object)RepositoryStringUtils.getFullHumanizedNameString(mavenRepository));
                return;
            }
            FilePrefixSource oldPrefixSource = this.getPrefixSourceFor(mavenRepository);
            boolean bl = stateChanged = oldPrefixSource.supported() != (prefixSource != null && prefixSource.supported());
            if (prefixSource != null && prefixSource.supported()) {
                if (stateChanged) {
                    this.log.info("Updated and published prefix file of {}", (Object)RepositoryStringUtils.getHumanizedNameString(mavenRepository));
                }
                this.publish(mavenRepository, prefixSource);
            } else {
                if (stateChanged) {
                    this.log.info("Unpublished prefix file of {} (and is marked for noscrape)", (Object)RepositoryStringUtils.getHumanizedNameString(mavenRepository));
                }
                this.unpublish(mavenRepository);
            }
        }
        catch (IllegalStateException e) {
            this.log.debug("Maven repository {} not in state for prefix file update: {}", (Object)mavenRepository, (Object)e.getMessage());
        }
    }

    protected PrefixSource updateProxyPrefixFile(MavenProxyRepository mavenProxyRepository, List<RemoteStrategy> remoteStrategies) throws IllegalStateException, IOException {
        this.checkUpdateConditions(mavenProxyRepository);
        PropfileDiscoveryStatusSource discoveryStatusSource = new PropfileDiscoveryStatusSource(mavenProxyRepository);
        ProxyMode proxyMode = mavenProxyRepository.getProxyMode();
        if (!proxyMode.shouldProxy()) {
            DiscoveryStatus discoveryStatus = new DiscoveryStatus(DiscoveryStatus.DStatus.ENABLED_NOT_POSSIBLE, "none", "Proxy repository is blocked.", System.currentTimeMillis());
            discoveryStatusSource.write(discoveryStatus);
            throw new IllegalStateException("Maven repository " + RepositoryStringUtils.getHumanizedNameString(mavenProxyRepository) + " not in state to be updated (is blocked).");
        }
        ArrayListPrefixSource prefixSource = null;
        DiscoveryConfig config = this.getRemoteDiscoveryConfig(mavenProxyRepository);
        if (config.isEnabled()) {
            DiscoveryResult.Outcome lastOutcome;
            PrefixSource remotePrefixSource;
            DiscoveryResult<MavenProxyRepository> discoveryResult = null == remoteStrategies ? this.remoteContentDiscoverer.discoverRemoteContent(mavenProxyRepository) : this.remoteContentDiscoverer.discoverRemoteContent(mavenProxyRepository, remoteStrategies);
            this.log.debug("Results of {} remote discovery: {}", (Object)mavenProxyRepository, discoveryResult.getAllResults());
            if (discoveryResult.isSuccessful() && (remotePrefixSource = discoveryResult.getPrefixSource()).supported()) {
                DiscoveryResult<MavenRepository> localDiscoveryResult = this.localContentDiscoverer.discoverLocalContent(mavenProxyRepository);
                if (localDiscoveryResult.isSuccessful()) {
                    ArrayListPrefixSource mergedPrefixSource;
                    HashSet mergedEntries = Sets.newHashSet();
                    mergedEntries.addAll(remotePrefixSource.readEntries());
                    mergedEntries.addAll(localDiscoveryResult.getPrefixSource().readEntries());
                    prefixSource = mergedPrefixSource = new ArrayListPrefixSource(Lists.newArrayList((Iterable)mergedEntries), remotePrefixSource.getLostModifiedTimestamp());
                } else {
                    this.log.debug("{} local discovery unsuccessful", (Object)mavenProxyRepository);
                }
            }
            DiscoveryStatus.DStatus status = (lastOutcome = discoveryResult.getLastResult()).isSuccessful() ? DiscoveryStatus.DStatus.SUCCESSFUL : (lastOutcome.getThrowable() == null ? DiscoveryStatus.DStatus.UNSUCCESSFUL : DiscoveryStatus.DStatus.ERROR);
            DiscoveryStatus discoveryStatus = new DiscoveryStatus(status, lastOutcome.getStrategyId(), lastOutcome.getMessage(), System.currentTimeMillis());
            discoveryStatusSource.write(discoveryStatus);
        } else {
            this.log.info("{} remote discovery disabled", (Object)RepositoryStringUtils.getHumanizedNameString(mavenProxyRepository));
        }
        return prefixSource;
    }

    protected PrefixSource updateHostedPrefixFile(MavenHostedRepository mavenHostedRepository) throws IllegalStateException, IOException {
        this.checkUpdateConditions(mavenHostedRepository);
        PrefixSource prefixSource = null;
        DiscoveryResult<MavenRepository> discoveryResult = this.localContentDiscoverer.discoverLocalContent(mavenHostedRepository);
        if (discoveryResult.isSuccessful()) {
            prefixSource = discoveryResult.getPrefixSource();
        } else {
            this.log.debug("{} local discovery unsuccessful", (Object)mavenHostedRepository);
        }
        return prefixSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrefixSource updateGroupPrefixFile(MavenGroupRepository mavenGroupRepository) throws IllegalStateException, IOException {
        this.checkUpdateConditions(mavenGroupRepository);
        ArrayListPrefixSource prefixSource = null;
        boolean allMembersHavePublished = true;
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        for (Repository member : mavenGroupRepository.getMemberRepositories()) {
            if (!member.getRepositoryKind().isFacetAvailable(MavenRepository.class) || !member.getLocalStatus().shouldServiceRequest()) continue;
            FilePrefixSource memberEntrySource = this.getPrefixSourceFor(member.adaptToFacet(MavenRepository.class));
            RepositoryItemUidLock lock = memberEntrySource.getRepositoryItemUid().getLock();
            lock.lock(Action.read);
            try {
                if (!memberEntrySource.supported()) {
                    allMembersHavePublished = false;
                    break;
                }
                entries.addAll(memberEntrySource.readEntries());
            }
            finally {
                lock.unlock();
            }
        }
        if (allMembersHavePublished) {
            prefixSource = new ArrayListPrefixSource(new ArrayList<String>(entries));
        }
        return prefixSource;
    }

    @Override
    public RoutingStatus getStatusFor(MavenRepository mavenRepository) {
        boolean remoteDiscoveryEnabled;
        MavenProxyRepository mavenProxyRepository = mavenRepository.adaptToFacet(MavenProxyRepository.class);
        if (mavenProxyRepository != null) {
            DiscoveryConfig discoveryConfig = this.getRemoteDiscoveryConfig(mavenProxyRepository);
            remoteDiscoveryEnabled = discoveryConfig.isEnabled();
        } else {
            remoteDiscoveryEnabled = false;
        }
        PublishingStatus publishingStatus = null;
        DiscoveryStatus discoveryStatus = null;
        FilePrefixSource publishedEntrySource = this.getPrefixSourceFor(mavenRepository);
        if (!publishedEntrySource.supported()) {
            String message;
            if (this.isMavenRepositorySupported(mavenRepository)) {
                if (mavenRepository.getRepositoryKind().isFacetAvailable(MavenGroupRepository.class)) {
                    MavenGroupRepository mavenGroupRepository = mavenRepository.adaptToFacet(MavenGroupRepository.class);
                    ArrayList<String> membersWithoutPrefixFiles = new ArrayList<String>();
                    for (Repository member : mavenGroupRepository.getMemberRepositories()) {
                        FilePrefixSource ps;
                        MavenRepository memberMavenRepository = member.adaptToFacet(MavenRepository.class);
                        if (null == memberMavenRepository || (ps = this.getPrefixSourceFor(memberMavenRepository)).supported()) continue;
                        membersWithoutPrefixFiles.add(memberMavenRepository.getName());
                    }
                    message = "Publishing not possible, following members have no published prefix file: " + Joiner.on((String)", ").join(membersWithoutPrefixFiles);
                } else {
                    message = mavenRepository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class) ? (remoteDiscoveryEnabled ? "Discovery in progress or unable to discover remote content (see discovery status)." : "Remote discovery not enabled.") : (mavenRepository.getRepositoryKind().isFacetAvailable(MavenHostedRepository.class) ? "Check Nexus logs for more details." : (mavenRepository.getRepositoryKind().isFacetAvailable(ShadowRepository.class) ? "Unsupported repository type (only hosted, proxy and groups are supported)." : "Check Nexus logs for more details."));
                }
            } else {
                message = "Unsupported repository format (only Maven2 format is supported).";
            }
            publishingStatus = new PublishingStatus(PublishingStatus.PStatus.NOT_PUBLISHED, message, -1L, null);
        } else {
            publishingStatus = new PublishingStatus(PublishingStatus.PStatus.PUBLISHED, "Prefix file published successfully.", publishedEntrySource.getLostModifiedTimestamp(), publishedEntrySource.getFilePath());
        }
        if (mavenProxyRepository == null) {
            discoveryStatus = new DiscoveryStatus(DiscoveryStatus.DStatus.NOT_A_PROXY);
        } else if (!remoteDiscoveryEnabled) {
            discoveryStatus = new DiscoveryStatus(DiscoveryStatus.DStatus.DISABLED);
        } else if (this.constrainedExecutor.hasRunningWithKey(mavenProxyRepository.getId())) {
            discoveryStatus = new DiscoveryStatus(DiscoveryStatus.DStatus.ENABLED_IN_PROGRESS);
        } else {
            PropfileDiscoveryStatusSource discoveryStatusSource = new PropfileDiscoveryStatusSource(mavenProxyRepository);
            if (!discoveryStatusSource.exists()) {
                discoveryStatus = !mavenProxyRepository.getLocalStatus().shouldServiceRequest() ? new DiscoveryStatus(DiscoveryStatus.DStatus.ENABLED_NOT_POSSIBLE, "none", "Repository is out of service.", System.currentTimeMillis()) : new DiscoveryStatus(DiscoveryStatus.DStatus.ENABLED_IN_PROGRESS);
            } else {
                try {
                    discoveryStatus = discoveryStatusSource.read();
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        }
        return new RoutingStatus(publishingStatus, discoveryStatus);
    }

    @Override
    public DiscoveryConfig getRemoteDiscoveryConfig(MavenProxyRepository mavenProxyRepository) {
        AbstractMavenRepositoryConfiguration configuration = (AbstractMavenRepositoryConfiguration)((AbstractMavenRepository)mavenProxyRepository).getCurrentCoreConfiguration().getExternalConfiguration().getConfiguration(false);
        return new DiscoveryConfig(this.config.isFeatureActive() && configuration.isRoutingDiscoveryEnabled(), configuration.getRoutingDiscoveryInterval());
    }

    @Override
    public void setRemoteDiscoveryConfig(MavenProxyRepository mavenProxyRepository, DiscoveryConfig config) throws IOException {
        AbstractMavenRepositoryConfiguration configuration = (AbstractMavenRepositoryConfiguration)((AbstractMavenRepository)mavenProxyRepository).getCurrentCoreConfiguration().getExternalConfiguration().getConfiguration(false);
        boolean enabledChanged = configuration.isRoutingDiscoveryEnabled() != config.isEnabled();
        configuration.setRoutingDiscoveryEnabled(config.isEnabled());
        configuration.setRoutingDiscoveryInterval(config.getDiscoveryInterval());
        this.applicationConfiguration.saveConfiguration();
        if (enabledChanged) {
            this.updatePrefixFile(mavenProxyRepository);
        }
    }

    @Override
    public FilePrefixSource getPrefixSourceFor(MavenRepository mavenRepository) {
        return new FilePrefixSource(mavenRepository, this.config.getLocalPrefixFilePath(), this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerEntry(MavenHostedRepository mavenHostedRepository, StorageItem item) throws IOException {
        block10: {
            if (this.constrainedExecutor.hasRunningWithKey(mavenHostedRepository.getId())) {
                return false;
            }
            FilePrefixSource prefixSource = this.getPrefixSourceFor(mavenHostedRepository);
            RepositoryItemUidLock lock = prefixSource.getRepositoryItemUid().getLock();
            lock.lock(Action.read);
            try {
                if (!prefixSource.supported()) {
                    boolean bl = false;
                    return bl;
                }
                String entry = item.getPathDepth() == 0 ? item.getPath() : item.getParentPath();
                WritablePrefixSourceModifier wesm = new WritablePrefixSourceModifier(prefixSource, this.config.getLocalScrapeDepth());
                wesm.offerEntry(entry);
                if (!wesm.hasChanges()) break block10;
                boolean changed = false;
                lock.lock(Action.update);
                try {
                    wesm.reset();
                    wesm.offerEntry(entry);
                    changed = wesm.apply();
                    if (changed) {
                        this.publish(mavenHostedRepository, prefixSource);
                    }
                }
                finally {
                    lock.unlock();
                }
                boolean bl = changed;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeEntry(MavenHostedRepository mavenHostedRepository, StorageItem item) throws IOException {
        block10: {
            if (this.constrainedExecutor.hasRunningWithKey(mavenHostedRepository.getId())) {
                return false;
            }
            FilePrefixSource prefixSource = this.getPrefixSourceFor(mavenHostedRepository);
            RepositoryItemUidLock lock = prefixSource.getRepositoryItemUid().getLock();
            lock.lock(Action.read);
            try {
                if (!prefixSource.supported()) {
                    boolean bl = false;
                    return bl;
                }
                WritablePrefixSourceModifier wesm = new WritablePrefixSourceModifier(prefixSource, this.config.getLocalScrapeDepth());
                wesm.revokeEntry(item.getPath());
                if (!wesm.hasChanges()) break block10;
                boolean changed = false;
                lock.lock(Action.update);
                try {
                    wesm.reset();
                    wesm.revokeEntry(item.getPath());
                    changed = wesm.apply();
                    if (changed) {
                        this.publish(mavenHostedRepository, prefixSource);
                    }
                }
                finally {
                    lock.unlock();
                }
                boolean bl = changed;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    @Override
    public void publish(MavenRepository mavenRepository, PrefixSource prefixSource) throws IOException {
        FilePrefixSource prefixesFile = this.getPrefixSourceFor(mavenRepository);
        try {
            prefixesFile.writeEntries(prefixSource);
        }
        catch (InvalidInputException e) {
            this.unpublish(mavenRepository);
            throw e;
        }
        this.eventBus.post((Object)new PrefixFilePublishedRepositoryEvent(mavenRepository, prefixesFile));
        this.propagatePrefixFileUpdateOf(mavenRepository);
    }

    @Override
    public void unpublish(MavenRepository mavenRepository) throws IOException {
        this.getPrefixSourceFor(mavenRepository).writeUnsupported();
        this.eventBus.post((Object)new PrefixFileUnpublishedRepositoryEvent(mavenRepository));
        this.propagatePrefixFileUpdateOf(mavenRepository);
    }

    protected void propagatePrefixFileUpdateOf(MavenRepository mavenRepository) {
        MavenGroupRepository containingGroupRepository = null;
        List<GroupRepository> groups = this.repositoryRegistry.getGroupsOfRepository(mavenRepository);
        for (GroupRepository groupRepository : groups) {
            containingGroupRepository = groupRepository.adaptToFacet(MavenGroupRepository.class);
            if (mavenRepository == null) continue;
            this.doUpdatePrefixFileAsync(true, containingGroupRepository);
        }
    }

    @Override
    public boolean isEventAboutPrefixFile(RepositoryItemEvent evt) {
        return evt.getRepository().getRepositoryKind().isFacetAvailable(MavenRepository.class) && evt.getItem() instanceof StorageFileItem && this.config.getLocalPrefixFilePath().equals(evt.getItem().getPath());
    }

    @Subscribe
    public void onNexusStartedEvent(NexusStartedEvent evt) {
        this.startup();
    }

    @Subscribe
    public void onNexusStoppedEvent(NexusStoppedEvent evt) {
        this.shutdown();
    }
}

