/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.StorageCollectionItem;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.routing.Config;
import org.sonatype.nexus.proxy.maven.routing.discovery.DiscoveryResult;
import org.sonatype.nexus.proxy.maven.routing.discovery.LocalContentDiscoverer;
import org.sonatype.nexus.proxy.maven.routing.internal.ArrayListPrefixSource;
import org.sonatype.nexus.proxy.maven.routing.internal.task.CancelableUtil;
import org.sonatype.nexus.proxy.walker.AbstractWalkerProcessor;
import org.sonatype.nexus.proxy.walker.DefaultStoreWalkerFilter;
import org.sonatype.nexus.proxy.walker.DefaultWalkerContext;
import org.sonatype.nexus.proxy.walker.ParentOMatic;
import org.sonatype.nexus.proxy.walker.Walker;
import org.sonatype.nexus.proxy.walker.WalkerContext;
import org.sonatype.nexus.proxy.walker.WalkerException;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class LocalContentDiscovererImpl
extends ComponentSupport
implements LocalContentDiscoverer {
    private static final String ID = "local";
    private final Config config;
    private final Walker walker;

    @Inject
    public LocalContentDiscovererImpl(Config config, Walker walker) {
        this.config = (Config)Preconditions.checkNotNull((Object)config);
        this.walker = (Walker)Preconditions.checkNotNull((Object)walker);
    }

    @Override
    public DiscoveryResult<MavenRepository> discoverLocalContent(MavenRepository mavenRepository) throws IOException {
        DiscoveryResult<MavenRepository> discoveryResult = new DiscoveryResult<MavenRepository>(mavenRepository);
        DefaultWalkerContext context = new DefaultWalkerContext(mavenRepository, new ResourceStoreRequest("/", true, false), new DepthLimitedStoreWalkerFilter(this.config.getLocalScrapeDepth()), true);
        PrefixCollectorProcessor prefixCollectorProcessor = new PrefixCollectorProcessor();
        context.getProcessors().add(prefixCollectorProcessor);
        try {
            this.walker.walk(context);
            ParentOMatic parentOMatic = prefixCollectorProcessor.getParentOMatic();
            if (parentOMatic.getRoot().isLeaf()) {
                discoveryResult.recordSuccess(ID, "Repository crawled successfully (is empty)", new ArrayListPrefixSource(Collections.emptyList()));
            } else {
                discoveryResult.recordSuccess(ID, "Repository crawled successfully", new ArrayListPrefixSource(this.getAllLeafPaths(parentOMatic, this.config.getLocalScrapeDepth())));
            }
        }
        catch (WalkerException e) {
            if (e.getWalkerContext().getStopCause() != null) {
                discoveryResult.recordError(ID, e.getWalkerContext().getStopCause());
            }
            discoveryResult.recordError(ID, e);
        }
        return discoveryResult;
    }

    protected List<String> getAllLeafPaths(ParentOMatic parentOMatic, int maxDepth) {
        if (maxDepth != Integer.MAX_VALUE) {
            parentOMatic.cutNodesDeeperThan(maxDepth);
        }
        return parentOMatic.getAllLeafPaths();
    }

    protected static class PrefixCollectorProcessor
    extends AbstractWalkerProcessor {
        private final ParentOMatic parentOMatic = new ParentOMatic();

        public ParentOMatic getParentOMatic() {
            return this.parentOMatic;
        }

        @Override
        public void onCollectionEnter(WalkerContext context, StorageCollectionItem coll) throws Exception {
            CancelableUtil.checkInterruption();
            this.parentOMatic.addPath(coll.getPath());
        }

        @Override
        public void processItem(WalkerContext context, StorageItem item) throws Exception {
            CancelableUtil.checkInterruption();
            if (item instanceof StorageFileItem) {
                if (item.getPathDepth() == 0) {
                    this.parentOMatic.addPath(item.getPath());
                } else {
                    this.parentOMatic.addPath(item.getParentPath());
                }
            }
        }
    }

    protected static class DepthLimitedStoreWalkerFilter
    extends DefaultStoreWalkerFilter {
        private final int scrapeDepth;

        public DepthLimitedStoreWalkerFilter(int scrapeDepth) {
            Preconditions.checkArgument((scrapeDepth > 0 ? 1 : 0) != 0);
            this.scrapeDepth = scrapeDepth;
        }

        @Override
        public boolean shouldProcessRecursively(WalkerContext context, StorageCollectionItem coll) {
            return coll.getPathDepth() < this.scrapeDepth && super.shouldProcessRecursively(context, coll);
        }
    }
}

