/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.access.Action;
import org.sonatype.nexus.proxy.item.ByteArrayContentLocator;
import org.sonatype.nexus.proxy.item.ContentLocator;
import org.sonatype.nexus.proxy.item.DefaultStorageFileItem;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.RepositoryItemUidLock;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.routing.Config;
import org.sonatype.nexus.proxy.maven.routing.Manager;
import org.sonatype.nexus.proxy.maven.routing.PrefixSource;
import org.sonatype.nexus.proxy.maven.routing.WritablePrefixSource;
import org.sonatype.nexus.proxy.maven.routing.internal.TextFilePrefixSourceMarshaller;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;

public class FilePrefixSource
implements WritablePrefixSource {
    private final MavenRepository mavenRepository;
    private final String path;
    private final TextFilePrefixSourceMarshaller prefixSourceMarshaller;
    private final RepositoryItemUid repositoryItemUid;

    protected FilePrefixSource(MavenRepository mavenRepository, String path, Config config) {
        this.mavenRepository = (MavenRepository)Preconditions.checkNotNull((Object)mavenRepository);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.prefixSourceMarshaller = new TextFilePrefixSourceMarshaller(config);
        this.repositoryItemUid = mavenRepository.createUid(path);
    }

    public String getFilePath() {
        return this.path;
    }

    public MavenRepository getMavenRepository() {
        return this.mavenRepository;
    }

    public RepositoryItemUid getRepositoryItemUid() {
        return this.repositoryItemUid;
    }

    protected TextFilePrefixSourceMarshaller getPrefixSourceMarshaller() {
        return this.prefixSourceMarshaller;
    }

    @Override
    public boolean exists() {
        try {
            return this.doReadProtected(new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    return FilePrefixSource.this.getFileItem() != null;
                }
            });
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean supported() {
        try {
            return this.doReadProtected(new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    StorageFileItem file = FilePrefixSource.this.getFileItem();
                    if (file != null) {
                        return FilePrefixSource.this.getPrefixSourceMarshaller().read(file).supported();
                    }
                    return false;
                }
            });
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public long getLostModifiedTimestamp() {
        try {
            return this.doReadProtected(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    StorageFileItem file = FilePrefixSource.this.getFileItem();
                    if (file != null) {
                        return file.getModified();
                    }
                    return -1L;
                }
            });
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public List<String> readEntries() throws IOException {
        return this.doReadProtected(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                StorageFileItem file = FilePrefixSource.this.getFileItem();
                if (file == null) {
                    return null;
                }
                return FilePrefixSource.this.getPrefixSourceMarshaller().read(file).entries();
            }
        });
    }

    @Override
    public void writeEntries(PrefixSource prefixSource) throws IOException {
        Preconditions.checkNotNull((Object)prefixSource);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.getPrefixSourceMarshaller().write(prefixSource.readEntries(), bos);
        this.putFileItem(new ByteArrayContentLocator(bos.toByteArray(), "text/plain"));
    }

    @Override
    public void delete() throws IOException {
        this.deleteFileItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R doReadProtected(Callable<R> callable) throws IOException {
        RepositoryItemUidLock lock = this.getRepositoryItemUid().getLock();
        lock.lock(Action.read);
        try {
            R r = callable.call();
            return r;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    protected StorageFileItem getFileItem() throws IOException {
        try {
            ResourceStoreRequest request = new ResourceStoreRequest(this.getFilePath());
            request.setRequestLocalOnly(true);
            request.setRequestGroupLocalOnly(true);
            request.getRequestContext().put(Manager.ROUTING_INITIATED_FILE_OPERATION_FLAG_KEY, (Object)Boolean.TRUE);
            StorageItem item = this.getMavenRepository().retrieveItem(true, request);
            if (item instanceof StorageFileItem) {
                return (StorageFileItem)item;
            }
            return null;
        }
        catch (IllegalOperationException e) {
            return null;
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    protected void putFileItem(ContentLocator content) throws IOException {
        ResourceStoreRequest request = new ResourceStoreRequest(this.getFilePath());
        request.setRequestLocalOnly(true);
        request.setRequestGroupLocalOnly(true);
        request.getRequestContext().put(Manager.ROUTING_INITIATED_FILE_OPERATION_FLAG_KEY, (Object)Boolean.TRUE);
        DefaultStorageFileItem file = new DefaultStorageFileItem(this.getMavenRepository(), request, true, true, content);
        try {
            this.getMavenRepository().storeItem(true, file);
        }
        catch (UnsupportedStorageOperationException unsupportedStorageOperationException) {
        }
        catch (IllegalOperationException illegalOperationException) {
            // empty catch block
        }
    }

    protected void deleteFileItem() throws IOException {
        ResourceStoreRequest request = new ResourceStoreRequest(this.getFilePath());
        request.setRequestLocalOnly(true);
        request.setRequestGroupLocalOnly(true);
        request.getRequestContext().put(Manager.ROUTING_INITIATED_FILE_OPERATION_FLAG_KEY, (Object)Boolean.TRUE);
        try {
            this.getMavenRepository().deleteItem(true, request);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (UnsupportedStorageOperationException unsupportedStorageOperationException) {
        }
        catch (IllegalOperationException illegalOperationException) {
            // empty catch block
        }
    }

    public void writeUnsupported() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.getPrefixSourceMarshaller().writeUnsupported(bos);
        this.putFileItem(new ByteArrayContentLocator(bos.toByteArray(), "text/plain"));
    }
}

