/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.proxy.RequestContext;
import org.sonatype.nexus.proxy.events.RepositoryConfigurationUpdatedEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemEvent;
import org.sonatype.nexus.proxy.events.RepositoryItemEventCache;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDelete;
import org.sonatype.nexus.proxy.events.RepositoryItemEventDeleteRoot;
import org.sonatype.nexus.proxy.events.RepositoryItemEventStore;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.item.uid.IsHiddenAttribute;
import org.sonatype.nexus.proxy.maven.MavenHostedRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.routing.Manager;
import org.sonatype.nexus.proxy.maven.routing.PrefixSource;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;

public class EventDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(EventDispatcher.class);
    private final Manager manager;

    public EventDispatcher(Manager manager) {
        this.manager = (Manager)Preconditions.checkNotNull((Object)manager);
    }

    protected Logger getLogger() {
        return logger;
    }

    protected void handleRepositoryAdded(MavenRepository mavenRepository) {
        this.manager.initializePrefixFile(mavenRepository);
    }

    protected void handleRepositoryModified(MavenRepository mavenRepository) {
        try {
            this.manager.forceUpdatePrefixFile(mavenRepository);
        }
        catch (IllegalStateException e) {
            this.getLogger().debug("Repository {} is in bad state for prefix file update: {}", (Object)mavenRepository, (Object)e.getMessage());
        }
    }

    protected void handlePrefixFileUpdate(RepositoryItemEvent evt) {
        MavenRepository mavenRepository = (MavenRepository)evt.getRepository();
        try {
            PrefixSource prefixSource = this.manager.getPrefixSourceFor(mavenRepository);
            this.manager.publish(mavenRepository, prefixSource);
        }
        catch (IOException e) {
            this.getLogger().warn("Problem while publishing prefix file for repository {}", (Object)RepositoryStringUtils.getHumanizedNameString(mavenRepository), (Object)e);
        }
    }

    protected void handlePrefixFileRemoval(RepositoryItemEvent evt) {
        MavenRepository mavenRepository = (MavenRepository)evt.getRepository();
        try {
            this.manager.unpublish(mavenRepository);
        }
        catch (IOException e) {
            this.getLogger().warn("Problem while unpublishing prefix file for repository {}", (Object)RepositoryStringUtils.getHumanizedNameString(mavenRepository), (Object)e);
        }
    }

    protected void offerPath(MavenHostedRepository mavenHostedRepository, StorageItem item) {
        try {
            this.manager.offerEntry(mavenHostedRepository, item);
        }
        catch (IOException e) {
            this.getLogger().warn("Problem while maintaining prefix file for hosted repository {}, offered entry={}", new Object[]{RepositoryStringUtils.getHumanizedNameString(mavenHostedRepository), item, e});
        }
    }

    protected void revokePath(MavenHostedRepository mavenHostedRepository, StorageItem item) {
        try {
            this.manager.revokeEntry(mavenHostedRepository, item);
        }
        catch (IOException e) {
            this.getLogger().warn("Problem while maintaining prefix file for hosted repository {}, revoked entry={}", new Object[]{RepositoryStringUtils.getHumanizedNameString(mavenHostedRepository), item, e});
        }
    }

    protected boolean isRequestContextMarked(RequestContext context) {
        return context.containsKey(Manager.ROUTING_INITIATED_FILE_OPERATION_FLAG_KEY);
    }

    protected boolean isRepositoryHandled(Repository repository) {
        return repository != null && repository.getRepositoryKind().isFacetAvailable(MavenRepository.class) && !repository.getRepositoryKind().isFacetAvailable(ShadowRepository.class) && "maven2".equals(repository.getRepositoryContentClass().getId());
    }

    protected boolean isPrefixFileEvent(RepositoryItemEvent evt) {
        return this.isRepositoryHandled(evt.getRepository()) && !this.isRequestContextMarked(evt.getItem().getItemContext()) && this.manager.isEventAboutPrefixFile(evt);
    }

    protected boolean isPlainItemEvent(RepositoryItemEvent evt) {
        return this.isRepositoryHandled(evt.getRepository()) && !this.isRequestContextMarked(evt.getItem().getItemContext()) && !evt.getItem().getRepositoryItemUid().getBooleanAttributeValue(IsHiddenAttribute.class);
    }

    protected boolean isPlainFileItemEvent(RepositoryItemEvent evt) {
        return this.isPlainItemEvent(evt) && evt.getItem() instanceof StorageFileItem;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRepositoryItemEventStore(RepositoryItemEventStore evt) {
        MavenHostedRepository mavenHostedRepository;
        if (this.isPrefixFileEvent(evt)) {
            this.handlePrefixFileUpdate(evt);
        } else if (this.isPlainFileItemEvent(evt) && (mavenHostedRepository = evt.getRepository().adaptToFacet(MavenHostedRepository.class)) != null) {
            this.offerPath(mavenHostedRepository, evt.getItem());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRepositoryItemEventCache(RepositoryItemEventCache evt) {
        MavenHostedRepository mavenHostedRepository;
        if (this.isPrefixFileEvent(evt)) {
            this.handlePrefixFileUpdate(evt);
        } else if (this.isPlainFileItemEvent(evt) && (mavenHostedRepository = evt.getRepository().adaptToFacet(MavenHostedRepository.class)) != null) {
            this.offerPath(mavenHostedRepository, evt.getItem());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRepositoryItemEventDelete(RepositoryItemEventDelete evt) {
        MavenHostedRepository mavenHostedRepository;
        if (this.isPrefixFileEvent(evt)) {
            this.handlePrefixFileRemoval(evt);
        } else if (evt instanceof RepositoryItemEventDeleteRoot && this.isPlainItemEvent(evt) && (mavenHostedRepository = evt.getRepository().adaptToFacet(MavenHostedRepository.class)) != null) {
            this.revokePath(mavenHostedRepository, evt.getItem());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRepositoryRegistryEventAdd(RepositoryRegistryEventAdd evt) {
        if (this.isRepositoryHandled(evt.getRepository())) {
            MavenRepository mavenRepository = evt.getRepository().adaptToFacet(MavenRepository.class);
            this.handleRepositoryAdded(mavenRepository);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRepositoryConfigurationUpdatedEvent(RepositoryConfigurationUpdatedEvent evt) {
        if (this.isRepositoryHandled(evt.getRepository())) {
            MavenRepository mavenRepository = evt.getRepository().adaptToFacet(MavenRepository.class);
            this.handleRepositoryModified(mavenRepository);
        }
    }
}

