/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.proxy.maven.routing.Config;
import org.sonatype.nexus.util.SystemPropertiesHelper;

@Named
@Singleton
public class ConfigImpl
implements Config {
    public static final String FEATURE_ACTIVE_KEY = Config.class.getName() + ".featureActive";
    private static final String LOCAL_PREFIX_FILE_PATH = "/.meta/prefixes.txt";
    private static final int REMOTE_SCRAPE_DEPTH = SystemPropertiesHelper.getInteger(Config.class.getName() + ".remoteScrapeDepth", 2);
    private static final int LOCAL_SCRAPE_DEPTH = SystemPropertiesHelper.getInteger(Config.class.getName() + ".localScrapeDepth", 2);
    private static final int PREFIX_FILE_MAX_ENTRY_COUNT = SystemPropertiesHelper.getInteger(Config.class.getName() + ".prefixFileMaxEntryCount", 10000);
    private static final int PREFIX_FILE_MAX_LINE_LENGTH = SystemPropertiesHelper.getInteger(Config.class.getName() + ".prefixFileMaxLineLength", 250);
    private static final int PREFIX_FILE_MAX_SIZE = SystemPropertiesHelper.getInteger(Config.class.getName() + ".prefixFileMaxSize", 100000);
    private final boolean featureActive;

    public ConfigImpl() {
        this(SystemPropertiesHelper.getBoolean(FEATURE_ACTIVE_KEY, true));
    }

    public ConfigImpl(boolean featureActive) {
        this.featureActive = featureActive;
    }

    @Override
    public boolean isFeatureActive() {
        return this.featureActive;
    }

    @Override
    public String getLocalPrefixFilePath() {
        return LOCAL_PREFIX_FILE_PATH;
    }

    @Override
    public String getRemotePrefixFilePath() {
        return LOCAL_PREFIX_FILE_PATH;
    }

    @Override
    public int getRemoteScrapeDepth() {
        return REMOTE_SCRAPE_DEPTH;
    }

    @Override
    public int getLocalScrapeDepth() {
        return LOCAL_SCRAPE_DEPTH;
    }

    @Override
    public int getPrefixFileMaxEntriesCount() {
        return PREFIX_FILE_MAX_ENTRY_COUNT;
    }

    @Override
    public int getPrefixFileMaxLineLength() {
        return PREFIX_FILE_MAX_LINE_LENGTH;
    }

    @Override
    public int getPrefixFileMaxSize() {
        return PREFIX_FILE_MAX_SIZE;
    }
}

