/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.proxy.maven.routing.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.proxy.maven.routing.PrefixSource;

public class ArrayListPrefixSource
implements PrefixSource {
    private final List<String> entries;
    private final long created;

    public ArrayListPrefixSource(List<String> entries) {
        this(entries, System.currentTimeMillis());
    }

    public ArrayListPrefixSource(List<String> entries, long created) {
        this.entries = Collections.unmodifiableList((List)Preconditions.checkNotNull(entries));
        this.created = created;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean supported() {
        return true;
    }

    @Override
    public List<String> readEntries() throws IOException {
        return this.entries;
    }

    @Override
    public long getLostModifiedTimestamp() {
        return this.created;
    }
}

